/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connectors.hive.HiveLookupTableSource;
import org.apache.flink.connectors.hive.HiveTableSink;
import org.apache.flink.connectors.hive.HiveTableSource;
import org.apache.flink.connectors.hive.util.JobConfUtils;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.filesystem.FileSystemConnectorOptions;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapred.JobConf;

public class HiveDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private final HiveConf hiveConf;

    public HiveDynamicTableFactory(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
    }

    public String factoryIdentifier() {
        throw new UnsupportedOperationException("Hive factory is only work for catalog.");
    }

    public Set<ConfigOption<?>> requiredOptions() {
        throw new UnsupportedOperationException("Hive factory is only work for catalog.");
    }

    public Set<ConfigOption<?>> optionalOptions() {
        throw new UnsupportedOperationException("Hive factory is only work for catalog.");
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        boolean isHiveTable = HiveCatalog.isHiveTable(context.getCatalogTable().getOptions());
        if (isHiveTable && !context.isTemporary()) {
            Integer configuredParallelism = (Integer)Configuration.fromMap((Map)context.getCatalogTable().getOptions()).get(FileSystemConnectorOptions.SINK_PARALLELISM);
            JobConf jobConf = JobConfUtils.createJobConfWithCredentials(this.hiveConf);
            return new HiveTableSink(context.getConfiguration(), jobConf, context.getObjectIdentifier(), (CatalogTable)context.getCatalogTable(), configuredParallelism);
        }
        return FactoryUtil.createTableSink(null, (ObjectIdentifier)context.getObjectIdentifier(), (ResolvedCatalogTable)context.getCatalogTable(), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        boolean isHiveTable = HiveCatalog.isHiveTable(context.getCatalogTable().getOptions());
        if (isHiveTable && !context.isTemporary()) {
            CatalogTable catalogTable = (CatalogTable)Preconditions.checkNotNull((Object)context.getCatalogTable());
            boolean isStreamingSource = Boolean.parseBoolean(catalogTable.getOptions().getOrDefault(FileSystemConnectorOptions.STREAMING_SOURCE_ENABLE.key(), ((Boolean)FileSystemConnectorOptions.STREAMING_SOURCE_ENABLE.defaultValue()).toString()));
            boolean includeAllPartition = ((String)FileSystemConnectorOptions.STREAMING_SOURCE_PARTITION_INCLUDE.defaultValue()).equals(catalogTable.getOptions().getOrDefault(FileSystemConnectorOptions.STREAMING_SOURCE_PARTITION_INCLUDE.key(), FileSystemConnectorOptions.STREAMING_SOURCE_PARTITION_INCLUDE.defaultValue()));
            JobConf jobConf = JobConfUtils.createJobConfWithCredentials(this.hiveConf);
            if (isStreamingSource && includeAllPartition) {
                return new HiveTableSource(jobConf, context.getConfiguration(), context.getObjectIdentifier().toObjectPath(), catalogTable);
            }
            return new HiveLookupTableSource(jobConf, context.getConfiguration(), context.getObjectIdentifier().toObjectPath(), catalogTable);
        }
        return FactoryUtil.createTableSource(null, (ObjectIdentifier)context.getObjectIdentifier(), (ResolvedCatalogTable)context.getCatalogTable(), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
    }
}

