/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.functions.hive.DeferredObjectAdapter;
import org.apache.flink.table.functions.hive.FlinkHiveUDFException;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.HiveScalarFunction;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HiveGenericUDF
extends HiveScalarFunction<GenericUDF> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveGenericUDF.class);
    private transient GenericUDF.DeferredObject[] deferredObjects;
    private HiveShim hiveShim;

    public HiveGenericUDF(HiveFunctionWrapper<GenericUDF> hiveFunctionWrapper, HiveShim hiveShim) {
        super(hiveFunctionWrapper);
        this.hiveShim = hiveShim;
        LOG.info("Creating HiveGenericUDF from '{}'", (Object)hiveFunctionWrapper.getClassName());
    }

    @Override
    public void openInternal() {
        LOG.info("Open HiveGenericUDF as {}", (Object)this.hiveFunctionWrapper.getClassName());
        this.function = this.hiveFunctionWrapper.createFunction();
        ObjectInspector[] argInspectors = HiveInspectors.toInspectors(this.hiveShim, this.constantArguments, this.argTypes);
        try {
            this.returnInspector = ((GenericUDF)this.function).initializeAndFoldConstants(argInspectors);
        }
        catch (UDFArgumentException e) {
            throw new FlinkHiveUDFException(e);
        }
        this.deferredObjects = new GenericUDF.DeferredObject[this.argTypes.length];
        for (int i = 0; i < this.deferredObjects.length; ++i) {
            this.deferredObjects[i] = new DeferredObjectAdapter(argInspectors[i], this.argTypes[i].getLogicalType(), this.hiveShim);
        }
    }

    @Override
    public Object evalInternal(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            ((DeferredObjectAdapter)this.deferredObjects[i]).set(args[i]);
        }
        try {
            Object result = this.returnInspector instanceof ConstantObjectInspector ? ((ConstantObjectInspector)this.returnInspector).getWritableConstantValue() : ((GenericUDF)this.function).evaluate(this.deferredObjects);
            return HiveInspectors.toFlinkObject(this.returnInspector, result, this.hiveShim);
        }
        catch (HiveException e) {
            throw new FlinkHiveUDFException(e);
        }
    }

    @Override
    public DataType getHiveResultType(Object[] constantArguments, DataType[] argTypes) {
        LOG.info("Getting result type of HiveGenericUDF from {}", (Object)this.hiveFunctionWrapper.getClassName());
        try {
            ObjectInspector[] argumentInspectors = HiveInspectors.toInspectors(this.hiveShim, constantArguments, argTypes);
            ObjectInspector resultObjectInspector = ((GenericUDF)this.hiveFunctionWrapper.createFunction()).initializeAndFoldConstants(argumentInspectors);
            return HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromObjectInspector(resultObjectInspector));
        }
        catch (UDFArgumentException e) {
            throw new FlinkHiveUDFException(e);
        }
    }
}

