/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveShimV101;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Reporter;

public class HiveShimV110
extends HiveShimV101 {
    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jobConf, Class outputFormatClz, Class<? extends Writable> outValClz, boolean isCompressed, Properties tableProps, Path outPath) {
        try {
            Class<HiveFileFormatUtils> utilClass = HiveFileFormatUtils.class;
            OutputFormat outputFormat = (OutputFormat)outputFormatClz.newInstance();
            Method utilMethod = utilClass.getDeclaredMethod("getRecordWriter", JobConf.class, OutputFormat.class, Class.class, Boolean.TYPE, Properties.class, Path.class, Reporter.class);
            return (FileSinkOperator.RecordWriter)utilMethod.invoke(null, jobConf, outputFormat, outValClz, isCompressed, tableProps, outPath, Reporter.NULL);
        }
        catch (Exception e) {
            throw new CatalogException("Failed to create Hive RecordWriter", (Throwable)e);
        }
    }

    @Override
    public Class getHiveOutputFormatClass(Class outputFormatClz) {
        try {
            Class<HiveFileFormatUtils> utilClass = HiveFileFormatUtils.class;
            Method utilMethod = utilClass.getDeclaredMethod("getOutputFormatSubstitute", Class.class);
            Class res = (Class)utilMethod.invoke(null, outputFormatClz);
            Preconditions.checkState((res != null ? 1 : 0) != 0, (Object)("No Hive substitute output format for " + outputFormatClz));
            return res;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new FlinkHiveException("Failed to get HiveOutputFormat for " + outputFormatClz, e);
        }
    }

    @Override
    public List<FieldSchema> getFieldsFromDeserializer(Configuration conf, Table table, boolean skipConfError) {
        try {
            Method utilMethod = this.getHiveMetaStoreUtilsClass().getMethod("getDeserializer", Configuration.class, Table.class, Boolean.TYPE);
            Deserializer deserializer = (Deserializer)utilMethod.invoke(null, conf, table, skipConfError);
            utilMethod = this.getHiveMetaStoreUtilsClass().getMethod("getFieldsFromDeserializer", String.class, Deserializer.class);
            return (List)utilMethod.invoke(null, table.getTableName(), deserializer);
        }
        catch (Exception e) {
            throw new CatalogException("Failed to get table schema from deserializer", (Throwable)e);
        }
    }
}

