/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.client;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.thrift.TException;

public interface HiveShim
extends Serializable {
    public IMetaStoreClient getHiveMetastoreClient(HiveConf var1);

    public List<String> getViews(IMetaStoreClient var1, String var2) throws UnknownDBException, TException;

    public void alterTable(IMetaStoreClient var1, String var2, String var3, Table var4) throws InvalidOperationException, MetaException, TException;

    public void alterPartition(IMetaStoreClient var1, String var2, String var3, Partition var4) throws InvalidOperationException, MetaException, TException;

    public SimpleGenericUDAFParameterInfo createUDAFParameterInfo(ObjectInspector[] var1, boolean var2, boolean var3, boolean var4);

    public Class<?> getMetaStoreUtilsClass();

    public Class<?> getHiveMetaStoreUtilsClass();

    public Class<?> getDateDataTypeClass();

    public Class<?> getTimestampDataTypeClass();

    public ColumnStatisticsData toHiveDateColStats(CatalogColumnStatisticsDataDate var1);

    public boolean isDateStats(ColumnStatisticsData var1);

    public CatalogColumnStatisticsDataDate toFlinkDateColStats(ColumnStatisticsData var1);

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf var1, Class var2, Class<? extends Writable> var3, boolean var4, Properties var5, Path var6);

    public Class getHiveOutputFormatClass(Class var1);

    public List<FieldSchema> getFieldsFromDeserializer(Configuration var1, Table var2, boolean var3);

    public Set<String> listBuiltInFunctions();

    public Optional<FunctionInfo> getBuiltInFunctionInfo(String var1);

    public Set<String> getNotNullColumns(IMetaStoreClient var1, Configuration var2, String var3, String var4);

    public Optional<UniqueConstraint> getPrimaryKey(IMetaStoreClient var1, String var2, String var3, byte var4);

    @Nullable
    public Object toHiveTimestamp(@Nullable Object var1);

    public LocalDateTime toFlinkTimestamp(Object var1);

    @Nullable
    public Object toHiveDate(@Nullable Object var1);

    public LocalDate toFlinkDate(Object var1);

    @Nullable
    public Writable hivePrimitiveToWritable(@Nullable Object var1);

    public void createTableWithConstraints(IMetaStoreClient var1, Table var2, Configuration var3, UniqueConstraint var4, List<Byte> var5, List<String> var6, List<Byte> var7);

    public BulkWriter.Factory<RowData> createOrcBulkWriterFactory(Configuration var1, String var2, LogicalType[] var3);
}

