/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcColumnarRowSplitReader;
import org.apache.flink.orc.OrcSplitReader;
import org.apache.flink.orc.OrcSplitReaderUtil;
import org.apache.flink.orc.vector.RowDataVectorizer;
import org.apache.flink.orc.writer.OrcBulkWriterFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.FileSystemFormatFactory;
import org.apache.flink.table.filesystem.RowPartitionComputer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.TypeDescription;

public class OrcFileSystemFormatFactory
implements FileSystemFormatFactory {
    public static final String IDENTIFIER = "orc";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new HashSet();
    }

    private static Properties getOrcProperties(ReadableConfig options) {
        Properties orcProperties = new Properties();
        Properties properties = new Properties();
        ((Configuration)options).addAllToProperties(properties);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> orcProperties.put("orc." + k, v)));
        return orcProperties;
    }

    public InputFormat<RowData, ?> createReader(FileSystemFormatFactory.ReaderContext context) {
        return new OrcRowDataInputFormat(context.getPaths(), context.getSchema().getFieldNames(), context.getSchema().getFieldDataTypes(), context.getProjectFields(), context.getDefaultPartName(), context.getPushedDownLimit(), OrcFileSystemFormatFactory.getOrcProperties(context.getFormatOptions()));
    }

    public Optional<BulkWriter.Factory<RowData>> createBulkWriterFactory(FileSystemFormatFactory.WriterContext context) {
        LogicalType[] orcTypes = (LogicalType[])Arrays.stream(context.getFormatFieldTypes()).map(DataType::getLogicalType).toArray(LogicalType[]::new);
        TypeDescription typeDescription = OrcSplitReaderUtil.logicalTypeToOrcType((LogicalType)RowType.of((LogicalType[])orcTypes, (String[])context.getFormatFieldNames()));
        OrcBulkWriterFactory<RowData> factory = new OrcBulkWriterFactory<RowData>(new RowDataVectorizer(typeDescription.toString(), orcTypes), OrcFileSystemFormatFactory.getOrcProperties(context.getFormatOptions()), new org.apache.hadoop.conf.Configuration());
        return Optional.of(factory);
    }

    public Optional<Encoder<RowData>> createEncoder(FileSystemFormatFactory.WriterContext context) {
        return Optional.empty();
    }

    public static class OrcRowDataInputFormat
    extends FileInputFormat<RowData> {
        private static final long serialVersionUID = 1L;
        private final String[] fullFieldNames;
        private final DataType[] fullFieldTypes;
        private final int[] selectedFields;
        private final String partDefaultName;
        private final Properties properties;
        private final long limit;
        private transient OrcColumnarRowSplitReader<VectorizedRowBatch> reader;
        private transient long currentReadCount;

        public OrcRowDataInputFormat(Path[] paths, String[] fullFieldNames, DataType[] fullFieldTypes, int[] selectedFields, String partDefaultName, long limit, Properties properties) {
            super.setFilePaths(paths);
            this.limit = limit;
            this.partDefaultName = partDefaultName;
            this.fullFieldNames = fullFieldNames;
            this.fullFieldTypes = fullFieldTypes;
            this.selectedFields = selectedFields;
            this.properties = properties;
        }

        public void open(FileInputSplit fileSplit) throws IOException {
            List<String> fieldNameList = Arrays.asList(this.fullFieldNames);
            LinkedHashMap partSpec = PartitionPathUtils.extractPartitionSpecFromPath((Path)fileSplit.getPath());
            LinkedHashMap<String, Object> partObjects = new LinkedHashMap<String, Object>();
            partSpec.forEach((k, v) -> partObjects.put((String)k, RowPartitionComputer.restorePartValueFromType((String)(this.partDefaultName.equals(v) ? null : v), (DataType)this.fullFieldTypes[fieldNameList.indexOf(k)])));
            org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
            this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> conf.set(k.toString(), v.toString())));
            this.reader = OrcSplitReaderUtil.genPartColumnarRowReader("3.1.1", conf, this.fullFieldNames, this.fullFieldTypes, partObjects, this.selectedFields, new ArrayList<OrcSplitReader.Predicate>(), 2048, new Path(fileSplit.getPath().toString()), fileSplit.getStart(), fileSplit.getLength());
            this.currentReadCount = 0L;
        }

        public boolean supportsMultiPaths() {
            return true;
        }

        public boolean reachedEnd() throws IOException {
            if (this.currentReadCount >= this.limit) {
                return true;
            }
            return this.reader.reachedEnd();
        }

        public RowData nextRecord(RowData reuse) {
            ++this.currentReadCount;
            return this.reader.nextRecord(reuse);
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
        }
    }
}

