/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.column.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.flink.hive.shaded.parquet.column.ColumnDescriptor;
import org.apache.flink.hive.shaded.parquet.column.ColumnWriteStore;
import org.apache.flink.hive.shaded.parquet.column.ColumnWriter;
import org.apache.flink.hive.shaded.parquet.column.ParquetProperties;
import org.apache.flink.hive.shaded.parquet.column.impl.ColumnWriterV1;
import org.apache.flink.hive.shaded.parquet.column.page.PageWriteStore;
import org.apache.flink.hive.shaded.parquet.column.page.PageWriter;

public class ColumnWriteStoreV1
implements ColumnWriteStore {
    private final Map<ColumnDescriptor, ColumnWriterV1> columns = new TreeMap<ColumnDescriptor, ColumnWriterV1>();
    private final PageWriteStore pageWriteStore;
    private final ParquetProperties props;

    public ColumnWriteStoreV1(PageWriteStore pageWriteStore, ParquetProperties props) {
        this.pageWriteStore = pageWriteStore;
        this.props = props;
    }

    @Override
    public ColumnWriter getColumnWriter(ColumnDescriptor path) {
        ColumnWriterV1 column = this.columns.get(path);
        if (column == null) {
            column = this.newMemColumn(path);
            this.columns.put(path, column);
        }
        return column;
    }

    public Set<ColumnDescriptor> getColumnDescriptors() {
        return this.columns.keySet();
    }

    private ColumnWriterV1 newMemColumn(ColumnDescriptor path) {
        PageWriter pageWriter = this.pageWriteStore.getPageWriter(path);
        return new ColumnWriterV1(path, pageWriter, this.props);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ColumnDescriptor, ColumnWriterV1> entry : this.columns.entrySet()) {
            sb.append(Arrays.toString(entry.getKey().getPath())).append(": ");
            sb.append(entry.getValue().getBufferedSizeInMemory()).append(" bytes");
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public long getAllocatedSize() {
        Collection<ColumnWriterV1> values = this.columns.values();
        long total = 0L;
        for (ColumnWriterV1 memColumn : values) {
            total += memColumn.allocatedSize();
        }
        return total;
    }

    @Override
    public long getBufferedSize() {
        Collection<ColumnWriterV1> values = this.columns.values();
        long total = 0L;
        for (ColumnWriterV1 memColumn : values) {
            total += memColumn.getBufferedSizeInMemory();
        }
        return total;
    }

    @Override
    public String memUsageString() {
        StringBuilder b = new StringBuilder("Store {\n");
        Collection<ColumnWriterV1> values = this.columns.values();
        for (ColumnWriterV1 memColumn : values) {
            b.append(memColumn.memUsageString(" "));
        }
        b.append("}\n");
        return b.toString();
    }

    public long maxColMemSize() {
        Collection<ColumnWriterV1> values = this.columns.values();
        long max = 0L;
        for (ColumnWriterV1 memColumn : values) {
            max = Math.max(max, memColumn.getBufferedSizeInMemory());
        }
        return max;
    }

    @Override
    public void flush() {
        Collection<ColumnWriterV1> values = this.columns.values();
        for (ColumnWriterV1 memColumn : values) {
            memColumn.flush();
        }
    }

    @Override
    public void endRecord() {
    }

    @Override
    public void close() {
        Collection<ColumnWriterV1> values = this.columns.values();
        for (ColumnWriterV1 memColumn : values) {
            memColumn.close();
        }
    }
}

