/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.parquet.column.impl;

import org.apache.flink.hive.shaded.parquet.VersionParser;
import org.apache.flink.hive.shaded.parquet.column.ColumnDescriptor;
import org.apache.flink.hive.shaded.parquet.column.ColumnReadStore;
import org.apache.flink.hive.shaded.parquet.column.ColumnReader;
import org.apache.flink.hive.shaded.parquet.column.impl.ColumnReaderImpl;
import org.apache.flink.hive.shaded.parquet.column.page.PageReadStore;
import org.apache.flink.hive.shaded.parquet.column.page.PageReader;
import org.apache.flink.hive.shaded.parquet.io.api.Converter;
import org.apache.flink.hive.shaded.parquet.io.api.GroupConverter;
import org.apache.flink.hive.shaded.parquet.io.api.PrimitiveConverter;
import org.apache.flink.hive.shaded.parquet.schema.GroupType;
import org.apache.flink.hive.shaded.parquet.schema.MessageType;
import org.apache.flink.hive.shaded.parquet.schema.Type;

public class ColumnReadStoreImpl
implements ColumnReadStore {
    private final PageReadStore pageReadStore;
    private final GroupConverter recordConverter;
    private final MessageType schema;
    private final VersionParser.ParsedVersion writerVersion;

    public ColumnReadStoreImpl(PageReadStore pageReadStore, GroupConverter recordConverter, MessageType schema, String createdBy) {
        VersionParser.ParsedVersion version;
        this.pageReadStore = pageReadStore;
        this.recordConverter = recordConverter;
        this.schema = schema;
        try {
            version = VersionParser.parse(createdBy);
        }
        catch (RuntimeException e) {
            version = null;
        }
        catch (VersionParser.VersionParseException e) {
            version = null;
        }
        this.writerVersion = version;
    }

    @Override
    public ColumnReader getColumnReader(ColumnDescriptor path) {
        return this.newMemColumnReader(path, this.pageReadStore.getPageReader(path));
    }

    private ColumnReaderImpl newMemColumnReader(ColumnDescriptor path, PageReader pageReader) {
        PrimitiveConverter converter = this.getPrimitiveConverter(path);
        return new ColumnReaderImpl(path, pageReader, converter, this.writerVersion);
    }

    private PrimitiveConverter getPrimitiveConverter(ColumnDescriptor path) {
        Type currentType = this.schema;
        Converter currentConverter = this.recordConverter;
        for (String fieldName : path.getPath()) {
            GroupType groupType = currentType.asGroupType();
            int fieldIndex = groupType.getFieldIndex(fieldName);
            currentType = groupType.getType(fieldName);
            currentConverter = ((Converter)currentConverter).asGroupConverter().getConverter(fieldIndex);
        }
        PrimitiveConverter converter = currentConverter.asPrimitiveConverter();
        return converter;
    }
}

