/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.fs.hdfs;

import java.io.IOException;
import java.util.UUID;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.hive.shaded.fs.hdfs.HadoopFileSystem;
import org.apache.flink.hive.shaded.fs.hdfs.HadoopFsRecoverable;
import org.apache.flink.hive.shaded.fs.hdfs.HadoopRecoverableFsDataOutputStream;
import org.apache.flink.hive.shaded.fs.hdfs.HadoopRecoverableSerializer;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HadoopRecoverableWriter
implements RecoverableWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopRecoverableWriter.class);
    private final FileSystem fs;

    public HadoopRecoverableWriter(FileSystem fs) {
        this.fs = (FileSystem)Preconditions.checkNotNull((Object)fs);
        if (!"hdfs".equalsIgnoreCase(fs.getScheme())) {
            throw new UnsupportedOperationException("Recoverable writers on Hadoop are only supported for HDFS");
        }
        if (!HadoopUtils.isMinHadoopVersion(2, 7)) {
            LOG.warn("WARNING: You are running on hadoop version " + VersionInfo.getVersion() + ". If your RollingPolicy does not roll on every checkpoint/savepoint, the StreamingFileSink will throw an exception upon recovery.");
        }
    }

    public RecoverableFsDataOutputStream open(Path filePath) throws IOException {
        org.apache.hadoop.fs.Path targetFile = HadoopFileSystem.toHadoopPath(filePath);
        org.apache.hadoop.fs.Path tempFile = HadoopRecoverableWriter.generateStagingTempFilePath(this.fs, targetFile);
        return new HadoopRecoverableFsDataOutputStream(this.fs, targetFile, tempFile);
    }

    public RecoverableFsDataOutputStream recover(RecoverableWriter.ResumeRecoverable recoverable) throws IOException {
        if (recoverable instanceof HadoopFsRecoverable) {
            return new HadoopRecoverableFsDataOutputStream(this.fs, (HadoopFsRecoverable)recoverable);
        }
        throw new IllegalArgumentException("Hadoop File System cannot recover a recoverable for another file system: " + recoverable);
    }

    public boolean requiresCleanupOfRecoverableState() {
        return false;
    }

    public boolean cleanupRecoverableState(RecoverableWriter.ResumeRecoverable resumable) throws IOException {
        return false;
    }

    public RecoverableFsDataOutputStream.Committer recoverForCommit(RecoverableWriter.CommitRecoverable recoverable) throws IOException {
        if (recoverable instanceof HadoopFsRecoverable) {
            return new HadoopRecoverableFsDataOutputStream.HadoopFsCommitter(this.fs, (HadoopFsRecoverable)recoverable);
        }
        throw new IllegalArgumentException("Hadoop File System  cannot recover a recoverable for another file system: " + recoverable);
    }

    public SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> getCommitRecoverableSerializer() {
        HadoopRecoverableSerializer typedSerializer = HadoopRecoverableSerializer.INSTANCE;
        return typedSerializer;
    }

    public SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> getResumeRecoverableSerializer() {
        HadoopRecoverableSerializer typedSerializer = HadoopRecoverableSerializer.INSTANCE;
        return typedSerializer;
    }

    public boolean supportsResume() {
        return true;
    }

    @VisibleForTesting
    static org.apache.hadoop.fs.Path generateStagingTempFilePath(FileSystem fs, org.apache.hadoop.fs.Path targetFile) throws IOException {
        org.apache.hadoop.fs.Path candidate;
        Preconditions.checkArgument((boolean)targetFile.isAbsolute(), (Object)"targetFile must be absolute");
        org.apache.hadoop.fs.Path parent = targetFile.getParent();
        String name = targetFile.getName();
        Preconditions.checkArgument((parent != null ? 1 : 0) != 0, (Object)"targetFile must not be the root directory");
        while (fs.exists(candidate = new org.apache.hadoop.fs.Path(parent, "." + name + ".inprogress." + UUID.randomUUID().toString()))) {
        }
        return candidate;
    }
}

