/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.formats.parquet.utils;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.hive.shaded.formats.parquet.utils.ParentDataHolder;
import org.apache.flink.hive.shaded.formats.parquet.utils.ParquetTimestampUtils;
import org.apache.flink.hive.shaded.parquet.io.api.Binary;
import org.apache.flink.hive.shaded.parquet.io.api.Converter;
import org.apache.flink.hive.shaded.parquet.io.api.GroupConverter;
import org.apache.flink.hive.shaded.parquet.io.api.PrimitiveConverter;
import org.apache.flink.hive.shaded.parquet.schema.GroupType;
import org.apache.flink.hive.shaded.parquet.schema.MessageType;
import org.apache.flink.hive.shaded.parquet.schema.OriginalType;
import org.apache.flink.hive.shaded.parquet.schema.PrimitiveType;
import org.apache.flink.hive.shaded.parquet.schema.Type;
import org.apache.flink.types.Row;

public class RowConverter
extends GroupConverter
implements ParentDataHolder {
    private final Converter[] converters;
    private final ParentDataHolder parentDataHolder;
    private final TypeInformation<?> typeInfo;
    private Row currentRow;
    private int posInParentRow;

    public RowConverter(MessageType messageType, TypeInformation<?> typeInfo) {
        this(messageType, typeInfo, null, 0);
    }

    public RowConverter(GroupType schema, TypeInformation<?> typeInfo, ParentDataHolder parent, int pos) {
        this.typeInfo = typeInfo;
        this.parentDataHolder = parent;
        this.posInParentRow = pos;
        this.converters = new Converter[schema.getFieldCount()];
        int i = 0;
        if (typeInfo.getArity() >= 1 && typeInfo instanceof CompositeType) {
            for (Type field : schema.getFields()) {
                this.converters[i] = RowConverter.createConverter(field, i, ((CompositeType)typeInfo).getTypeAt(i), this);
                ++i;
            }
        }
    }

    private static Converter createConverter(Type field, int fieldPos, TypeInformation<?> typeInformation, ParentDataHolder parentDataHolder) {
        if (field.isPrimitive()) {
            return new RowPrimitiveConverter(field, parentDataHolder, fieldPos);
        }
        if (typeInformation instanceof MapTypeInfo) {
            return new MapConverter((GroupType)field, (MapTypeInfo)typeInformation, parentDataHolder, fieldPos);
        }
        if (typeInformation instanceof BasicArrayTypeInfo) {
            Type elementType = field.asGroupType().getFields().get(0);
            Class typeClass = ((BasicArrayTypeInfo)typeInformation).getComponentInfo().getTypeClass();
            if (typeClass.equals(Character.class)) {
                return new ArrayConverter(elementType, Character.class, (TypeInformation)BasicTypeInfo.CHAR_TYPE_INFO, parentDataHolder, fieldPos);
            }
            if (typeClass.equals(Boolean.class)) {
                return new ArrayConverter(elementType, Boolean.class, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO, parentDataHolder, fieldPos);
            }
            if (typeClass.equals(Short.class)) {
                return new ArrayConverter(elementType, Short.class, (TypeInformation)BasicTypeInfo.SHORT_TYPE_INFO, parentDataHolder, fieldPos);
            }
            if (typeClass.equals(Integer.class)) {
                return new ArrayConverter(elementType, Integer.class, (TypeInformation)BasicTypeInfo.INSTANT_TYPE_INFO, parentDataHolder, fieldPos);
            }
            if (typeClass.equals(Long.class)) {
                return new ArrayConverter(elementType, Long.class, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, parentDataHolder, fieldPos);
            }
            if (typeClass.equals(Double.class)) {
                return new ArrayConverter(elementType, Double.class, (TypeInformation)BasicTypeInfo.DOUBLE_TYPE_INFO, parentDataHolder, fieldPos);
            }
            if (typeClass.equals(String.class)) {
                return new ArrayConverter(elementType, String.class, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, parentDataHolder, fieldPos);
            }
            if (typeClass.equals(Date.class)) {
                return new ArrayConverter(elementType, Date.class, (TypeInformation)SqlTimeTypeInfo.DATE, parentDataHolder, fieldPos);
            }
            if (typeClass.equals(Time.class)) {
                return new ArrayConverter(elementType, Time.class, (TypeInformation)SqlTimeTypeInfo.TIME, parentDataHolder, fieldPos);
            }
            if (typeClass.equals(Timestamp.class)) {
                return new ArrayConverter(elementType, Timestamp.class, (TypeInformation)SqlTimeTypeInfo.TIMESTAMP, parentDataHolder, fieldPos);
            }
            if (typeClass.equals(BigDecimal.class)) {
                return new ArrayConverter(elementType, BigDecimal.class, (TypeInformation)BasicTypeInfo.BIG_DEC_TYPE_INFO, parentDataHolder, fieldPos);
            }
            throw new IllegalArgumentException(String.format("Can't create converter unsupported primitive array type for %s", typeClass.toString()));
        }
        if (typeInformation instanceof ObjectArrayTypeInfo) {
            GroupType parquetGroupType = field.asGroupType();
            Type elementType = parquetGroupType.getType(0);
            return new ArrayConverter(elementType, Row.class, ((ObjectArrayTypeInfo)typeInformation).getComponentInfo(), parentDataHolder, fieldPos);
        }
        if (typeInformation instanceof RowTypeInfo) {
            return new RowConverter((GroupType)field, typeInformation, parentDataHolder, fieldPos);
        }
        throw new IllegalArgumentException(String.format("Can't create converter for field %s with type %s ", field.getName(), typeInformation.toString()));
    }

    @Override
    public Converter getConverter(int i) {
        return this.converters[i];
    }

    @Override
    public void start() {
        this.currentRow = new Row(this.typeInfo.getArity());
    }

    public Row getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public void end() {
        if (this.parentDataHolder != null) {
            this.parentDataHolder.add(this.posInParentRow, this.currentRow);
        }
    }

    @Override
    public void add(int fieldIndex, Object object) {
        this.currentRow.setField(fieldIndex, object);
    }

    static class MapConverter
    extends GroupConverter {
        private final ParentDataHolder parentDataHolder;
        private final Converter keyValueConverter;
        private final int pos;
        private Map<Object, Object> map;

        MapConverter(GroupType type, MapTypeInfo typeInfo, ParentDataHolder parentDataHolder, int pos) {
            this.parentDataHolder = parentDataHolder;
            this.pos = pos;
            this.keyValueConverter = new MapKeyValueConverter((GroupType)type.getType(0), typeInfo);
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.keyValueConverter;
        }

        @Override
        public void start() {
            this.map = new HashMap<Object, Object>();
        }

        @Override
        public void end() {
            this.parentDataHolder.add(this.pos, this.map);
        }

        final class MapKeyValueConverter
        extends GroupConverter {
            private final Converter keyConverter;
            private final Converter valueConverter;
            private Object key;
            private Object value;

            MapKeyValueConverter(GroupType groupType, MapTypeInfo typeInfo) {
                this.keyConverter = RowConverter.createConverter(groupType.getType(0), 0, typeInfo.getKeyTypeInfo(), (fieldIndex, object) -> {
                    this.key = object;
                });
                this.valueConverter = RowConverter.createConverter(groupType.getType(1), 1, typeInfo.getValueTypeInfo(), (fieldIndex, object) -> {
                    this.value = object;
                });
            }

            @Override
            public Converter getConverter(int fieldIndex) {
                if (fieldIndex == 0) {
                    return this.keyConverter;
                }
                return this.valueConverter;
            }

            @Override
            public void start() {
                this.key = null;
                this.value = null;
            }

            @Override
            public void end() {
                MapConverter.this.map.put(this.key, this.value);
            }
        }
    }

    static class ArrayConverter<T>
    extends GroupConverter
    implements ParentDataHolder {
        private final ParentDataHolder parentDataHolder;
        private final Class elementClass;
        private final int pos;
        private List<T> list;
        private Converter elementConverter;

        ArrayConverter(Type elementType, Class elementClass, TypeInformation elementTypeInfo, ParentDataHolder parentDataHolder, int pos) {
            this.elementClass = elementClass;
            this.parentDataHolder = parentDataHolder;
            this.pos = pos;
            this.elementConverter = elementClass.equals(Row.class) ? RowConverter.createConverter(elementType, 0, elementTypeInfo, this) : new RowPrimitiveConverter(elementType, this, 0);
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.elementConverter;
        }

        @Override
        public void start() {
            this.list = new ArrayList<T>();
        }

        @Override
        public void end() {
            this.parentDataHolder.add(this.pos, this.list.toArray((Object[])Array.newInstance(this.elementClass, this.list.size())));
        }

        @Override
        public void add(int fieldIndex, Object object) {
            this.list.add(object);
        }
    }

    static class RowPrimitiveConverter
    extends PrimitiveConverter {
        private OriginalType originalType;
        private PrimitiveType.PrimitiveTypeName primitiveTypeName;
        private ParentDataHolder parentDataHolder;
        private int pos;

        RowPrimitiveConverter(Type dataType, ParentDataHolder parentDataHolder, int pos) {
            this.parentDataHolder = parentDataHolder;
            this.pos = pos;
            if (dataType.isPrimitive()) {
                this.originalType = dataType.getOriginalType();
                this.primitiveTypeName = dataType.asPrimitiveType().getPrimitiveTypeName();
            } else {
                Type primitiveType = dataType.asGroupType().getType(0);
                this.originalType = primitiveType.getOriginalType();
                this.primitiveTypeName = primitiveType.asPrimitiveType().getPrimitiveTypeName();
            }
        }

        @Override
        public void addBinary(Binary value) {
            block6: {
                block5: {
                    if (this.primitiveTypeName.equals((Object)PrimitiveType.PrimitiveTypeName.INT96)) {
                        this.parentDataHolder.add(this.pos, new Timestamp(ParquetTimestampUtils.getTimestampMillis(value)));
                        return;
                    }
                    if (this.originalType == null) break block5;
                    switch (this.originalType) {
                        case DECIMAL: {
                            this.parentDataHolder.add(this.pos, new BigDecimal(value.toStringUsingUTF8().toCharArray()));
                            break block6;
                        }
                        case UTF8: 
                        case ENUM: 
                        case JSON: 
                        case BSON: {
                            this.parentDataHolder.add(this.pos, value.toStringUsingUTF8());
                            break block6;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported original type : " + this.originalType.name() + " for primitive type BINARY");
                        }
                    }
                }
                this.parentDataHolder.add(this.pos, value.toStringUsingUTF8());
            }
        }

        @Override
        public void addBoolean(boolean value) {
            this.parentDataHolder.add(this.pos, value);
        }

        @Override
        public void addDouble(double value) {
            this.parentDataHolder.add(this.pos, value);
        }

        @Override
        public void addFloat(float value) {
            this.parentDataHolder.add(this.pos, Float.valueOf(value));
        }

        @Override
        public void addInt(int value) {
            block7: {
                block6: {
                    if (this.originalType == null) break block6;
                    switch (this.originalType) {
                        case TIME_MICROS: 
                        case TIME_MILLIS: {
                            this.parentDataHolder.add(this.pos, new Time(value));
                            break block7;
                        }
                        case TIMESTAMP_MICROS: 
                        case TIMESTAMP_MILLIS: {
                            this.parentDataHolder.add(this.pos, new Timestamp(value));
                            break block7;
                        }
                        case DATE: {
                            this.parentDataHolder.add(this.pos, new Date(value));
                            break block7;
                        }
                        case UINT_8: 
                        case UINT_16: 
                        case UINT_32: 
                        case INT_8: 
                        case INT_16: 
                        case INT_32: {
                            this.parentDataHolder.add(this.pos, value);
                            break block7;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported original type : " + this.originalType.name() + " for primitive type INT32");
                        }
                    }
                }
                this.parentDataHolder.add(this.pos, value);
            }
        }

        @Override
        public void addLong(long value) {
            block6: {
                block5: {
                    if (this.originalType == null) break block5;
                    switch (this.originalType) {
                        case TIME_MICROS: {
                            this.parentDataHolder.add(this.pos, new Time(value));
                            break block6;
                        }
                        case TIMESTAMP_MICROS: 
                        case TIMESTAMP_MILLIS: {
                            this.parentDataHolder.add(this.pos, new Timestamp(value));
                            break block6;
                        }
                        case DECIMAL: 
                        case INT_64: {
                            this.parentDataHolder.add(this.pos, value);
                            break block6;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported original type : " + this.originalType.name() + " for primitive type INT64");
                        }
                    }
                }
                this.parentDataHolder.add(this.pos, value);
            }
        }
    }
}

