/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.formats.parquet.utils;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.meta.When;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.hive.shaded.parquet.column.page.PageReadStore;
import org.apache.flink.hive.shaded.parquet.filter2.compat.FilterCompat;
import org.apache.flink.hive.shaded.parquet.hadoop.ParquetFileReader;
import org.apache.flink.hive.shaded.parquet.hadoop.api.InitContext;
import org.apache.flink.hive.shaded.parquet.hadoop.api.ReadSupport;
import org.apache.flink.hive.shaded.parquet.hadoop.metadata.BlockMetaData;
import org.apache.flink.hive.shaded.parquet.hadoop.metadata.FileMetaData;
import org.apache.flink.hive.shaded.parquet.io.ColumnIOFactory;
import org.apache.flink.hive.shaded.parquet.io.MessageColumnIO;
import org.apache.flink.hive.shaded.parquet.io.RecordReader;
import org.apache.flink.hive.shaded.parquet.io.api.RecordMaterializer;
import org.apache.flink.hive.shaded.parquet.schema.MessageType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordReader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetRecordReader.class);
    private ColumnIOFactory columnIOFactory;
    private FilterCompat.Filter filter;
    private MessageType readSchema;
    private MessageType fileSchema;
    private ReadSupport<T> readSupport;
    private RecordMaterializer<T> recordMaterializer;
    private ParquetFileReader reader;
    private RecordReader<T> recordReader;
    private boolean skipCorruptedRecord = true;
    private T readRecord;
    private boolean readRecordReturned = true;
    private long numTotalRecords;
    private long numReadRecords = 0L;
    private int currentBlock = -1;
    private long numRecordsUpToPreviousBlock = 0L;
    private long numRecordsUpToCurrentBlock = 0L;

    public ParquetRecordReader(ReadSupport<T> readSupport, MessageType readSchema, FilterCompat.Filter filter) {
        this.filter = (FilterCompat.Filter)Preconditions.checkNotNull((Object)filter, (String)"readSupport");
        this.readSupport = (ReadSupport)Preconditions.checkNotNull(readSupport, (String)"readSchema");
        this.readSchema = (MessageType)Preconditions.checkNotNull((Object)readSchema, (String)"filter");
    }

    public ParquetRecordReader(ReadSupport<T> readSupport, MessageType readSchema) {
        this(readSupport, readSchema, FilterCompat.NOOP);
    }

    public void setSkipCorruptedRecord(boolean skipCorruptedRecord) {
        this.skipCorruptedRecord = skipCorruptedRecord;
    }

    public void initialize(ParquetFileReader reader, Configuration configuration) {
        this.reader = reader;
        FileMetaData parquetFileMetadata = reader.getFooter().getFileMetaData();
        this.fileSchema = parquetFileMetadata.getSchema();
        Map<String, String> fileMetadata = parquetFileMetadata.getKeyValueMetaData();
        ReadSupport.ReadContext readContext = this.readSupport.init(new InitContext(configuration, ParquetRecordReader.toSetMultiMap(fileMetadata), this.readSchema));
        this.columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
        this.recordMaterializer = this.readSupport.prepareForRead(configuration, fileMetadata, this.readSchema, readContext);
        this.numTotalRecords = reader.getRecordCount();
    }

    private RecordReader<T> createRecordReader(PageReadStore pages) throws IOException {
        if (pages == null) {
            throw new IOException("Expecting more rows but reached last block. Read " + this.numReadRecords + " out of " + this.numTotalRecords);
        }
        MessageColumnIO columnIO = this.columnIOFactory.getColumnIO(this.readSchema, this.fileSchema, true);
        return columnIO.getRecordReader(pages, this.recordMaterializer, this.filter);
    }

    public void seek(long block, long recordInBlock) throws IOException {
        List<BlockMetaData> blockMetaData = this.reader.getRowGroups();
        if (block == -1L && recordInBlock == -1L) {
            this.currentBlock = blockMetaData.size() - 1;
            this.numReadRecords = this.numTotalRecords;
            this.numRecordsUpToCurrentBlock = this.numTotalRecords;
            return;
        }
        this.currentBlock = 0;
        this.numRecordsUpToPreviousBlock = 0L;
        this.numRecordsUpToCurrentBlock = blockMetaData.get(0).getRowCount();
        this.numReadRecords = 0L;
        while ((long)this.currentBlock < block) {
            ++this.currentBlock;
            this.reader.skipNextRowGroup();
            this.numRecordsUpToPreviousBlock = this.numRecordsUpToCurrentBlock;
            this.numRecordsUpToCurrentBlock += blockMetaData.get(this.currentBlock).getRowCount();
            this.numReadRecords = this.numRecordsUpToPreviousBlock;
        }
        PageReadStore pages = this.reader.readNextRowGroup();
        this.recordReader = this.createRecordReader(pages);
        int i = 0;
        while ((long)i <= recordInBlock) {
            this.readNextRecord();
            ++i;
        }
    }

    public Tuple2<Long, Long> getCurrentReadPosition() {
        long numRecordsReturned = this.numReadRecords;
        if (!this.readRecordReturned && this.numReadRecords > 0L) {
            --numRecordsReturned;
        }
        if (numRecordsReturned == this.numTotalRecords) {
            return Tuple2.of((Object)-1L, (Object)-1L);
        }
        if (numRecordsReturned == this.numRecordsUpToCurrentBlock) {
            return Tuple2.of((Object)((long)this.currentBlock + 1L), (Object)0L);
        }
        long numRecordsOfBlockReturned = numRecordsReturned - this.numRecordsUpToPreviousBlock;
        return Tuple2.of((Object)this.currentBlock, (Object)numRecordsOfBlockReturned);
    }

    public boolean reachEnd() throws IOException {
        if (this.readRecord != null && !this.readRecordReturned) {
            return false;
        }
        if (this.numReadRecords >= this.numTotalRecords) {
            return true;
        }
        return !this.readNextRecord();
    }

    private boolean readNextRecord() throws IOException {
        boolean recordFound = false;
        while (!recordFound) {
            if (this.numReadRecords >= this.numTotalRecords) {
                return false;
            }
            try {
                if (this.numReadRecords == this.numRecordsUpToCurrentBlock) {
                    PageReadStore pages = this.reader.readNextRowGroup();
                    this.recordReader = this.createRecordReader(pages);
                    this.numRecordsUpToPreviousBlock = this.numRecordsUpToCurrentBlock;
                    this.numRecordsUpToCurrentBlock += pages.getRowCount();
                    ++this.currentBlock;
                }
                ++this.numReadRecords;
                try {
                    this.readRecord = this.recordReader.read();
                    this.readRecordReturned = false;
                }
                catch (RecordMaterializer.RecordMaterializationException e) {
                    String errorMessage = String.format("skipping a corrupt record in block number [%d] record number [%s] of file %s", this.currentBlock, this.numReadRecords - this.numRecordsUpToPreviousBlock, this.reader.getFile());
                    if (!this.skipCorruptedRecord) {
                        LOG.error(errorMessage);
                        throw e;
                    }
                    LOG.warn(errorMessage);
                    continue;
                }
                if (this.readRecord == null) {
                    this.readRecordReturned = true;
                    this.numReadRecords = this.numRecordsUpToCurrentBlock;
                    LOG.debug("filtered record reader reached end of block");
                    continue;
                }
                recordFound = true;
                LOG.debug("read value: {}", this.readRecord);
            }
            catch (RecordMaterializer.RecordMaterializationException e) {
                LOG.error(String.format("Can not read value at %d in block %d in file %s", this.numReadRecords - this.numRecordsUpToPreviousBlock, this.currentBlock, this.reader.getFile()), (Throwable)e);
                if (!this.skipCorruptedRecord) {
                    throw e;
                }
                return false;
            }
        }
        return true;
    }

    @CheckReturnValue(when=When.NEVER)
    public T nextRecord() {
        this.readRecordReturned = true;
        return this.readRecord;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private static <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map) {
        HashMap<K, Set<V>> setMultiMap = new HashMap<K, Set<V>>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Set<V> set = Collections.singleton(entry.getValue());
            setMultiMap.put(entry.getKey(), Collections.unmodifiableSet(set));
        }
        return Collections.unmodifiableMap(setMultiMap);
    }
}

