/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.formats.parquet.row;

import java.io.IOException;
import java.util.HashMap;
import org.apache.flink.hive.shaded.formats.parquet.ParquetBuilder;
import org.apache.flink.hive.shaded.formats.parquet.ParquetWriterFactory;
import org.apache.flink.hive.shaded.formats.parquet.row.ParquetRowDataWriter;
import org.apache.flink.hive.shaded.formats.parquet.utils.ParquetSchemaConverter;
import org.apache.flink.hive.shaded.formats.parquet.utils.SerializableConfiguration;
import org.apache.flink.hive.shaded.parquet.hadoop.ParquetOutputFormat;
import org.apache.flink.hive.shaded.parquet.hadoop.ParquetWriter;
import org.apache.flink.hive.shaded.parquet.hadoop.api.WriteSupport;
import org.apache.flink.hive.shaded.parquet.hadoop.codec.CodecConfig;
import org.apache.flink.hive.shaded.parquet.io.OutputFile;
import org.apache.flink.hive.shaded.parquet.io.api.RecordConsumer;
import org.apache.flink.hive.shaded.parquet.schema.MessageType;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;

public class ParquetRowDataBuilder
extends ParquetWriter.Builder<RowData, ParquetRowDataBuilder> {
    private final RowType rowType;
    private final boolean utcTimestamp;

    public ParquetRowDataBuilder(OutputFile path, RowType rowType, boolean utcTimestamp) {
        super(path);
        this.rowType = rowType;
        this.utcTimestamp = utcTimestamp;
    }

    @Override
    protected ParquetRowDataBuilder self() {
        return this;
    }

    @Override
    protected WriteSupport<RowData> getWriteSupport(Configuration conf) {
        return new ParquetWriteSupport();
    }

    public static ParquetWriterFactory<RowData> createWriterFactory(RowType rowType, Configuration conf, boolean utcTimestamp) {
        return new ParquetWriterFactory<RowData>(new FlinkParquetBuilder(rowType, conf, utcTimestamp));
    }

    public static class FlinkParquetBuilder
    implements ParquetBuilder<RowData> {
        private final RowType rowType;
        private final SerializableConfiguration configuration;
        private final boolean utcTimestamp;

        public FlinkParquetBuilder(RowType rowType, Configuration conf, boolean utcTimestamp) {
            this.rowType = rowType;
            this.configuration = new SerializableConfiguration(conf);
            this.utcTimestamp = utcTimestamp;
        }

        @Override
        public ParquetWriter<RowData> createWriter(OutputFile out) throws IOException {
            Configuration conf = this.configuration.conf();
            return ((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)new ParquetRowDataBuilder(out, this.rowType, this.utcTimestamp).withCompressionCodec(CodecConfig.getParquetCompressionCodec(conf))).withRowGroupSize(ParquetOutputFormat.getBlockSize(conf))).withPageSize(ParquetOutputFormat.getPageSize(conf))).withDictionaryPageSize(ParquetOutputFormat.getDictionaryPageSize(conf))).withMaxPaddingSize(conf.getInt("parquet.writer.max-padding", 0x800000))).withDictionaryEncoding(ParquetOutputFormat.getEnableDictionary(conf))).withValidation(ParquetOutputFormat.getValidation(conf))).withWriterVersion(ParquetOutputFormat.getWriterVersion(conf))).withConf(conf)).build();
        }
    }

    private class ParquetWriteSupport
    extends WriteSupport<RowData> {
        private MessageType schema;
        private ParquetRowDataWriter writer;

        private ParquetWriteSupport() {
            this.schema = ParquetSchemaConverter.convertToParquetMessageType("flink_schema", ParquetRowDataBuilder.this.rowType);
        }

        @Override
        public WriteSupport.WriteContext init(Configuration configuration) {
            return new WriteSupport.WriteContext(this.schema, new HashMap<String, String>());
        }

        @Override
        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.writer = new ParquetRowDataWriter(recordConsumer, ParquetRowDataBuilder.this.rowType, this.schema, ParquetRowDataBuilder.this.utcTimestamp);
        }

        @Override
        public void write(RowData record) {
            try {
                this.writer.write(record);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

