/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.formats.parquet;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.hive.shaded.formats.parquet.row.ParquetRowDataBuilder;
import org.apache.flink.hive.shaded.formats.parquet.utils.SerializableConfiguration;
import org.apache.flink.hive.shaded.formats.parquet.vector.ParquetColumnarRowSplitReader;
import org.apache.flink.hive.shaded.formats.parquet.vector.ParquetSplitReaderUtil;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.FileSystemFormatFactory;
import org.apache.flink.table.filesystem.RowPartitionComputer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.PartitionPathUtils;

public class ParquetFileSystemFormatFactory
implements FileSystemFormatFactory {
    public static final String IDENTIFIER = "parquet";
    public static final ConfigOption<Boolean> UTC_TIMEZONE = ConfigOptions.key((String)"utc-timezone").booleanType().defaultValue((Object)false).withDescription("Use UTC timezone or local timezone to the conversion between epoch time and LocalDateTime. Hive 0.x/1.x/2.x use local timezone. But Hive 3.x use UTC timezone");

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(UTC_TIMEZONE);
        return options;
    }

    private static org.apache.hadoop.conf.Configuration getParquetConfiguration(ReadableConfig options) {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        Properties properties = new Properties();
        ((Configuration)options).addAllToProperties(properties);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> conf.set("parquet." + k, v.toString())));
        return conf;
    }

    public InputFormat<RowData, ?> createReader(FileSystemFormatFactory.ReaderContext context) {
        return new ParquetInputFormat(context.getPaths(), context.getSchema().getFieldNames(), context.getSchema().getFieldDataTypes(), context.getProjectFields(), context.getDefaultPartName(), context.getPushedDownLimit(), ParquetFileSystemFormatFactory.getParquetConfiguration(context.getFormatOptions()), (Boolean)context.getFormatOptions().get(UTC_TIMEZONE));
    }

    public Optional<BulkWriter.Factory<RowData>> createBulkWriterFactory(FileSystemFormatFactory.WriterContext context) {
        return Optional.of(ParquetRowDataBuilder.createWriterFactory(RowType.of((LogicalType[])((LogicalType[])Arrays.stream(context.getFormatFieldTypes()).map(DataType::getLogicalType).toArray(LogicalType[]::new)), (String[])context.getFormatFieldNames()), ParquetFileSystemFormatFactory.getParquetConfiguration(context.getFormatOptions()), (Boolean)context.getFormatOptions().get(UTC_TIMEZONE)));
    }

    public Optional<Encoder<RowData>> createEncoder(FileSystemFormatFactory.WriterContext context) {
        return Optional.empty();
    }

    public static class ParquetInputFormat
    extends FileInputFormat<RowData> {
        private static final long serialVersionUID = 1L;
        private final String[] fullFieldNames;
        private final DataType[] fullFieldTypes;
        private final int[] selectedFields;
        private final String partDefaultName;
        private final boolean utcTimestamp;
        private final SerializableConfiguration conf;
        private final long limit;
        private transient ParquetColumnarRowSplitReader reader;
        private transient long currentReadCount;

        public ParquetInputFormat(Path[] paths, String[] fullFieldNames, DataType[] fullFieldTypes, int[] selectedFields, String partDefaultName, long limit, org.apache.hadoop.conf.Configuration conf, boolean utcTimestamp) {
            super.setFilePaths(paths);
            this.limit = limit;
            this.partDefaultName = partDefaultName;
            this.fullFieldNames = fullFieldNames;
            this.fullFieldTypes = fullFieldTypes;
            this.selectedFields = selectedFields;
            this.conf = new SerializableConfiguration(conf);
            this.utcTimestamp = utcTimestamp;
        }

        public void open(FileInputSplit fileSplit) throws IOException {
            List<String> fieldNameList = Arrays.asList(this.fullFieldNames);
            LinkedHashMap partSpec = PartitionPathUtils.extractPartitionSpecFromPath((Path)fileSplit.getPath());
            LinkedHashMap<String, Object> partObjects = new LinkedHashMap<String, Object>();
            partSpec.forEach((k, v) -> partObjects.put((String)k, RowPartitionComputer.restorePartValueFromType((String)(this.partDefaultName.equals(v) ? null : v), (DataType)this.fullFieldTypes[fieldNameList.indexOf(k)])));
            this.reader = ParquetSplitReaderUtil.genPartColumnarRowReader(this.utcTimestamp, true, this.conf.conf(), this.fullFieldNames, this.fullFieldTypes, partObjects, this.selectedFields, 2048, new Path(fileSplit.getPath().toString()), fileSplit.getStart(), fileSplit.getLength());
            this.currentReadCount = 0L;
        }

        public boolean supportsMultiPaths() {
            return true;
        }

        public boolean reachedEnd() throws IOException {
            if (this.currentReadCount >= this.limit) {
                return true;
            }
            return this.reader.reachedEnd();
        }

        public RowData nextRecord(RowData reuse) {
            ++this.currentReadCount;
            return this.reader.nextRecord();
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
        }
    }
}

