/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.reshaded.parquet.org.apache.thrift.async;

import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeoutException;
import org.apache.flink.hive.reshaded.parquet.org.apache.thrift.TException;
import org.apache.flink.hive.reshaded.parquet.org.apache.thrift.async.TAsyncClient;
import org.apache.flink.hive.reshaded.parquet.org.apache.thrift.async.TAsyncMethodCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TAsyncClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TAsyncClientManager.class.getName());
    private final SelectThread selectThread;
    private final ConcurrentLinkedQueue<TAsyncMethodCall> pendingCalls = new ConcurrentLinkedQueue();

    public TAsyncClientManager() throws IOException {
        this.selectThread = new SelectThread();
        this.selectThread.start();
    }

    public void call(TAsyncMethodCall method) throws TException {
        if (!this.isRunning()) {
            throw new TException("SelectThread is not running");
        }
        method.prepareMethodCall();
        this.pendingCalls.add(method);
        this.selectThread.getSelector().wakeup();
    }

    public void stop() {
        this.selectThread.finish();
    }

    public boolean isRunning() {
        return this.selectThread.isAlive();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TAsyncMethodCallTimeoutComparator
    implements Comparator<TAsyncMethodCall>,
    Serializable {
        private TAsyncMethodCallTimeoutComparator() {
        }

        @Override
        public int compare(TAsyncMethodCall left, TAsyncMethodCall right) {
            if (left.getTimeoutTimestamp() == right.getTimeoutTimestamp()) {
                return (int)(left.getSequenceId() - right.getSequenceId());
            }
            return (int)(left.getTimeoutTimestamp() - right.getTimeoutTimestamp());
        }
    }

    private class SelectThread
    extends Thread {
        private final Selector selector;
        private volatile boolean running = true;
        private final TreeSet<TAsyncMethodCall> timeoutWatchSet = new TreeSet<TAsyncMethodCall>(new TAsyncMethodCallTimeoutComparator());

        public SelectThread() throws IOException {
            this.selector = SelectorProvider.provider().openSelector();
            this.setName("TAsyncClientManager#SelectorThread " + this.getId());
            this.setDaemon(true);
        }

        public Selector getSelector() {
            return this.selector;
        }

        public void finish() {
            this.running = false;
            this.selector.wakeup();
        }

        public void run() {
            while (this.running) {
                try {
                    try {
                        if (this.timeoutWatchSet.size() == 0) {
                            this.selector.select();
                        } else {
                            long nextTimeout = this.timeoutWatchSet.first().getTimeoutTimestamp();
                            long selectTime = nextTimeout - System.currentTimeMillis();
                            if (selectTime > 0L) {
                                this.selector.select(selectTime);
                            } else {
                                this.selector.selectNow();
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Caught IOException in TAsyncClientManager!", (Throwable)e);
                    }
                    this.transitionMethods();
                    this.timeoutMethods();
                    this.startPendingMethods();
                }
                catch (Exception exception) {
                    LOGGER.error("Ignoring uncaught exception in SelectThread", (Throwable)exception);
                }
            }
            try {
                this.selector.close();
            }
            catch (IOException ex) {
                LOGGER.warn("Could not close selector. This may result in leaked resources!", (Throwable)ex);
            }
        }

        private void transitionMethods() {
            try {
                Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
                while (keys.hasNext()) {
                    SelectionKey key = keys.next();
                    keys.remove();
                    if (!key.isValid()) continue;
                    TAsyncMethodCall methodCall = (TAsyncMethodCall)key.attachment();
                    methodCall.transition(key);
                    if (!methodCall.isFinished() && !methodCall.getClient().hasError()) continue;
                    this.timeoutWatchSet.remove(methodCall);
                }
            }
            catch (ClosedSelectorException e) {
                LOGGER.error("Caught ClosedSelectorException in TAsyncClientManager!", (Throwable)e);
            }
        }

        private void timeoutMethods() {
            TAsyncMethodCall methodCall;
            Iterator<TAsyncMethodCall> iterator = this.timeoutWatchSet.iterator();
            long currentTime = System.currentTimeMillis();
            while (iterator.hasNext() && currentTime >= (methodCall = iterator.next()).getTimeoutTimestamp()) {
                iterator.remove();
                methodCall.onError(new TimeoutException("Operation " + methodCall.getClass() + " timed out after " + (currentTime - methodCall.getStartTime()) + " ms."));
            }
        }

        private void startPendingMethods() {
            TAsyncMethodCall methodCall;
            while ((methodCall = (TAsyncMethodCall)TAsyncClientManager.this.pendingCalls.poll()) != null) {
                try {
                    methodCall.start(this.selector);
                    TAsyncClient client = methodCall.getClient();
                    if (!client.hasTimeout() || client.hasError()) continue;
                    this.timeoutWatchSet.add(methodCall);
                }
                catch (Exception exception) {
                    LOGGER.warn("Caught exception in TAsyncClientManager!", (Throwable)exception);
                    methodCall.onError(exception);
                }
            }
        }
    }
}

