/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.connectors.hive.read.HiveTableInputFormat;
import org.apache.flink.connectors.hive.read.HiveTableInputSplit;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.table.data.RowData;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;

public class HiveTableFileInputFormat
extends FileInputFormat<RowData> {
    private final HiveTableInputFormat inputFormat;
    private final HiveTablePartition hiveTablePartition;

    public HiveTableFileInputFormat(HiveTableInputFormat inputFormat, HiveTablePartition hiveTablePartition) {
        this.inputFormat = inputFormat;
        this.hiveTablePartition = hiveTablePartition;
        this.setFilePath(hiveTablePartition.getStorageDescriptor().getLocation());
    }

    public void open(FileInputSplit fileSplit) throws IOException {
        HiveTableInputSplit split = new HiveTableInputSplit(fileSplit.getSplitNumber(), (InputSplit)HiveTableFileInputFormat.toHadoopFileSplit(fileSplit), this.inputFormat.getJobConf(), this.hiveTablePartition);
        this.inputFormat.open(split);
    }

    @VisibleForTesting
    static FileSplit toHadoopFileSplit(FileInputSplit fileSplit) throws IOException {
        URI uri = fileSplit.getPath().toUri();
        long length = fileSplit.getLength();
        if (length == -1L) {
            length = fileSplit.getPath().getFileSystem().getFileStatus(fileSplit.getPath()).getLen() - fileSplit.getStart();
        }
        return new FileSplit(new Path(uri), fileSplit.getStart(), length, (String[])null);
    }

    public boolean reachedEnd() throws IOException {
        return this.inputFormat.reachedEnd();
    }

    public RowData nextRecord(RowData reuse) throws IOException {
        return this.inputFormat.nextRecord(reuse);
    }

    public void configure(Configuration parameters) {
        super.configure(parameters);
        this.inputFormat.configure(parameters);
    }

    public void close() throws IOException {
        super.close();
        this.inputFormat.close();
    }

    public void setRuntimeContext(RuntimeContext t) {
        super.setRuntimeContext(t);
        this.inputFormat.setRuntimeContext(t);
    }

    public void openInputFormat() throws IOException {
        super.openInputFormat();
        this.inputFormat.openInputFormat();
    }

    public void closeInputFormat() throws IOException {
        super.closeInputFormat();
        this.inputFormat.closeInputFormat();
    }
}

