/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.HashMap;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class HiveDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public String factoryIdentifier() {
        throw new UnsupportedOperationException("Hive factory is only work for catalog.");
    }

    public Set<ConfigOption<?>> requiredOptions() {
        throw new UnsupportedOperationException("Hive factory is only work for catalog.");
    }

    public Set<ConfigOption<?>> optionalOptions() {
        throw new UnsupportedOperationException("Hive factory is only work for catalog.");
    }

    private static CatalogTable removeIsGenericFlag(CatalogTable table) {
        HashMap newOptions = new HashMap(table.getOptions());
        boolean isGeneric = Boolean.parseBoolean((String)newOptions.remove("is_generic"));
        if (!isGeneric) {
            throw new ValidationException("Hive dynamic table factory now only work for generic table.");
        }
        return table.copy(newOptions);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        return FactoryUtil.createTableSink(null, (ObjectIdentifier)context.getObjectIdentifier(), (CatalogTable)HiveDynamicTableFactory.removeIsGenericFlag(context.getCatalogTable()), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader());
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        return FactoryUtil.createTableSource(null, (ObjectIdentifier)context.getObjectIdentifier(), (CatalogTable)HiveDynamicTableFactory.removeIsGenericFlag(context.getCatalogTable()), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader());
    }
}

