/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.it.unimi.dsi.fastutil.booleans;

import java.io.Serializable;
import java.util.Random;
import org.apache.hive.shaded.parquet.it.unimi.dsi.fastutil.Arrays;
import org.apache.hive.shaded.parquet.it.unimi.dsi.fastutil.Hash;
import org.apache.hive.shaded.parquet.it.unimi.dsi.fastutil.booleans.BooleanComparator;

public class BooleanArrays {
    public static final boolean[] EMPTY_ARRAY = new boolean[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    public static final Hash.Strategy<boolean[]> HASH_STRATEGY = new ArrayHashStrategy();

    private BooleanArrays() {
    }

    public static boolean[] ensureCapacity(boolean[] array, int length) {
        if (length > array.length) {
            boolean[] t = new boolean[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static boolean[] ensureCapacity(boolean[] array, int length, int preserve) {
        if (length > array.length) {
            boolean[] t = new boolean[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static boolean[] grow(boolean[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array.length, (long)length), 0x7FFFFFF7L);
            boolean[] t = new boolean[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static boolean[] grow(boolean[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array.length, (long)length), 0x7FFFFFF7L);
            boolean[] t = new boolean[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static boolean[] trim(boolean[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        boolean[] t = length == 0 ? EMPTY_ARRAY : new boolean[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static boolean[] setLength(boolean[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return BooleanArrays.trim(array, length);
        }
        return BooleanArrays.ensureCapacity(array, length);
    }

    public static boolean[] copy(boolean[] array, int offset, int length) {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        boolean[] a = length == 0 ? EMPTY_ARRAY : new boolean[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static boolean[] copy(boolean[] array) {
        return (boolean[])array.clone();
    }

    public static void fill(boolean[] array, boolean value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(boolean[] array, int from, int to, boolean value) {
        BooleanArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    @Deprecated
    public static boolean equals(boolean[] a1, boolean[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(boolean[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(boolean[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void swap(boolean[] x, int a, int b) {
        boolean t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecSwap(boolean[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            BooleanArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(boolean[] x, int a, int b, int c, BooleanComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(boolean[] a, int from, int to, BooleanComparator comp) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            boolean u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(boolean[] a, int from, int to, BooleanComparator comp) {
        int i = from;
        while (++i < to) {
            boolean t = a[i];
            int j = i;
            boolean u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static void selectionSort(boolean[] a, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (a[j] || !a[m]) continue;
                m = j;
            }
            if (m == i) continue;
            boolean u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(boolean[] a, int from, int to) {
        int i = from;
        while (++i < to) {
            boolean t = a[i];
            int j = i;
            boolean u = a[j - 1];
            while (!t && u) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(boolean[] x, int from, int to, BooleanComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            BooleanArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 50) {
                int s = len / 8;
                l = BooleanArrays.med3(x, l, l + s, l + 2 * s, comp);
                m = BooleanArrays.med3(x, m - s, m, m + s, comp);
                n = BooleanArrays.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = BooleanArrays.med3(x, l, m, n, comp);
        }
        boolean v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BooleanArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        BooleanArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        BooleanArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            BooleanArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            BooleanArrays.quickSort(x, n - s, n, comp);
        }
    }

    public static void quickSort(boolean[] x, BooleanComparator comp) {
        BooleanArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(boolean[] x, int a, int b, int c) {
        int bc;
        int ac;
        int ab;
        int n = !x[a] && x[b] ? -1 : (ab = x[a] == x[b] ? 0 : 1);
        int n2 = !x[a] && x[c] ? -1 : (ac = x[a] == x[c] ? 0 : 1);
        int n3 = !x[b] && x[c] ? -1 : (bc = x[b] == x[c] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    @Deprecated
    public static void quickSort(boolean[] x, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            BooleanArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 50) {
                int s = len / 8;
                l = BooleanArrays.med3(x, l, l + s, l + 2 * s);
                m = BooleanArrays.med3(x, m - s, m, m + s);
                n = BooleanArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = BooleanArrays.med3(x, l, m, n);
        }
        boolean v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (!x[b] && v ? -1 : (comparison = x[b] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (!x[c] && v ? -1 : (comparison = x[c] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BooleanArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        BooleanArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        BooleanArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            BooleanArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            BooleanArrays.quickSort(x, n - s, n);
        }
    }

    @Deprecated
    public static void quickSort(boolean[] x) {
        BooleanArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(boolean[] a, int from, int to, boolean[] supp) {
        int len = to - from;
        if (len < 7) {
            BooleanArrays.insertionSort(a, from, to);
            return;
        }
        int mid = from + to >>> 1;
        BooleanArrays.mergeSort(supp, from, mid, a);
        BooleanArrays.mergeSort(supp, mid, to, a);
        if (!supp[mid - 1] || supp[mid]) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && (!supp[p] || supp[q]) ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(boolean[] a, int from, int to) {
        BooleanArrays.mergeSort(a, from, to, (boolean[])a.clone());
    }

    public static void mergeSort(boolean[] a) {
        BooleanArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(boolean[] a, int from, int to, BooleanComparator comp, boolean[] supp) {
        int len = to - from;
        if (len < 7) {
            BooleanArrays.insertionSort(a, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        BooleanArrays.mergeSort(supp, from, mid, comp, a);
        BooleanArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(boolean[] a, int from, int to, BooleanComparator comp) {
        BooleanArrays.mergeSort(a, from, to, comp, (boolean[])a.clone());
    }

    public static void mergeSort(boolean[] a, BooleanComparator comp) {
        BooleanArrays.mergeSort(a, 0, a.length, comp);
    }

    public static boolean[] shuffle(boolean[] a, int from, int to, Random random) {
        int i = to - from;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            boolean t = a[from + i];
            a[from + i] = a[from + p];
            a[from + p] = t;
        }
        return a;
    }

    public static boolean[] shuffle(boolean[] a, Random random) {
        int i = a.length;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            boolean t = a[i];
            a[i] = a[p];
            a[p] = t;
        }
        return a;
    }

    public static boolean[] reverse(boolean[] a) {
        int length = a.length;
        int i = length / 2;
        while (i-- != 0) {
            boolean t = a[length - i - 1];
            a[length - i - 1] = a[i];
            a[i] = t;
        }
        return a;
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<boolean[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(boolean[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(boolean[] a, boolean[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

