/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.hadoop;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hive.shaded.parquet.Log;

final class LruCache<K, V extends Value<K, V>> {
    private static final Log LOG = Log.getLog(LruCache.class);
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final LinkedHashMap<K, V> cacheMap;

    public LruCache(int maxSize) {
        this(maxSize, 0.75f, true);
    }

    public LruCache(final int maxSize, float loadFactor, boolean accessOrder) {
        int initialCapacity = Math.round((float)maxSize / loadFactor);
        this.cacheMap = new LinkedHashMap<K, V>(initialCapacity, loadFactor, accessOrder){

            @Override
            public boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                boolean result;
                boolean bl = result = this.size() > maxSize;
                if (result && Log.DEBUG) {
                    LOG.debug("Removing eldest entry in cache: " + eldest.getKey());
                }
                return result;
            }
        };
    }

    public V remove(K key) {
        Value oldValue = (Value)this.cacheMap.remove(key);
        if (oldValue != null && Log.DEBUG) {
            LOG.debug("Removed cache entry for '" + key + "'");
        }
        return (V)oldValue;
    }

    public void put(K key, V newValue) {
        if (newValue == null || !newValue.isCurrent(key)) {
            if (Log.WARN) {
                LOG.warn("Ignoring new cache entry for '" + key + "' because it is " + (newValue == null ? "null" : "not current"));
            }
            return;
        }
        Value oldValue = (Value)this.cacheMap.get(key);
        if (oldValue != null && oldValue.isNewerThan(newValue)) {
            if (Log.WARN) {
                LOG.warn("Ignoring new cache entry for '" + key + "' because " + "existing cache entry is newer");
            }
            return;
        }
        oldValue = (Value)this.cacheMap.put(key, newValue);
        if (Log.DEBUG) {
            if (oldValue == null) {
                LOG.debug("Added new cache entry for '" + key + "'");
            } else {
                LOG.debug("Overwrote existing cache entry for '" + key + "'");
            }
        }
    }

    public void clear() {
        this.cacheMap.clear();
    }

    public V getCurrentValue(K key) {
        Value value = (Value)this.cacheMap.get(key);
        if (Log.DEBUG) {
            LOG.debug("Value for '" + key + "' " + (value == null ? "not " : "") + "in cache");
        }
        if (value != null && !value.isCurrent(key)) {
            this.remove(key);
            return null;
        }
        return (V)value;
    }

    public int size() {
        return this.cacheMap.size();
    }

    static interface Value<K, V> {
        public boolean isCurrent(K var1);

        public boolean isNewerThan(V var1);
    }
}

