/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.column.values.deltalengthbytearray;

import java.io.IOException;
import org.apache.hive.shaded.parquet.Log;
import org.apache.hive.shaded.parquet.bytes.BytesInput;
import org.apache.hive.shaded.parquet.bytes.CapacityByteArrayOutputStream;
import org.apache.hive.shaded.parquet.bytes.LittleEndianDataOutputStream;
import org.apache.hive.shaded.parquet.column.Encoding;
import org.apache.hive.shaded.parquet.column.values.ValuesWriter;
import org.apache.hive.shaded.parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import org.apache.hive.shaded.parquet.io.ParquetEncodingException;
import org.apache.hive.shaded.parquet.io.api.Binary;

public class DeltaLengthByteArrayValuesWriter
extends ValuesWriter {
    private static final Log LOG = Log.getLog(DeltaLengthByteArrayValuesWriter.class);
    private ValuesWriter lengthWriter;
    private CapacityByteArrayOutputStream arrayOut;
    private LittleEndianDataOutputStream out;

    public DeltaLengthByteArrayValuesWriter(int initialSize, int pageSize) {
        this.arrayOut = new CapacityByteArrayOutputStream(initialSize, pageSize);
        this.out = new LittleEndianDataOutputStream(this.arrayOut);
        this.lengthWriter = new DeltaBinaryPackingValuesWriter(128, 4, initialSize, pageSize);
    }

    @Override
    public void writeBytes(Binary v) {
        try {
            this.lengthWriter.writeInteger(v.length());
            v.writeTo(this.out);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write bytes", e);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.lengthWriter.getBufferedSize() + this.arrayOut.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page", e);
        }
        if (Log.DEBUG) {
            LOG.debug("writing a buffer of size " + this.arrayOut.size());
        }
        return BytesInput.concat(this.lengthWriter.getBytes(), BytesInput.from(this.arrayOut));
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.DELTA_LENGTH_BYTE_ARRAY;
    }

    @Override
    public void reset() {
        this.lengthWriter.reset();
        this.arrayOut.reset();
    }

    @Override
    public long getAllocatedSize() {
        return this.lengthWriter.getAllocatedSize() + (long)this.arrayOut.getCapacity();
    }

    @Override
    public String memUsageString(String prefix) {
        return this.arrayOut.memUsageString(this.lengthWriter.memUsageString(prefix) + " DELTA_LENGTH_BYTE_ARRAY");
    }
}

