/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.shaded.parquet.column;

import org.apache.hive.shaded.parquet.bytes.BytesUtils;
import org.apache.hive.shaded.parquet.column.ColumnDescriptor;
import org.apache.hive.shaded.parquet.column.ColumnWriteStore;
import org.apache.hive.shaded.parquet.column.Encoding;
import org.apache.hive.shaded.parquet.column.impl.ColumnWriteStoreV1;
import org.apache.hive.shaded.parquet.column.impl.ColumnWriteStoreV2;
import org.apache.hive.shaded.parquet.column.page.PageWriteStore;
import org.apache.hive.shaded.parquet.column.values.ValuesWriter;
import org.apache.hive.shaded.parquet.column.values.boundedint.DevNullValuesWriter;
import org.apache.hive.shaded.parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import org.apache.hive.shaded.parquet.column.values.deltastrings.DeltaByteArrayWriter;
import org.apache.hive.shaded.parquet.column.values.dictionary.DictionaryValuesWriter;
import org.apache.hive.shaded.parquet.column.values.fallback.FallbackValuesWriter;
import org.apache.hive.shaded.parquet.column.values.plain.BooleanPlainValuesWriter;
import org.apache.hive.shaded.parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import org.apache.hive.shaded.parquet.column.values.plain.PlainValuesWriter;
import org.apache.hive.shaded.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import org.apache.hive.shaded.parquet.schema.MessageType;

public class ParquetProperties {
    private final int dictionaryPageSizeThreshold;
    private final WriterVersion writerVersion;
    private final boolean enableDictionary;

    public ParquetProperties(int dictPageSize, WriterVersion writerVersion, boolean enableDict) {
        this.dictionaryPageSizeThreshold = dictPageSize;
        this.writerVersion = writerVersion;
        this.enableDictionary = enableDict;
    }

    public static ValuesWriter getColumnDescriptorValuesWriter(int maxLevel, int initialSizePerCol, int pageSize) {
        if (maxLevel == 0) {
            return new DevNullValuesWriter();
        }
        return new RunLengthBitPackingHybridValuesWriter(BytesUtils.getWidthFromMaxInt(maxLevel), initialSizePerCol, pageSize);
    }

    private ValuesWriter plainWriter(ColumnDescriptor path, int initialSizePerCol, int pageSize) {
        switch (path.getType()) {
            case BOOLEAN: {
                return new BooleanPlainValuesWriter();
            }
            case INT96: {
                return new FixedLenByteArrayPlainValuesWriter(12, initialSizePerCol, pageSize);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new FixedLenByteArrayPlainValuesWriter(path.getTypeLength(), initialSizePerCol, pageSize);
            }
            case BINARY: 
            case INT32: 
            case INT64: 
            case DOUBLE: 
            case FLOAT: {
                return new PlainValuesWriter(initialSizePerCol, pageSize);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    private DictionaryValuesWriter dictionaryWriter(ColumnDescriptor path, int initialSizePerCol) {
        Encoding encodingForDictionaryPage;
        Encoding encodingForDataPage;
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                encodingForDataPage = Encoding.PLAIN_DICTIONARY;
                encodingForDictionaryPage = Encoding.PLAIN_DICTIONARY;
                break;
            }
            case PARQUET_2_0: {
                encodingForDataPage = Encoding.RLE_DICTIONARY;
                encodingForDictionaryPage = Encoding.PLAIN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown version: " + (Object)((Object)this.writerVersion));
            }
        }
        switch (path.getType()) {
            case BOOLEAN: {
                throw new IllegalArgumentException("no dictionary encoding for BOOLEAN");
            }
            case BINARY: {
                return new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case INT32: {
                return new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case INT64: {
                return new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case INT96: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(this.dictionaryPageSizeThreshold, 12, encodingForDataPage, encodingForDictionaryPage);
            }
            case DOUBLE: {
                return new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case FLOAT: {
                return new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(this.dictionaryPageSizeThreshold, path.getTypeLength(), encodingForDataPage, encodingForDictionaryPage);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    private ValuesWriter writerToFallbackTo(ColumnDescriptor path, int initialSizePerCol, int pageSize) {
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                return this.plainWriter(path, initialSizePerCol, pageSize);
            }
            case PARQUET_2_0: {
                switch (path.getType()) {
                    case BOOLEAN: {
                        return new RunLengthBitPackingHybridValuesWriter(1, initialSizePerCol, pageSize);
                    }
                    case FIXED_LEN_BYTE_ARRAY: 
                    case BINARY: {
                        return new DeltaByteArrayWriter(initialSizePerCol, pageSize);
                    }
                    case INT32: {
                        return new DeltaBinaryPackingValuesWriter(initialSizePerCol, pageSize);
                    }
                    case INT96: 
                    case INT64: 
                    case DOUBLE: 
                    case FLOAT: {
                        return this.plainWriter(path, initialSizePerCol, pageSize);
                    }
                }
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
            }
        }
        throw new IllegalArgumentException("Unknown version: " + (Object)((Object)this.writerVersion));
    }

    private ValuesWriter dictWriterWithFallBack(ColumnDescriptor path, int initialSizePerCol, int pageSize) {
        ValuesWriter writerToFallBackTo = this.writerToFallbackTo(path, initialSizePerCol, pageSize);
        if (this.enableDictionary) {
            return FallbackValuesWriter.of(this.dictionaryWriter(path, initialSizePerCol), writerToFallBackTo);
        }
        return writerToFallBackTo;
    }

    public ValuesWriter getValuesWriter(ColumnDescriptor path, int initialSizePerCol, int pageSize) {
        switch (path.getType()) {
            case BOOLEAN: {
                return this.writerToFallbackTo(path, initialSizePerCol, pageSize);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                if (this.writerVersion == WriterVersion.PARQUET_2_0) {
                    return this.dictWriterWithFallBack(path, initialSizePerCol, pageSize);
                }
                return this.writerToFallbackTo(path, initialSizePerCol, pageSize);
            }
            case INT96: 
            case BINARY: 
            case INT32: 
            case INT64: 
            case DOUBLE: 
            case FLOAT: {
                return this.dictWriterWithFallBack(path, initialSizePerCol, pageSize);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    public int getDictionaryPageSizeThreshold() {
        return this.dictionaryPageSizeThreshold;
    }

    public WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    public boolean isEnableDictionary() {
        return this.enableDictionary;
    }

    public ColumnWriteStore newColumnWriteStore(MessageType schema, PageWriteStore pageStore, int pageSize) {
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                return new ColumnWriteStoreV1(pageStore, pageSize, this.dictionaryPageSizeThreshold, this.enableDictionary, this.writerVersion);
            }
            case PARQUET_2_0: {
                return new ColumnWriteStoreV2(schema, pageStore, pageSize, new ParquetProperties(this.dictionaryPageSizeThreshold, this.writerVersion, this.enableDictionary));
            }
        }
        throw new IllegalArgumentException("unknown version " + (Object)((Object)this.writerVersion));
    }

    public static enum WriterVersion {
        PARQUET_1_0("v1"),
        PARQUET_2_0("v2");

        private final String shortName;

        private WriterVersion(String shortname) {
            this.shortName = shortname;
        }

        public static WriterVersion fromString(String name) {
            for (WriterVersion v : WriterVersion.values()) {
                if (!v.shortName.equals(name)) continue;
                return v;
            }
            return WriterVersion.valueOf(name);
        }
    }
}

