/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.annotation.Nullable;
import org.apache.hive.orc.CompressionCodec;
import org.apache.hive.orc.impl.DirectDecompressionCodec;
import org.apache.hive.orc.impl.HadoopShims;

public class ZlibCodec
implements CompressionCodec,
DirectDecompressionCodec {
    private static final HadoopShims SHIMS = HadoopShims.Factory.get();
    private Boolean direct = null;
    private final int level;
    private final int strategy;

    public ZlibCodec() {
        this.level = -1;
        this.strategy = 0;
    }

    private ZlibCodec(int level, int strategy) {
        this.level = level;
        this.strategy = strategy;
    }

    @Override
    public boolean compress(ByteBuffer in, ByteBuffer out, ByteBuffer overflow) throws IOException {
        Deflater deflater = new Deflater(this.level, true);
        deflater.setStrategy(this.strategy);
        int length = in.remaining();
        deflater.setInput(in.array(), in.arrayOffset() + in.position(), length);
        deflater.finish();
        int outSize = 0;
        int offset = out.arrayOffset() + out.position();
        while (!deflater.finished() && length > outSize) {
            int size = deflater.deflate(out.array(), offset, out.remaining());
            out.position(size + out.position());
            outSize += size;
            offset += size;
            if (out.remaining() != 0) continue;
            if (overflow == null) {
                deflater.end();
                return false;
            }
            out = overflow;
            offset = out.arrayOffset() + out.position();
        }
        deflater.end();
        return length > outSize;
    }

    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        if (in.isDirect() && out.isDirect()) {
            this.directDecompress(in, out);
            return;
        }
        Inflater inflater = new Inflater(true);
        inflater.setInput(in.array(), in.arrayOffset() + in.position(), in.remaining());
        while (!(inflater.finished() || inflater.needsDictionary() || inflater.needsInput())) {
            try {
                int count = inflater.inflate(out.array(), out.arrayOffset() + out.position(), out.remaining());
                out.position(count + out.position());
            }
            catch (DataFormatException dfe) {
                throw new IOException("Bad compression data", dfe);
            }
        }
        out.flip();
        inflater.end();
        in.position(in.limit());
    }

    @Override
    public boolean isAvailable() {
        if (this.direct == null) {
            try {
                this.direct = SHIMS.getDirectDecompressor(HadoopShims.DirectCompressionType.ZLIB_NOHEADER) != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            catch (UnsatisfiedLinkError ule) {
                this.direct = false;
            }
        }
        return this.direct;
    }

    @Override
    public void directDecompress(ByteBuffer in, ByteBuffer out) throws IOException {
        HadoopShims.DirectDecompressor decompressShim = SHIMS.getDirectDecompressor(HadoopShims.DirectCompressionType.ZLIB_NOHEADER);
        decompressShim.decompress(in, out);
        out.flip();
    }

    @Override
    public CompressionCodec modify(@Nullable EnumSet<CompressionCodec.Modifier> modifiers) {
        if (modifiers == null) {
            return this;
        }
        int l = this.level;
        int s = this.strategy;
        for (CompressionCodec.Modifier m : modifiers) {
            switch (m) {
                case BINARY: {
                    s = 1;
                    break;
                }
                case TEXT: {
                    s = 0;
                    break;
                }
                case FASTEST: {
                    l = 1;
                    break;
                }
                case FAST: {
                    l = 2;
                    break;
                }
                case DEFAULT: {
                    l = -1;
                    break;
                }
            }
        }
        return new ZlibCodec(l, s);
    }
}

