/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hive.orc.CompressionCodec;
import org.apache.hive.orc.impl.DirectDecompressionCodec;
import org.apache.hive.orc.impl.HadoopShims;
import org.iq80.snappy.Snappy;

public class SnappyCodec
implements CompressionCodec,
DirectDecompressionCodec {
    private static final HadoopShims SHIMS = HadoopShims.Factory.get();
    Boolean direct = null;

    @Override
    public boolean compress(ByteBuffer in, ByteBuffer out, ByteBuffer overflow) throws IOException {
        int inBytes = in.remaining();
        byte[] compressed = new byte[Snappy.maxCompressedLength(inBytes)];
        int outBytes = Snappy.compress(in.array(), in.arrayOffset() + in.position(), inBytes, compressed, 0);
        if (outBytes < inBytes) {
            int remaining = out.remaining();
            if (remaining >= outBytes) {
                System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), outBytes);
                out.position(out.position() + outBytes);
            } else {
                System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), remaining);
                out.position(out.limit());
                System.arraycopy(compressed, remaining, overflow.array(), overflow.arrayOffset(), outBytes - remaining);
                overflow.position(outBytes - remaining);
            }
            return true;
        }
        return false;
    }

    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        if (in.isDirect() && out.isDirect()) {
            this.directDecompress(in, out);
            return;
        }
        int inOffset = in.position();
        int uncompressLen = Snappy.uncompress(in.array(), in.arrayOffset() + inOffset, in.limit() - inOffset, out.array(), out.arrayOffset() + out.position());
        out.position(uncompressLen + out.position());
        out.flip();
    }

    @Override
    public boolean isAvailable() {
        if (this.direct == null) {
            try {
                this.direct = SHIMS.getDirectDecompressor(HadoopShims.DirectCompressionType.SNAPPY) != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            catch (UnsatisfiedLinkError ule) {
                this.direct = false;
            }
        }
        return this.direct;
    }

    @Override
    public void directDecompress(ByteBuffer in, ByteBuffer out) throws IOException {
        HadoopShims.DirectDecompressor decompressShim = SHIMS.getDirectDecompressor(HadoopShims.DirectCompressionType.SNAPPY);
        decompressShim.decompress(in, out);
        out.flip();
    }

    @Override
    public CompressionCodec modify(EnumSet<CompressionCodec.Modifier> modifiers) {
        return this;
    }
}

