/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.orc.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.orc.TypeDescription;
import org.apache.hive.orc.impl.ConvertTreeReaderFactory;

public class SchemaEvolution {
    private final TypeDescription[] readerFileTypes;
    private final boolean[] readerIncluded;
    private final int readerColumnOffset;
    private final boolean[] fileIncluded;
    private final TypeDescription fileSchema;
    private final TypeDescription readerSchema;
    private boolean hasConversion;
    private final boolean[] ppdSafeConversion;
    public static final List<String> acidEventFieldNames = new ArrayList<String>();

    public SchemaEvolution(TypeDescription fileSchema, boolean[] includedCols) {
        this(fileSchema, null, includedCols);
    }

    public SchemaEvolution(TypeDescription fileSchema, TypeDescription readerSchema, boolean[] includeCols) {
        this.readerIncluded = includeCols == null ? null : Arrays.copyOf(includeCols, includeCols.length);
        this.fileIncluded = new boolean[fileSchema.getMaximumId() + 1];
        this.hasConversion = false;
        this.fileSchema = fileSchema;
        boolean isAcid = SchemaEvolution.checkAcidSchema(fileSchema);
        int n = this.readerColumnOffset = isAcid ? acidEventFieldNames.size() : 0;
        if (readerSchema != null) {
            this.readerSchema = isAcid ? SchemaEvolution.createEventSchema(readerSchema) : readerSchema;
            if (this.readerIncluded != null && this.readerIncluded.length + this.readerColumnOffset != this.readerSchema.getMaximumId() + 1) {
                throw new IllegalArgumentException("Include vector the wrong length: " + this.readerSchema.toJson() + " with include length " + this.readerIncluded.length);
            }
            this.readerFileTypes = new TypeDescription[this.readerSchema.getMaximumId() + 1];
            this.buildConversionFileTypesArray(fileSchema, this.readerSchema);
        } else {
            this.readerSchema = fileSchema;
            this.readerFileTypes = new TypeDescription[this.readerSchema.getMaximumId() + 1];
            if (this.readerIncluded != null && this.readerIncluded.length + this.readerColumnOffset != this.readerSchema.getMaximumId() + 1) {
                throw new IllegalArgumentException("Include vector the wrong length: " + this.readerSchema.toJson() + " with include length " + this.readerIncluded.length);
            }
            this.buildSameSchemaFileTypesArray();
        }
        this.ppdSafeConversion = this.populatePpdSafeConversion();
    }

    public TypeDescription getReaderSchema() {
        return this.readerSchema;
    }

    public TypeDescription getReaderBaseSchema() {
        return this.readerSchema.findSubtype(this.readerColumnOffset);
    }

    public boolean hasConversion() {
        return this.hasConversion;
    }

    public TypeDescription getFileType(TypeDescription readerType) {
        return this.getFileType(readerType.getId());
    }

    public boolean[] getReaderIncluded() {
        return this.readerIncluded;
    }

    public boolean[] getFileIncluded() {
        return this.fileIncluded;
    }

    public TypeDescription getFileType(int id) {
        return this.readerFileTypes[id];
    }

    public boolean isPPDSafeConversion(int colId) {
        if (this.hasConversion()) {
            if (colId < 0 || colId >= this.ppdSafeConversion.length) {
                return false;
            }
            return this.ppdSafeConversion[colId];
        }
        return true;
    }

    private boolean[] populatePpdSafeConversion() {
        boolean safePpd;
        if (this.fileSchema == null || this.readerSchema == null || this.readerFileTypes == null) {
            return null;
        }
        boolean[] result = new boolean[this.readerSchema.getMaximumId() + 1];
        result[this.readerSchema.getId()] = safePpd = this.validatePPDConversion(this.fileSchema, this.readerSchema);
        List<TypeDescription> children = this.readerSchema.getChildren();
        if (children != null) {
            for (TypeDescription child : children) {
                TypeDescription fileType = this.getFileType(child.getId());
                result[child.getId()] = safePpd = this.validatePPDConversion(fileType, child);
            }
        }
        return result;
    }

    private boolean validatePPDConversion(TypeDescription fileType, TypeDescription readerType) {
        if (fileType == null) {
            return false;
        }
        if (fileType.getCategory().isPrimitive()) {
            if (fileType.getCategory().equals((Object)readerType.getCategory())) {
                return !fileType.getCategory().equals((Object)TypeDescription.Category.DECIMAL) || fileType.equals(readerType);
            }
            switch (fileType.getCategory()) {
                case BYTE: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.SHORT) && !readerType.getCategory().equals((Object)TypeDescription.Category.INT) && !readerType.getCategory().equals((Object)TypeDescription.Category.LONG)) break;
                    return true;
                }
                case SHORT: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.INT) && !readerType.getCategory().equals((Object)TypeDescription.Category.LONG)) break;
                    return true;
                }
                case INT: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.LONG)) break;
                    return true;
                }
                case STRING: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.VARCHAR)) break;
                    return true;
                }
                case VARCHAR: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.STRING)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean includeReaderColumn(int readerId) {
        return this.readerIncluded == null || readerId <= this.readerColumnOffset || this.readerIncluded[readerId - this.readerColumnOffset];
    }

    void buildConversionFileTypesArray(TypeDescription fileType, TypeDescription readerType) {
        boolean isOk;
        int readerId;
        block19: {
            block18: {
                readerId = readerType.getId();
                if (!this.includeReaderColumn(readerId)) {
                    return;
                }
                isOk = true;
                if (fileType.getCategory() != readerType.getCategory()) break block18;
                switch (readerType.getCategory()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case STRING: 
                    case BOOLEAN: 
                    case LONG: 
                    case DOUBLE: 
                    case FLOAT: 
                    case TIMESTAMP: 
                    case BINARY: 
                    case DATE: {
                        break block19;
                    }
                    case VARCHAR: 
                    case CHAR: {
                        if (fileType.getMaxLength() != readerType.getMaxLength()) {
                            this.hasConversion = true;
                        }
                        break block19;
                    }
                    case DECIMAL: {
                        if (fileType.getPrecision() != readerType.getPrecision() || fileType.getScale() != readerType.getScale()) {
                            this.hasConversion = true;
                        }
                        break block19;
                    }
                    case UNION: 
                    case MAP: 
                    case LIST: {
                        List<TypeDescription> fileChildren = fileType.getChildren();
                        List<TypeDescription> readerChildren = readerType.getChildren();
                        if (fileChildren.size() == readerChildren.size()) {
                            for (int i = 0; i < fileChildren.size(); ++i) {
                                this.buildConversionFileTypesArray(fileChildren.get(i), readerChildren.get(i));
                            }
                        } else {
                            isOk = false;
                        }
                        break block19;
                    }
                    case STRUCT: {
                        List<TypeDescription> fileChildren = fileType.getChildren();
                        List<TypeDescription> readerChildren = readerType.getChildren();
                        if (fileChildren.size() != readerChildren.size()) {
                            this.hasConversion = true;
                        }
                        int jointSize = Math.min(fileChildren.size(), readerChildren.size());
                        for (int i = 0; i < jointSize; ++i) {
                            this.buildConversionFileTypesArray(fileChildren.get(i), readerChildren.get(i));
                        }
                        break block19;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type " + readerType);
                    }
                }
            }
            isOk = ConvertTreeReaderFactory.canConvert(fileType, readerType);
            this.hasConversion = true;
        }
        if (isOk) {
            if (this.readerFileTypes[readerId] != null) {
                throw new RuntimeException("reader to file type entry already assigned");
            }
        } else {
            throw new IllegalArgumentException(String.format("ORC does not support type conversion from file type %s (%d) to reader type %s (%d)", fileType.toString(), fileType.getId(), readerType.toString(), readerId));
        }
        this.readerFileTypes[readerId] = fileType;
        this.fileIncluded[fileType.getId()] = true;
    }

    private void buildSameSchemaFileTypesArray() {
        this.buildSameSchemaFileTypesArrayRecurse(this.readerSchema);
    }

    void buildSameSchemaFileTypesArrayRecurse(TypeDescription readerType) {
        int id = readerType.getId();
        if (!this.includeReaderColumn(id)) {
            return;
        }
        if (this.readerFileTypes[id] != null) {
            throw new RuntimeException("reader to file type entry already assigned");
        }
        this.readerFileTypes[id] = readerType;
        this.fileIncluded[id] = true;
        List<TypeDescription> children = readerType.getChildren();
        if (children != null) {
            for (TypeDescription child : children) {
                this.buildSameSchemaFileTypesArrayRecurse(child);
            }
        }
    }

    private static boolean checkAcidSchema(TypeDescription type) {
        List<String> rootFields;
        return type.getCategory().equals((Object)TypeDescription.Category.STRUCT) && acidEventFieldNames.equals(rootFields = type.getFieldNames());
    }

    public static TypeDescription createEventSchema(TypeDescription typeDescr) {
        TypeDescription result = TypeDescription.createStruct().addField("operation", TypeDescription.createInt()).addField("originalTransaction", TypeDescription.createLong()).addField("bucket", TypeDescription.createInt()).addField("rowId", TypeDescription.createLong()).addField("currentTransaction", TypeDescription.createLong()).addField("row", typeDescr.clone());
        return result;
    }

    static {
        acidEventFieldNames.add("operation");
        acidEventFieldNames.add("originalTransaction");
        acidEventFieldNames.add("bucket");
        acidEventFieldNames.add("rowId");
        acidEventFieldNames.add("currentTransaction");
        acidEventFieldNames.add("row");
    }
}

