/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncFloorDecimalToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncFloorDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncFloorLongToLong;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloorCeilBase;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="floor", value="_FUNC_(x) - Find the largest integer not greater than x", extended="Example:\n  > SELECT _FUNC_(-0.1) FROM src LIMIT 1;\n  -1\n  > SELECT _FUNC_(5) FROM src LIMIT 1;\n  5")
@VectorizedExpressions(value={FuncFloorLongToLong.class, FuncFloorDoubleToLong.class, FuncFloorDecimalToDecimal.class})
public final class GenericUDFFloor
extends GenericUDFFloorCeilBase {
    public GenericUDFFloor() {
        this.opDisplayName = "floor";
    }

    @Override
    protected LongWritable evaluate(DoubleWritable input) {
        this.longWritable.set((long)Math.floor(input.get()));
        return this.longWritable;
    }

    @Override
    protected HiveDecimalWritable evaluate(HiveDecimalWritable input) {
        this.decimalWritable.set(input);
        this.decimalWritable.mutateSetScale(0, 3);
        return this.decimalWritable;
    }
}

