/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStreamingEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="sum", value="_FUNC_(x) - Returns the sum of a set of numbers")
public class GenericUDAFSum
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDAFSum.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new GenericUDAFSumLong();
            }
            case TIMESTAMP: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new GenericUDAFSumDouble();
            }
            case DECIMAL: {
                return new GenericUDAFSumHiveDecimal();
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    @Override
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        TypeInfo[] parameters = info.getParameters();
        GenericUDAFSumEvaluator eval = (GenericUDAFSumEvaluator)this.getEvaluator(parameters);
        eval.setSumDistinct(info.isDistinct());
        return eval;
    }

    public static PrimitiveObjectInspector.PrimitiveCategory getReturnType(TypeInfo type) {
        if (type.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return null;
        }
        switch (((PrimitiveTypeInfo)type).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return PrimitiveObjectInspector.PrimitiveCategory.LONG;
            }
            case TIMESTAMP: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return PrimitiveObjectInspector.PrimitiveCategory.DOUBLE;
            }
            case DECIMAL: {
                return PrimitiveObjectInspector.PrimitiveCategory.DECIMAL;
            }
        }
        return null;
    }

    public static class GenericUDAFSumLong
    extends GenericUDAFSumEvaluator<LongWritable> {
        private boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.result = new LongWritable(0L);
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            this.outputOI = (PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector(this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            SumLongAgg result = new SumLongAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumLongAgg myagg = (SumLongAgg)agg;
            myagg.empty = true;
            myagg.sum = 0L;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block4: {
                assert (parameters.length == 1);
                try {
                    if (this.checkDistinct((GenericUDAFSumEvaluator.SumAgg)agg, parameters[0])) {
                        this.merge(agg, parameters[0]);
                    }
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block4;
                    this.warned = true;
                    LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                SumLongAgg myagg;
                SumLongAgg sumLongAgg = myagg = (SumLongAgg)agg;
                sumLongAgg.sum = (Long)sumLongAgg.sum + PrimitiveObjectInspectorUtils.getLong(partial, this.inputOI);
                myagg.empty = false;
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumLongAgg myagg = (SumLongAgg)agg;
            if (myagg.empty) {
                return null;
            }
            ((LongWritable)this.result).set(((Long)myagg.sum).longValue());
            return this.result;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrameDef) {
            return new GenericUDAFStreamingEvaluator.SumAvgEnhancer<LongWritable, Long>((GenericUDAFEvaluator)this, wFrameDef){

                @Override
                protected LongWritable getNextResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumLongAgg myagg = (SumLongAgg)ss.wrappedBuf;
                    Long r = myagg.empty ? null : (Long)myagg.sum;
                    Long d = (Long)ss.retrieveNextIntermediateValue();
                    if (d != null) {
                        r = r == null ? null : Long.valueOf(r - d);
                    }
                    return r == null ? null : new LongWritable(r.longValue());
                }

                @Override
                protected Long getCurrentIntermediateResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumLongAgg myagg = (SumLongAgg)ss.wrappedBuf;
                    return myagg.empty ? null : new Long((Long)myagg.sum);
                }
            };
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class SumLongAgg
        extends GenericUDAFSumEvaluator.SumAgg<Long> {
            SumLongAgg() {
            }

            @Override
            public int estimate() {
                return 12;
            }
        }
    }

    public static class GenericUDAFSumDouble
    extends GenericUDAFSumEvaluator<DoubleWritable> {
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.result = new DoubleWritable(0.0);
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            this.outputOI = (PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector(this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            SumDoubleAgg result = new SumDoubleAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumDoubleAgg myagg = (SumDoubleAgg)agg;
            myagg.empty = true;
            myagg.sum = 0.0;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block4: {
                assert (parameters.length == 1);
                try {
                    if (this.checkDistinct((GenericUDAFSumEvaluator.SumAgg)agg, parameters[0])) {
                        this.merge(agg, parameters[0]);
                    }
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block4;
                    this.warned = true;
                    LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                    LOG.warn(this.getClass().getSimpleName() + " ignoring similar exceptions.");
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                SumDoubleAgg myagg = (SumDoubleAgg)agg;
                myagg.empty = false;
                SumDoubleAgg sumDoubleAgg = myagg;
                sumDoubleAgg.sum = (Double)sumDoubleAgg.sum + PrimitiveObjectInspectorUtils.getDouble(partial, this.inputOI);
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumDoubleAgg myagg = (SumDoubleAgg)agg;
            if (myagg.empty) {
                return null;
            }
            ((DoubleWritable)((Object)this.result)).set((Double)myagg.sum);
            return this.result;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrameDef) {
            return new GenericUDAFStreamingEvaluator.SumAvgEnhancer<DoubleWritable, Double>((GenericUDAFEvaluator)this, wFrameDef){

                @Override
                protected DoubleWritable getNextResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumDoubleAgg myagg = (SumDoubleAgg)ss.wrappedBuf;
                    Double r = myagg.empty ? null : (Double)myagg.sum;
                    Double d = (Double)ss.retrieveNextIntermediateValue();
                    if (d != null) {
                        r = r == null ? null : Double.valueOf(r - d);
                    }
                    return r == null ? null : new DoubleWritable(r);
                }

                @Override
                protected Double getCurrentIntermediateResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumDoubleAgg myagg = (SumDoubleAgg)ss.wrappedBuf;
                    return myagg.empty ? null : new Double((Double)myagg.sum);
                }
            };
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class SumDoubleAgg
        extends GenericUDAFSumEvaluator.SumAgg<Double> {
            SumDoubleAgg() {
            }

            @Override
            public int estimate() {
                return 12;
            }
        }
    }

    public static class GenericUDAFSumHiveDecimal
    extends GenericUDAFSumEvaluator<HiveDecimalWritable> {
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.result = new HiveDecimalWritable(0L);
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            DecimalTypeInfo outputTypeInfo = null;
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                int precision = Math.min(38, this.inputOI.precision() + 10);
                outputTypeInfo = TypeInfoFactory.getDecimalTypeInfo(precision, this.inputOI.scale());
            } else {
                outputTypeInfo = (DecimalTypeInfo)this.inputOI.getTypeInfo();
            }
            AbstractPrimitiveWritableObjectInspector oi = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(outputTypeInfo);
            this.outputOI = (PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector(oi, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return oi;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            SumHiveDecimalWritableAgg agg = new SumHiveDecimalWritableAgg();
            this.reset(agg);
            return agg;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            GenericUDAFSumEvaluator.SumAgg bdAgg = (GenericUDAFSumEvaluator.SumAgg)agg;
            bdAgg.empty = true;
            bdAgg.sum = new HiveDecimalWritable(0L);
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block4: {
                assert (parameters.length == 1);
                try {
                    if (this.checkDistinct((SumHiveDecimalWritableAgg)agg, parameters[0])) {
                        this.merge(agg, parameters[0]);
                    }
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block4;
                    this.warned = true;
                    LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                    LOG.warn(this.getClass().getSimpleName() + " ignoring similar exceptions.");
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                SumHiveDecimalWritableAgg myagg = (SumHiveDecimalWritableAgg)agg;
                if (myagg.sum == null || !((HiveDecimalWritable)myagg.sum).isSet()) {
                    return;
                }
                myagg.empty = false;
                ((HiveDecimalWritable)myagg.sum).mutateAdd(PrimitiveObjectInspectorUtils.getHiveDecimal(partial, this.inputOI));
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumHiveDecimalWritableAgg myagg = (SumHiveDecimalWritableAgg)agg;
            if (myagg.empty || myagg.sum == null || !((HiveDecimalWritable)myagg.sum).isSet()) {
                return null;
            }
            DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)this.outputOI.getTypeInfo();
            ((HiveDecimalWritable)myagg.sum).mutateEnforcePrecisionScale(decimalTypeInfo.getPrecision(), decimalTypeInfo.getScale());
            if (!((HiveDecimalWritable)myagg.sum).isSet()) {
                LOG.warn("The sum of a column with data type HiveDecimal is out of range");
                return null;
            }
            ((HiveDecimalWritable)this.result).set((HiveDecimalWritable)myagg.sum);
            return this.result;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrameDef) {
            return new GenericUDAFStreamingEvaluator.SumAvgEnhancer<HiveDecimalWritable, HiveDecimal>((GenericUDAFEvaluator)this, wFrameDef){

                @Override
                protected HiveDecimalWritable getNextResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumHiveDecimalWritableAgg myagg = (SumHiveDecimalWritableAgg)ss.wrappedBuf;
                    HiveDecimal r = myagg.empty ? null : ((HiveDecimalWritable)myagg.sum).getHiveDecimal();
                    HiveDecimal d = (HiveDecimal)ss.retrieveNextIntermediateValue();
                    if (d != null) {
                        r = r == null ? null : r.subtract(d);
                    }
                    return r == null ? null : new HiveDecimalWritable(r);
                }

                @Override
                protected HiveDecimal getCurrentIntermediateResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumHiveDecimalWritableAgg myagg = (SumHiveDecimalWritableAgg)ss.wrappedBuf;
                    return myagg.empty ? null : ((HiveDecimalWritable)myagg.sum).getHiveDecimal();
                }
            };
        }

        @GenericUDAFEvaluator.AggregationType(estimable=false)
        static class SumHiveDecimalWritableAgg
        extends GenericUDAFSumEvaluator.SumAgg<HiveDecimalWritable> {
            SumHiveDecimalWritableAgg() {
            }
        }
    }

    public static abstract class GenericUDAFSumEvaluator<ResultType>
    extends GenericUDAFEvaluator {
        protected PrimitiveObjectInspector inputOI;
        protected PrimitiveObjectInspector outputOI;
        protected ResultType result;
        protected boolean sumDistinct;

        public boolean sumDistinct() {
            return this.sumDistinct;
        }

        public void setSumDistinct(boolean sumDistinct) {
            this.sumDistinct = sumDistinct;
        }

        protected boolean checkDistinct(SumAgg agg, Object input) {
            if (this.sumDistinct && ObjectInspectorUtils.compare(input, this.inputOI, agg.previousValue, this.outputOI) == 0) {
                return false;
            }
            agg.previousValue = ObjectInspectorUtils.copyToStandardObject(input, this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return true;
        }

        static abstract class SumAgg<T>
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            boolean empty;
            T sum;
            Object previousValue = null;

            SumAgg() {
            }
        }
    }
}

