/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.StringableMap;
import org.apache.hadoop.hive.common.ValidCompactorTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactorMR {
    private static final String CLASS_NAME = CompactorMR.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final String INPUT_FORMAT_CLASS_NAME = "hive.compactor.input.format.class.name";
    private static final String OUTPUT_FORMAT_CLASS_NAME = "hive.compactor.output.format.class.name";
    private static final String TMP_LOCATION = "hive.compactor.input.tmp.dir";
    private static final String FINAL_LOCATION = "hive.compactor.input.dir";
    private static final String MIN_TXN = "hive.compactor.txn.min";
    private static final String MAX_TXN = "hive.compactor.txn.max";
    private static final String IS_MAJOR = "hive.compactor.is.major";
    private static final String IS_COMPRESSED = "hive.compactor.is.compressed";
    private static final String TABLE_PROPS = "hive.compactor.table.props";
    private static final String NUM_BUCKETS = "hive.compactor.num.buckets";
    private static final String BASE_DIR = "hive.compactor.base.dir";
    private static final String DELTA_DIRS = "hive.compactor.delta.dirs";
    private static final String DIRS_TO_SEARCH = "hive.compactor.dirs.to.search";
    private static final String TMPDIR = "_tmp";
    private static final String TBLPROPS_PREFIX = "tblprops.";
    private static final String COMPACTOR_PREFIX = "compactor.";
    private JobConf mrJob;

    private JobConf createBaseJobConf(HiveConf conf, String jobName, Table t, StorageDescriptor sd, ValidTxnList txns, CompactionInfo ci) {
        JobConf job = new JobConf((Configuration)conf);
        job.setJobName(jobName);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setJarByClass(CompactorMR.class);
        LOG.debug("User jar set to " + job.getJar());
        job.setMapperClass(CompactorMap.class);
        job.setNumReduceTasks(0);
        job.setInputFormat(CompactorInputFormat.class);
        job.setOutputFormat(NullOutputFormat.class);
        job.setOutputCommitter(CompactorOutputCommitter.class);
        String queueName = conf.getVar(HiveConf.ConfVars.COMPACTOR_JOB_QUEUE);
        if (queueName != null && queueName.length() > 0) {
            job.setQueueName(queueName);
        }
        job.set(FINAL_LOCATION, sd.getLocation());
        job.set(TMP_LOCATION, sd.getLocation() + "/" + TMPDIR + "_" + UUID.randomUUID().toString());
        job.set(INPUT_FORMAT_CLASS_NAME, sd.getInputFormat());
        job.set(OUTPUT_FORMAT_CLASS_NAME, sd.getOutputFormat());
        job.setBoolean(IS_COMPRESSED, sd.isCompressed());
        job.set(TABLE_PROPS, new StringableMap(t.getParameters()).toString());
        job.setInt(NUM_BUCKETS, sd.getNumBuckets());
        job.set("hive.txn.valid.txns", txns.toString());
        this.overrideMRProps(job, t.getParameters());
        if (ci.properties != null) {
            this.overrideTblProps(job, t.getParameters(), ci.properties);
        }
        this.setColumnTypes(job, sd.getCols());
        job.setBoolean("mapreduce.map.speculative", false);
        return job;
    }

    private void overrideTblProps(JobConf job, Map<String, String> tblproperties, String properties) {
        StringableMap stringableMap = new StringableMap(properties);
        this.overrideMRProps(job, stringableMap);
        for (String key : stringableMap.keySet()) {
            if (!key.startsWith(TBLPROPS_PREFIX)) continue;
            String propKey = key.substring(9);
            tblproperties.put(propKey, (String)stringableMap.get(key));
        }
        job.set(TABLE_PROPS, new StringableMap(tblproperties).toString());
    }

    private void overrideMRProps(JobConf job, Map<String, String> properties) {
        for (String key : properties.keySet()) {
            if (!key.startsWith(COMPACTOR_PREFIX)) continue;
            String mrKey = key.substring(10);
            job.set(mrKey, properties.get(key));
        }
    }

    void run(HiveConf conf, String jobName, Table t, StorageDescriptor sd, ValidTxnList txns, CompactionInfo ci, Worker.StatsUpdater su, TxnStore txnHandler) throws IOException {
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION)) {
            throw new RuntimeException(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION.name() + "=true");
        }
        JobConf job = this.createBaseJobConf(conf, jobName, t, sd, txns, ci);
        AcidUtils.Directory dir = AcidUtils.getAcidState(new Path(sd.getLocation()), (Configuration)conf, txns, false, true);
        List<AcidUtils.ParsedDelta> parsedDeltas = dir.getCurrentDirectories();
        int maxDeltastoHandle = conf.getIntVar(HiveConf.ConfVars.COMPACTOR_MAX_NUM_DELTA);
        if (parsedDeltas.size() > maxDeltastoHandle) {
            LOG.warn(parsedDeltas.size() + " delta files found for " + ci.getFullPartitionName() + " located at " + sd.getLocation() + "! This is likely a sign of misconfiguration, especially if this message repeats.  Check that compaction is running properly.  Check for any runaway/mis-configured process writing to ACID tables, especially using Streaming Ingest API.");
            int numMinorCompactions = parsedDeltas.size() / maxDeltastoHandle;
            for (int jobSubId = 0; jobSubId < numMinorCompactions; ++jobSubId) {
                JobConf jobMinorCompact = this.createBaseJobConf(conf, jobName + "_" + jobSubId, t, sd, txns, ci);
                this.launchCompactionJob(jobMinorCompact, null, CompactionType.MINOR, null, parsedDeltas.subList(jobSubId * maxDeltastoHandle, (jobSubId + 1) * maxDeltastoHandle), maxDeltastoHandle, -1, conf, txnHandler, ci.id, jobName);
            }
            dir = AcidUtils.getAcidState(new Path(sd.getLocation()), conf, txns);
        }
        StringableList dirsToSearch = new StringableList();
        Path baseDir = null;
        if (ci.isMajorCompaction()) {
            baseDir = dir.getBaseDirectory();
            if (baseDir == null) {
                List<HadoopShims.HdfsFileStatusWithId> originalFiles = dir.getOriginalFiles();
                if (originalFiles != null && originalFiles.size() != 0) {
                    for (HadoopShims.HdfsFileStatusWithId stat : originalFiles) {
                        Path path = stat.getFileStatus().getPath();
                        dirsToSearch.add(path);
                        LOG.debug("Adding original file " + path + " to dirs to search");
                    }
                    baseDir = new Path(sd.getLocation());
                }
            } else {
                LOG.debug("Adding base directory " + baseDir + " to dirs to search");
                dirsToSearch.add(baseDir);
            }
        }
        if (parsedDeltas.size() == 0 && dir.getOriginalFiles() == null) {
            LOG.error("No delta files or original files found to compact in " + sd.getLocation());
            return;
        }
        this.launchCompactionJob(job, baseDir, ci.type, dirsToSearch, dir.getCurrentDirectories(), dir.getCurrentDirectories().size(), dir.getObsolete().size(), conf, txnHandler, ci.id, jobName);
        su.gatherStats();
    }

    private void launchCompactionJob(JobConf job, Path baseDir, CompactionType compactionType, StringableList dirsToSearch, List<AcidUtils.ParsedDelta> parsedDeltas, int curDirNumber, int obsoleteDirNumber, HiveConf hiveConf, TxnStore txnHandler, long id, String jobName) throws IOException {
        job.setBoolean(IS_MAJOR, compactionType == CompactionType.MAJOR);
        if (dirsToSearch == null) {
            dirsToSearch = new StringableList();
        }
        StringableList deltaDirs = new StringableList();
        long minTxn = Long.MAX_VALUE;
        long maxTxn = Long.MIN_VALUE;
        for (AcidUtils.ParsedDelta delta : parsedDeltas) {
            LOG.debug("Adding delta " + delta.getPath() + " to directories to search");
            dirsToSearch.add(delta.getPath());
            deltaDirs.add(delta.getPath());
            minTxn = Math.min(minTxn, delta.getMinTransaction());
            maxTxn = Math.max(maxTxn, delta.getMaxTransaction());
        }
        if (baseDir != null) {
            job.set(BASE_DIR, baseDir.toString());
        }
        job.set(DELTA_DIRS, deltaDirs.toString());
        job.set(DIRS_TO_SEARCH, dirsToSearch.toString());
        job.setLong(MIN_TXN, minTxn);
        job.setLong(MAX_TXN, maxTxn);
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            this.mrJob = job;
        }
        LOG.info("Submitting " + compactionType + " compaction job '" + job.getJobName() + "' to " + job.getQueueName() + " queue.  (current delta dirs count=" + curDirNumber + ", obsolete delta dirs count=" + obsoleteDirNumber + ". TxnIdRange[" + minTxn + "," + maxTxn + "]");
        RunningJob rj = new JobClient(job).submitJob(job);
        LOG.info("Submitted compaction job '" + job.getJobName() + "' with jobID=" + rj.getID() + " compaction ID=" + id);
        txnHandler.setHadoopJobId(rj.getID().toString(), id);
        rj.waitForCompletion();
        if (!rj.isSuccessful()) {
            throw new IOException(compactionType == CompactionType.MAJOR ? "Major" : "Minor compactor job failed for " + jobName + "! Hadoop JobId: " + rj.getID());
        }
    }

    private void setColumnTypes(JobConf job, List<FieldSchema> cols) {
        StringBuilder colNames = new StringBuilder();
        StringBuilder colTypes = new StringBuilder();
        boolean isFirst = true;
        for (FieldSchema col : cols) {
            if (isFirst) {
                isFirst = false;
            } else {
                colNames.append(',');
                colTypes.append(',');
            }
            colNames.append(col.getName());
            colTypes.append(col.getType());
        }
        job.set("schema.evolution.columns", colNames.toString());
        job.set("schema.evolution.columns.types", colTypes.toString());
        HiveConf.setBoolVar((Configuration)job, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, true);
        HiveConf.setVar((Configuration)job, HiveConf.ConfVars.HIVEINPUTFORMAT, HiveInputFormat.class.getName());
    }

    public JobConf getMrJob() {
        return this.mrJob;
    }

    private static <T> T instantiate(Class<T> classType, String classname) throws IOException {
        T t = null;
        try {
            Class c = JavaUtils.loadClass(classname);
            Object o = c.newInstance();
            if (!classType.isAssignableFrom(o.getClass())) {
                String s = classname + " is not an instance of " + classType.getName();
                LOG.error(s);
                throw new IOException(s);
            }
            t = o;
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to instantiate class, " + StringUtils.stringifyException((Throwable)e));
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            LOG.error("Unable to instantiate class, " + StringUtils.stringifyException((Throwable)e));
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Unable to instantiate class, " + StringUtils.stringifyException((Throwable)e));
            throw new IOException(e);
        }
        return t;
    }

    static class CompactorOutputCommitter
    extends OutputCommitter {
        CompactorOutputCommitter() {
        }

        public void setupJob(JobContext jobContext) throws IOException {
        }

        public void setupTask(TaskAttemptContext taskAttemptContext) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) throws IOException {
            return false;
        }

        public void commitTask(TaskAttemptContext taskAttemptContext) throws IOException {
        }

        public void abortTask(TaskAttemptContext taskAttemptContext) throws IOException {
        }

        public void commitJob(JobContext context) throws IOException {
            JobConf conf = ShimLoader.getHadoopShims().getJobConf(context);
            Path tmpLocation = new Path(conf.get(CompactorMR.TMP_LOCATION));
            Path finalLocation = new Path(conf.get(CompactorMR.FINAL_LOCATION));
            FileSystem fs = tmpLocation.getFileSystem((Configuration)conf);
            LOG.debug("Moving contents of " + tmpLocation.toString() + " to " + finalLocation.toString());
            FileStatus[] contents = fs.listStatus(tmpLocation);
            for (int i = 0; i < contents.length; ++i) {
                Path newPath = new Path(finalLocation, contents[i].getPath().getName());
                fs.rename(contents[i].getPath(), newPath);
            }
            fs.delete(tmpLocation, true);
        }

        public void abortJob(JobContext context, int status) throws IOException {
            JobConf conf = ShimLoader.getHadoopShims().getJobConf(context);
            Path tmpLocation = new Path(conf.get(CompactorMR.TMP_LOCATION));
            FileSystem fs = tmpLocation.getFileSystem((Configuration)conf);
            LOG.debug("Removing " + tmpLocation.toString());
            fs.delete(tmpLocation, true);
        }
    }

    static class StringableList
    extends ArrayList<Path> {
        StringableList() {
        }

        StringableList(String s) {
            String[] parts = s.split(":", 2);
            int numElements = Integer.parseInt(parts[0]);
            s = parts[1];
            for (int i = 0; i < numElements; ++i) {
                parts = s.split(":", 2);
                int len = Integer.parseInt(parts[0]);
                String val = parts[1].substring(0, len);
                s = parts[1].substring(len);
                this.add(new Path(val));
            }
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.size());
            buf.append(':');
            if (this.size() > 0) {
                for (Path p : this) {
                    String pStr = p.toString();
                    buf.append(pStr.length());
                    buf.append(':');
                    buf.append(pStr);
                }
            }
            return buf.toString();
        }
    }

    static class CompactorMap<V extends Writable>
    implements Mapper<WritableComparable, CompactorInputSplit, NullWritable, NullWritable> {
        JobConf jobConf;
        FileSinkOperator.RecordWriter writer;

        CompactorMap() {
        }

        public void map(WritableComparable key, CompactorInputSplit split, OutputCollector<NullWritable, NullWritable> nullWritableVOutputCollector, Reporter reporter) throws IOException {
            AcidInputFormat aif = (AcidInputFormat)CompactorMR.instantiate(AcidInputFormat.class, this.jobConf.get(CompactorMR.INPUT_FORMAT_CLASS_NAME));
            ValidCompactorTxnList txnList = new ValidCompactorTxnList(this.jobConf.get("hive.txn.valid.txns"));
            boolean isMajor = this.jobConf.getBoolean(CompactorMR.IS_MAJOR, false);
            AcidInputFormat.RawReader reader = aif.getRawReader((Configuration)this.jobConf, isMajor, split.getBucket(), txnList, split.getBaseDir(), split.getDeltaDirs());
            RecordIdentifier identifier = (RecordIdentifier)reader.createKey();
            Writable value = (Writable)reader.createValue();
            this.getWriter(reporter, reader.getObjectInspector(), split.getBucket());
            while (reader.next(identifier, value)) {
                if (isMajor && reader.isDelete(value)) continue;
                this.writer.write(value);
                reporter.progress();
            }
        }

        public void configure(JobConf entries) {
            this.jobConf = entries;
        }

        public void close() throws IOException {
            if (this.writer != null) {
                this.writer.close(false);
            }
        }

        private void getWriter(Reporter reporter, ObjectInspector inspector, int bucket) throws IOException {
            if (this.writer == null) {
                AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.jobConf);
                options.inspector(inspector).writingBase(this.jobConf.getBoolean(CompactorMR.IS_MAJOR, false)).isCompressed(this.jobConf.getBoolean(CompactorMR.IS_COMPRESSED, false)).tableProperties(new StringableMap(this.jobConf.get(CompactorMR.TABLE_PROPS)).toProperties()).reporter(reporter).minimumTransactionId(this.jobConf.getLong(CompactorMR.MIN_TXN, Long.MAX_VALUE)).maximumTransactionId(this.jobConf.getLong(CompactorMR.MAX_TXN, Long.MIN_VALUE)).bucket(bucket).statementId(-1);
                AcidOutputFormat aof = (AcidOutputFormat)CompactorMR.instantiate(AcidOutputFormat.class, this.jobConf.get(CompactorMR.OUTPUT_FORMAT_CLASS_NAME));
                this.writer = aof.getRawRecordWriter(new Path(this.jobConf.get(CompactorMR.TMP_LOCATION)), options);
            }
        }
    }

    static class CompactorRecordReader
    implements RecordReader<NullWritable, CompactorInputSplit> {
        private CompactorInputSplit split;

        CompactorRecordReader(CompactorInputSplit split) {
            this.split = split;
        }

        public boolean next(NullWritable key, CompactorInputSplit compactorInputSplit) throws IOException {
            if (this.split != null) {
                compactorInputSplit.set(this.split);
                this.split = null;
                return true;
            }
            return false;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public CompactorInputSplit createValue() {
            return new CompactorInputSplit();
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException {
            return 0.0f;
        }
    }

    static class CompactorInputFormat
    implements InputFormat<NullWritable, CompactorInputSplit> {
        CompactorInputFormat() {
        }

        public InputSplit[] getSplits(JobConf entries, int i) throws IOException {
            Path baseDir = null;
            if (entries.get(CompactorMR.BASE_DIR) != null) {
                baseDir = new Path(entries.get(CompactorMR.BASE_DIR));
            }
            StringableList tmpDeltaDirs = new StringableList(entries.get(CompactorMR.DELTA_DIRS));
            Path[] deltaDirs = tmpDeltaDirs.toArray(new Path[tmpDeltaDirs.size()]);
            StringableList dirsToSearch = new StringableList(entries.get(CompactorMR.DIRS_TO_SEARCH));
            HashMap<Integer, BucketTracker> splitToBucketMap = new HashMap<Integer, BucketTracker>();
            for (Path dir : dirsToSearch) {
                FileSystem fs = dir.getFileSystem((Configuration)entries);
                if (dir.getName().startsWith("base_") || dir.getName().startsWith("delta_")) {
                    FileStatus[] files;
                    boolean sawBase = dir.getName().startsWith("base_");
                    for (FileStatus f : files = fs.listStatus(dir, AcidUtils.bucketFileFilter)) {
                        Matcher matcher = AcidUtils.BUCKET_DIGIT_PATTERN.matcher(f.getPath().getName());
                        this.addFileToMap(matcher, f.getPath(), sawBase, splitToBucketMap);
                    }
                    continue;
                }
                Matcher matcher = AcidUtils.LEGACY_BUCKET_DIGIT_PATTERN.matcher(dir.getName());
                this.addFileToMap(matcher, dir, true, splitToBucketMap);
            }
            ArrayList<CompactorInputSplit> splits = new ArrayList<CompactorInputSplit>(splitToBucketMap.size());
            for (Map.Entry e : splitToBucketMap.entrySet()) {
                BucketTracker bt = (BucketTracker)e.getValue();
                splits.add(new CompactorInputSplit((Configuration)entries, (Integer)e.getKey(), bt.buckets, (Path)(bt.sawBase ? baseDir : null), deltaDirs));
            }
            LOG.debug("Returning " + splits.size() + " splits");
            return splits.toArray(new InputSplit[splits.size()]);
        }

        public RecordReader<NullWritable, CompactorInputSplit> getRecordReader(InputSplit inputSplit, JobConf entries, Reporter reporter) throws IOException {
            return new CompactorRecordReader((CompactorInputSplit)inputSplit);
        }

        private void addFileToMap(Matcher matcher, Path file, boolean sawBase, Map<Integer, BucketTracker> splitToBucketMap) {
            int bucketNum;
            BucketTracker bt;
            if (!matcher.find()) {
                LOG.warn("Found a non-bucket file that we thought matched the bucket pattern! " + file.toString() + " Matcher=" + matcher.toString());
            }
            if ((bt = splitToBucketMap.get(bucketNum = Integer.parseInt(matcher.group()))) == null) {
                bt = new BucketTracker();
                splitToBucketMap.put(bucketNum, bt);
            }
            LOG.debug("Adding " + file.toString() + " to list of files for splits");
            bt.buckets.add(file);
            bt.sawBase |= sawBase;
        }

        private static class BucketTracker {
            boolean sawBase = false;
            List<Path> buckets = new ArrayList<Path>();

            BucketTracker() {
            }
        }
    }

    static class CompactorInputSplit
    implements InputSplit {
        private long length = 0L;
        private List<String> locations;
        private int bucketNum;
        private Path base;
        private Path[] deltas;

        public CompactorInputSplit() {
        }

        CompactorInputSplit(Configuration hadoopConf, int bucket, List<Path> files, Path base, Path[] deltas) throws IOException {
            this.bucketNum = bucket;
            this.base = base;
            this.deltas = deltas;
            this.locations = new ArrayList<String>();
            for (Path path : files) {
                FileSystem fs = path.getFileSystem(hadoopConf);
                FileStatus stat = fs.getFileStatus(path);
                this.length += stat.getLen();
                BlockLocation[] locs = fs.getFileBlockLocations(stat, 0L, this.length);
                for (int i = 0; i < locs.length; ++i) {
                    String[] hosts = locs[i].getHosts();
                    for (int j = 0; j < hosts.length; ++j) {
                        this.locations.add(hosts[j]);
                    }
                }
            }
        }

        public long getLength() throws IOException {
            return this.length;
        }

        public String[] getLocations() throws IOException {
            return this.locations.toArray(new String[this.locations.size()]);
        }

        public void write(DataOutput dataOutput) throws IOException {
            int i;
            dataOutput.writeLong(this.length);
            dataOutput.writeInt(this.locations.size());
            for (i = 0; i < this.locations.size(); ++i) {
                dataOutput.writeInt(this.locations.get(i).length());
                dataOutput.writeBytes(this.locations.get(i));
            }
            dataOutput.writeInt(this.bucketNum);
            if (this.base == null) {
                dataOutput.writeInt(0);
            } else {
                dataOutput.writeInt(this.base.toString().length());
                dataOutput.writeBytes(this.base.toString());
            }
            dataOutput.writeInt(this.deltas.length);
            for (i = 0; i < this.deltas.length; ++i) {
                dataOutput.writeInt(this.deltas[i].toString().length());
                dataOutput.writeBytes(this.deltas[i].toString());
            }
        }

        public void readFields(DataInput dataInput) throws IOException {
            byte[] buf;
            int len;
            int i;
            this.locations = new ArrayList<String>();
            this.length = dataInput.readLong();
            LOG.debug("Read length of " + this.length);
            int numElements = dataInput.readInt();
            LOG.debug("Read numElements of " + numElements);
            for (i = 0; i < numElements; ++i) {
                len = dataInput.readInt();
                LOG.debug("Read file length of " + len);
                buf = new byte[len];
                dataInput.readFully(buf);
                this.locations.add(new String(buf));
            }
            this.bucketNum = dataInput.readInt();
            LOG.debug("Read bucket number of " + this.bucketNum);
            len = dataInput.readInt();
            LOG.debug("Read base path length of " + len);
            if (len > 0) {
                buf = new byte[len];
                dataInput.readFully(buf);
                this.base = new Path(new String(buf));
            }
            numElements = dataInput.readInt();
            this.deltas = new Path[numElements];
            for (i = 0; i < numElements; ++i) {
                len = dataInput.readInt();
                buf = new byte[len];
                dataInput.readFully(buf);
                this.deltas[i] = new Path(new String(buf));
            }
        }

        public void set(CompactorInputSplit other) {
            this.length = other.length;
            this.locations = other.locations;
            this.bucketNum = other.bucketNum;
            this.base = other.base;
            this.deltas = other.deltas;
        }

        int getBucket() {
            return this.bucketNum;
        }

        Path getBaseDir() {
            return this.base;
        }

        Path[] getDeltaDirs() {
            return this.deltas;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CompactorInputSplit{base: ");
            builder.append(this.base);
            builder.append(", bucket: ");
            builder.append(this.bucketNum);
            builder.append(", length: ");
            builder.append(this.length);
            builder.append(", deltas: [");
            for (int i = 0; i < this.deltas.length; ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append(this.deltas[i].getName());
            }
            builder.append("]}");
            return builder.toString();
        }
    }
}

