/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import org.apache.hadoop.hive.ql.plan.AbstractVectorDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;

public class VectorGroupByDesc
extends AbstractVectorDesc {
    private static long serialVersionUID = 1L;
    private ProcessingMode processingMode = ProcessingMode.NONE;
    private boolean isVectorOutput = false;

    public void setProcessingMode(ProcessingMode processingMode) {
        this.processingMode = processingMode;
    }

    public ProcessingMode getProcessingMode() {
        return this.processingMode;
    }

    public boolean isVectorOutput() {
        return this.isVectorOutput;
    }

    public void setVectorOutput(boolean isVectorOutput) {
        this.isVectorOutput = isVectorOutput;
    }

    public static ProcessingMode groupByDescModeToVectorProcessingMode(GroupByDesc.Mode mode, boolean hasKeys) {
        switch (mode) {
            case COMPLETE: {
                return hasKeys ? ProcessingMode.STREAMING : ProcessingMode.GLOBAL;
            }
            case HASH: {
                return ProcessingMode.HASH;
            }
            case MERGEPARTIAL: {
                return hasKeys ? ProcessingMode.MERGE_PARTIAL : ProcessingMode.GLOBAL;
            }
            case PARTIAL1: 
            case PARTIAL2: 
            case PARTIALS: 
            case FINAL: {
                return ProcessingMode.STREAMING;
            }
        }
        throw new RuntimeException("Unexpected GROUP BY mode " + mode.name());
    }

    public static enum ProcessingMode {
        NONE,
        GLOBAL,
        HASH,
        MERGE_PARTIAL,
        STREAMING;

    }
}

