/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.parse.RuntimeValuesInfo;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWork
extends AbstractOperatorDesc {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseWork.class);
    List<HashTableDummyOperator> dummyOps;
    int tag = 0;
    private final List<String> sortColNames = new ArrayList<String>();
    private MapredLocalWork mrLocalWork;
    private boolean gatheringStats;
    private String name;
    protected VectorizedRowBatchCtx vectorizedRowBatchCtx;
    protected boolean useVectorizedInputFileFormat;
    protected long vectorizedVertexNum;
    protected boolean llapMode = false;
    protected boolean uberMode = false;
    private int reservedMemoryMB = -1;
    private Map<String, RuntimeValuesInfo> inputSourceToRuntimeValuesInfo = new HashMap<String, RuntimeValuesInfo>();

    public BaseWork() {
    }

    public BaseWork(String name) {
        this.setName(name);
    }

    public void setGatheringStats(boolean gatherStats) {
        this.gatheringStats = gatherStats;
    }

    public boolean isGatheringStats() {
        return this.gatheringStats;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<HashTableDummyOperator> getDummyOps() {
        return this.dummyOps;
    }

    public void setDummyOps(List<HashTableDummyOperator> dummyOps) {
        if (this.dummyOps != null && !this.dummyOps.isEmpty() && (dummyOps == null || dummyOps.isEmpty())) {
            LOG.info("Removing dummy operators from " + this.name + " " + this.getClass().getSimpleName());
        }
        this.dummyOps = dummyOps;
    }

    public void addDummyOp(HashTableDummyOperator dummyOp) {
        if (this.dummyOps == null) {
            this.dummyOps = new LinkedList<HashTableDummyOperator>();
        }
        this.dummyOps.add(dummyOp);
    }

    public abstract void replaceRoots(Map<Operator<?>, Operator<?>> var1);

    public abstract Set<Operator<? extends OperatorDesc>> getAllRootOperators();

    public abstract Operator<? extends OperatorDesc> getAnyRootOperator();

    public Set<Operator<?>> getAllOperators() {
        LinkedHashSet returnSet = new LinkedHashSet();
        Set<Operator<? extends OperatorDesc>> opSet = this.getAllRootOperators();
        Stack<Operator<? extends OperatorDesc>> opStack = new Stack<Operator<? extends OperatorDesc>>();
        opStack.addAll(opSet);
        while (!opStack.empty()) {
            Operator op = (Operator)opStack.pop();
            returnSet.add(op);
            if (op.getChildOperators() == null) continue;
            opStack.addAll(op.getChildOperators());
        }
        return returnSet;
    }

    public Set<Operator<? extends OperatorDesc>> getAllLeafOperators() {
        LinkedHashSet<Operator<? extends OperatorDesc>> returnSet = new LinkedHashSet<Operator<? extends OperatorDesc>>();
        Set<Operator<? extends OperatorDesc>> opSet = this.getAllRootOperators();
        Stack<Operator<? extends OperatorDesc>> opStack = new Stack<Operator<? extends OperatorDesc>>();
        opStack.addAll(opSet);
        while (!opStack.empty()) {
            Operator op = (Operator)opStack.pop();
            if (op.getNumChild() == 0) {
                returnSet.add(op);
            }
            if (op.getChildOperators() == null) continue;
            opStack.addAll(op.getChildOperators());
        }
        return returnSet;
    }

    public void setVectorizedVertexNum(long vectorizedVertexNum) {
        this.vectorizedVertexNum = vectorizedVertexNum;
    }

    public long getVectorizedVertexNum() {
        return this.vectorizedVertexNum;
    }

    public VectorizedRowBatchCtx getVectorizedRowBatchCtx() {
        return this.vectorizedRowBatchCtx;
    }

    public void setVectorizedRowBatchCtx(VectorizedRowBatchCtx vectorizedRowBatchCtx) {
        this.vectorizedRowBatchCtx = vectorizedRowBatchCtx;
    }

    public void setUseVectorizedInputFileFormat(boolean useVectorizedInputFileFormat) {
        this.useVectorizedInputFileFormat = useVectorizedInputFileFormat;
    }

    public boolean getUseVectorizedInputFileFormat() {
        return this.useVectorizedInputFileFormat;
    }

    @Explain(displayName="Local Work", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public MapredLocalWork getMapRedLocalWork() {
        return this.mrLocalWork;
    }

    public void setMapRedLocalWork(MapredLocalWork mapLocalWork) {
        this.mrLocalWork = mapLocalWork;
    }

    public void setUberMode(boolean uberMode) {
        this.uberMode = uberMode;
    }

    public boolean getUberMode() {
        return this.uberMode;
    }

    public void setLlapMode(boolean llapMode) {
        this.llapMode = llapMode;
    }

    public boolean getLlapMode() {
        return this.llapMode;
    }

    public int getReservedMemoryMB() {
        return this.reservedMemoryMB;
    }

    public void setReservedMemoryMB(int memoryMB) {
        this.reservedMemoryMB = memoryMB;
    }

    public abstract void configureJobConf(JobConf var1);

    public void setTag(int tag) {
        this.tag = tag;
    }

    @Explain(displayName="tag", explainLevels={Explain.Level.USER})
    public int getTag() {
        return this.tag;
    }

    public void addSortCols(List<String> sortCols) {
        this.sortColNames.addAll(sortCols);
    }

    public List<String> getSortCols() {
        return this.sortColNames;
    }

    public Map<String, RuntimeValuesInfo> getInputSourceToRuntimeValuesInfo() {
        return this.inputSourceToRuntimeValuesInfo;
    }

    public void setInputSourceToRuntimeValuesInfo(String workName, RuntimeValuesInfo runtimeValuesInfo) {
        this.inputSourceToRuntimeValuesInfo.put(workName, runtimeValuesInfo);
    }
}

