/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = commandType.get(tree.getType());
        queryState.setCommandType(opType);
        switch (tree.getType()) {
            case 770: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 771: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 832: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 773: {
                return new ExportSemanticAnalyzer(queryState);
            }
            case 799: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 903: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 904: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 905: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 679: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 680: 
                    case 681: 
                    case 682: 
                    case 683: 
                    case 688: 
                    case 689: 
                    case 690: 
                    case 691: 
                    case 695: 
                    case 696: 
                    case 697: 
                    case 698: 
                    case 700: 
                    case 703: 
                    case 705: 
                    case 706: {
                        queryState.setCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                opType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                queryState.setCommandType(opType);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 709: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 710: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                assert (child.getType() == 896);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 671: 
            case 675: 
            case 676: 
            case 677: 
            case 678: 
            case 686: 
            case 721: 
            case 729: 
            case 731: 
            case 734: 
            case 752: 
            case 753: 
            case 754: 
            case 760: 
            case 762: 
            case 764: 
            case 765: 
            case 766: 
            case 784: 
            case 786: 
            case 833: 
            case 834: 
            case 840: 
            case 910: 
            case 911: 
            case 927: 
            case 928: 
            case 929: 
            case 930: 
            case 931: 
            case 932: 
            case 933: 
            case 934: 
            case 935: 
            case 936: 
            case 937: 
            case 938: 
            case 939: 
            case 940: 
            case 941: 
            case 942: 
            case 943: 
            case 944: 
            case 945: 
            case 946: 
            case 964: 
            case 1007: 
            case 1015: 
            case 1016: {
                return new DDLSemanticAnalyzer(queryState);
            }
            case 730: 
            case 761: 
            case 900: {
                return new FunctionSemanticAnalyzer(queryState);
            }
            case 715: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 733: 
            case 763: {
                return new MacroSemanticAnalyzer(queryState);
            }
            case 751: 
            case 838: 
            case 1018: {
                return new UpdateDeleteSemanticAnalyzer(queryState);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar(queryState.getConf(), HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }

    private SemanticAnalyzerFactory() {
    }

    static HiveOperation getOperation(int hiveParserToken) {
        return commandType.get(hiveParserToken);
    }

    static {
        commandType.put(770, HiveOperation.EXPLAIN);
        commandType.put(832, HiveOperation.LOAD);
        commandType.put(773, HiveOperation.EXPORT);
        commandType.put(799, HiveOperation.IMPORT);
        commandType.put(729, HiveOperation.CREATEDATABASE);
        commandType.put(760, HiveOperation.DROPDATABASE);
        commandType.put(964, HiveOperation.SWITCHDATABASE);
        commandType.put(735, HiveOperation.CREATETABLE);
        commandType.put(1007, HiveOperation.TRUNCATETABLE);
        commandType.put(765, HiveOperation.DROPTABLE);
        commandType.put(754, HiveOperation.DESCTABLE);
        commandType.put(753, HiveOperation.DESCFUNCTION);
        commandType.put(840, HiveOperation.MSCK);
        commandType.put(680, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(700, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(698, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(697, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(689, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(682, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(705, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(683, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(706, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(696, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(690, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(691, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(688, HiveOperation.ALTERTABLE_DROPCONSTRAINT);
        commandType.put(681, HiveOperation.ALTERTABLE_ADDCONSTRAINT);
        commandType.put(929, HiveOperation.SHOWDATABASES);
        commandType.put(935, HiveOperation.SHOWTABLES);
        commandType.put(927, HiveOperation.SHOWCOLUMNS);
        commandType.put(944, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(945, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(937, HiveOperation.SHOW_CREATEDATABASE);
        commandType.put(938, HiveOperation.SHOW_CREATETABLE);
        commandType.put(931, HiveOperation.SHOWFUNCTIONS);
        commandType.put(932, HiveOperation.SHOWINDEXES);
        commandType.put(934, HiveOperation.SHOWPARTITIONS);
        commandType.put(933, HiveOperation.SHOWLOCKS);
        commandType.put(930, HiveOperation.SHOWLOCKS);
        commandType.put(928, HiveOperation.SHOWCONF);
        commandType.put(730, HiveOperation.CREATEFUNCTION);
        commandType.put(761, HiveOperation.DROPFUNCTION);
        commandType.put(900, HiveOperation.RELOADFUNCTION);
        commandType.put(733, HiveOperation.CREATEMACRO);
        commandType.put(763, HiveOperation.DROPMACRO);
        commandType.put(736, HiveOperation.CREATEVIEW);
        commandType.put(766, HiveOperation.DROPVIEW);
        commandType.put(731, HiveOperation.CREATEINDEX);
        commandType.put(762, HiveOperation.DROPINDEX);
        commandType.put(678, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(677, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(713, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(712, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(710, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(711, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(714, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(709, HiveOperation.ALTERVIEW_AS);
        commandType.put(896, HiveOperation.QUERY);
        commandType.put(834, HiveOperation.LOCKTABLE);
        commandType.put(1016, HiveOperation.UNLOCKTABLE);
        commandType.put(833, HiveOperation.LOCKDB);
        commandType.put(1015, HiveOperation.UNLOCKDB);
        commandType.put(734, HiveOperation.CREATEROLE);
        commandType.put(764, HiveOperation.DROPROLE);
        commandType.put(784, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(910, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(939, HiveOperation.SHOW_GRANT);
        commandType.put(786, HiveOperation.GRANT_ROLE);
        commandType.put(911, HiveOperation.REVOKE_ROLE);
        commandType.put(940, HiveOperation.SHOW_ROLES);
        commandType.put(943, HiveOperation.SHOW_ROLES);
        commandType.put(942, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(941, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(676, HiveOperation.ALTERDATABASE);
        commandType.put(675, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(752, HiveOperation.DESCDATABASE);
        commandType.put(703, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(715, HiveOperation.ANALYZE_TABLE);
        commandType.put(721, HiveOperation.CACHE_METADATA);
        commandType.put(695, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(936, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(946, HiveOperation.SHOW_TRANSACTIONS);
        commandType.put(671, HiveOperation.ABORT_TRANSACTIONS);
        commandType.put(952, HiveOperation.START_TRANSACTION);
        commandType.put(728, HiveOperation.COMMIT);
        commandType.put(914, HiveOperation.ROLLBACK);
        commandType.put(925, HiveOperation.SET_AUTOCOMMIT);
        commandType.put(903, HiveOperation.EXPORT);
        commandType.put(904, HiveOperation.IMPORT);
        commandType.put(905, HiveOperation.SHOW_TBLPROPERTIES);
        tablePartitionCommandType.put(692, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(693, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(694, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(702, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(701, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(699, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(687, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(704, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(684, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(686, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(707, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
        tablePartitionCommandType.put(708, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

