/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveReduceExpressionsRule
extends ReduceExpressionsRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveReduceExpressionsRule.class);
    public static final ReduceExpressionsRule FILTER_INSTANCE = new FilterReduceExpressionsRule(HiveFilter.class, HiveRelFactories.HIVE_BUILDER);
    public static final ReduceExpressionsRule PROJECT_INSTANCE = new ProjectReduceExpressionsRule(HiveProject.class, HiveRelFactories.HIVE_BUILDER);
    public static final ReduceExpressionsRule JOIN_INSTANCE = new JoinReduceExpressionsRule(HiveJoin.class, HiveRelFactories.HIVE_BUILDER);

    protected HiveReduceExpressionsRule(Class<? extends RelNode> clazz, RelBuilderFactory relBuilderFactory, String desc) {
        super(clazz, relBuilderFactory, desc);
    }

    public static class JoinReduceExpressionsRule
    extends HiveReduceExpressionsRule {
        public JoinReduceExpressionsRule(Class<? extends HiveJoin> joinClass, RelBuilderFactory relBuilderFactory) {
            super(joinClass, relBuilderFactory, "HiveReduceExpressionsRule(HiveJoin)");
        }

        public void onMatch(RelOptRuleCall call) {
            RelOptPredicateList rightPredicates;
            HiveJoin join = (HiveJoin)call.rel(0);
            ArrayList<RexNode> expList = Lists.newArrayList(join.getCondition());
            int fieldCount = join.getLeft().getRowType().getFieldCount();
            RelMetadataQuery mq = RelMetadataQuery.instance();
            RelOptPredicateList leftPredicates = mq.getPulledUpPredicates(join.getLeft());
            RelOptPredicateList predicates = leftPredicates.union((rightPredicates = mq.getPulledUpPredicates(join.getRight())).shift(fieldCount));
            if (!JoinReduceExpressionsRule.reduceExpressions((RelNode)join, expList, (RelOptPredicateList)predicates, (boolean)true)) {
                return;
            }
            call.transformTo((RelNode)join.copy(join.getTraitSet(), (RexNode)expList.get(0), join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone()));
            call.getPlanner().setImportance((RelNode)join, 0.0);
        }
    }

    public static class ProjectReduceExpressionsRule
    extends HiveReduceExpressionsRule {
        public ProjectReduceExpressionsRule(Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory) {
            super(projectClass, relBuilderFactory, "HiveReduceExpressionsRule(Project)");
        }

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            RelOptPredicateList predicates = RelMetadataQuery.instance().getPulledUpPredicates(project.getInput());
            ArrayList expList = Lists.newArrayList(project.getProjects());
            if (ProjectReduceExpressionsRule.reduceExpressions((RelNode)project, expList, (RelOptPredicateList)predicates)) {
                RelNode newProject = call.builder().push(project.getInput()).project(expList, (Iterable)project.getRowType().getFieldNames()).build();
                call.transformTo(newProject);
                call.getPlanner().setImportance((RelNode)project, 0.0);
            }
        }
    }

    public static class FilterReduceExpressionsRule
    extends ReduceExpressionsRule {
        public FilterReduceExpressionsRule(Class<? extends Filter> filterClass, RelBuilderFactory relBuilderFactory) {
            super(filterClass, relBuilderFactory, "ReduceExpressionsRule(Filter)");
        }

        public void onMatch(RelOptRuleCall call) {
            boolean reduced;
            RexNode newConditionExp;
            RelMetadataQuery mq;
            RelOptPredicateList predicates;
            ArrayList<RexNode> expList;
            Filter filter = (Filter)call.rel(0);
            if (FilterReduceExpressionsRule.reduceExpressions((RelNode)filter, expList = Lists.newArrayList(filter.getCondition()), (RelOptPredicateList)(predicates = (mq = RelMetadataQuery.instance()).getPulledUpPredicates(filter.getInput())), (boolean)true)) {
                assert (expList.size() == 1);
                newConditionExp = (RexNode)expList.get(0);
                reduced = true;
            } else {
                newConditionExp = filter.getCondition();
                reduced = false;
            }
            if (newConditionExp.isAlwaysTrue()) {
                call.transformTo(filter.getInput());
            } else if (reduced) {
                if (RexUtil.isNullabilityCast((RelDataTypeFactory)filter.getCluster().getTypeFactory(), (RexNode)newConditionExp)) {
                    newConditionExp = (RexNode)((RexCall)newConditionExp).getOperands().get(0);
                }
                if (newConditionExp.getType().getSqlTypeName() == SqlTypeName.NULL) {
                    newConditionExp = call.builder().cast(newConditionExp, SqlTypeName.BOOLEAN);
                }
                call.transformTo(call.builder().push(filter.getInput()).filter(new RexNode[]{newConditionExp}).build());
            } else {
                if (newConditionExp instanceof RexCall) {
                    boolean reverse;
                    RexCall rexCall = (RexCall)newConditionExp;
                    boolean bl = reverse = rexCall.getKind() == SqlKind.NOT;
                    if (reverse) {
                        if (!(rexCall.getOperands().get(0) instanceof RexCall)) {
                            return;
                        }
                        rexCall = (RexCall)rexCall.getOperands().get(0);
                    }
                    this.reduceNotNullableFilter(call, filter, rexCall, reverse);
                }
                return;
            }
            call.getPlanner().setImportance((RelNode)filter, 0.0);
        }

        protected RelNode createEmptyRelOrEquivalent(RelOptRuleCall call, Filter input) {
            return call.builder().push((RelNode)input).empty().build();
        }

        private void reduceNotNullableFilter(RelOptRuleCall call, Filter filter, RexCall rexCall, boolean reverse) {
            RexInputRef inputRef;
            RexNode operand;
            boolean alwaysTrue;
            switch (rexCall.getKind()) {
                case IS_NULL: 
                case IS_UNKNOWN: {
                    alwaysTrue = false;
                    break;
                }
                case IS_NOT_NULL: {
                    alwaysTrue = true;
                    break;
                }
                default: {
                    return;
                }
            }
            if (reverse) {
                boolean bl = alwaysTrue = !alwaysTrue;
            }
            if ((operand = (RexNode)rexCall.getOperands().get(0)) instanceof RexInputRef && !(inputRef = (RexInputRef)operand).getType().isNullable()) {
                if (alwaysTrue) {
                    call.transformTo(filter.getInput());
                } else {
                    call.transformTo(this.createEmptyRelOrEquivalent(call, filter));
                }
            }
        }
    }
}

