/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelShuttle;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public class HiveFilter
extends Filter
implements HiveRelNode {
    public HiveFilter(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster), child, condition);
    }

    public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        assert (traitSet.containsIfApplicable((RelTrait)HiveRelNode.CONVENTION));
        return new HiveFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return mq.getNonCumulativeCost((RelNode)this);
    }

    private void findCorrelatedVar(RexNode node, Set<CorrelationId> allVars) {
        if (node instanceof RexCall) {
            RexCall nd = (RexCall)node;
            for (RexNode rn : nd.getOperands()) {
                if (rn instanceof RexFieldAccess) {
                    RexNode ref = ((RexFieldAccess)rn).getReferenceExpr();
                    if (!(ref instanceof RexCorrelVariable)) continue;
                    allVars.add(((RexCorrelVariable)ref).id);
                    continue;
                }
                this.findCorrelatedVar(rn, allVars);
            }
        }
    }

    private void traverseFilter(RexNode node, Set<CorrelationId> allVars) {
        if (node instanceof RexSubQuery) {
            RelNode input;
            for (input = ((RexSubQuery)node).rel.getInput(0); input != null && !(input instanceof HiveFilter) && input.getInputs().size() >= 1; input = input.getInput(0)) {
                if (input.getInputs().size() <= 1) continue;
                return;
            }
            if (input != null && input instanceof HiveFilter) {
                this.findCorrelatedVar(((HiveFilter)input).getCondition(), allVars);
            }
            return;
        }
        if (node instanceof RexCall) {
            int numOperands = ((RexCall)node).getOperands().size();
            for (int i = 0; i < numOperands; ++i) {
                RexNode op = (RexNode)((RexCall)node).getOperands().get(i);
                this.traverseFilter(op, allVars);
            }
        }
    }

    public Set<CorrelationId> getVariablesSet() {
        HashSet<CorrelationId> allCorrVars = new HashSet<CorrelationId>();
        this.traverseFilter(this.condition, allCorrVars);
        return allCorrVars;
    }

    public Set<CorrelationId> getVariablesSet(RexSubQuery e) {
        HashSet<CorrelationId> allCorrVars = new HashSet<CorrelationId>();
        this.traverseFilter((RexNode)e, allCorrVars);
        return allCorrVars;
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof HiveRelShuttle) {
            return ((HiveRelShuttle)shuttle).visit(this);
        }
        return shuttle.visit((RelNode)this);
    }
}

