/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedDynPartitionOptimizer
extends Transform {
    private static final String BUCKET_NUMBER_COL_NAME = "_bucket_number";

    @Override
    public ParseContext transform(ParseContext pCtx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        String FS = FileSinkOperator.getOperatorName() + "%";
        opRules.put(new RuleRegExp("Sorted Dynamic Partition", FS), this.getSortDynPartProc(pCtx));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pCtx;
    }

    private NodeProcessor getSortDynPartProc(ParseContext pCtx) {
        return new SortedDynamicPartitionProc(pCtx);
    }

    class SortedDynamicPartitionProc
    implements NodeProcessor {
        private final Logger LOG = LoggerFactory.getLogger(SortedDynPartitionOptimizer.class);
        protected ParseContext parseCtx;

        public SortedDynamicPartitionProc(ParseContext pCtx) {
            this.parseCtx = pCtx;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ArrayList<ExprNodeDesc> bucketColumns;
            FileSinkOperator fsOp = (FileSinkOperator)nd;
            this.LOG.info("Sorted dynamic partitioning optimization kicked in..");
            if (((FileSinkDesc)fsOp.getConf()).getDynPartCtx() == null) {
                this.LOG.debug("Bailing out of sort dynamic partition optimization as dynamic partitioning context is null");
                return null;
            }
            ListBucketingCtx lbCtx = ((FileSinkDesc)fsOp.getConf()).getLbCtx();
            if (lbCtx != null && !lbCtx.getSkewedColNames().isEmpty() && !lbCtx.getSkewedColValues().isEmpty()) {
                this.LOG.debug("Bailing out of sort dynamic partition optimization as list bucketing is enabled");
                return null;
            }
            Table destTable = ((FileSinkDesc)fsOp.getConf()).getTable();
            if (destTable == null) {
                this.LOG.debug("Bailing out of sort dynamic partition optimization as destination table is null");
                return null;
            }
            Operator<OperatorDesc> fsParent = fsOp.getParentOperators().get(0);
            if (this.allStaticPartitions(fsParent, ((FileSinkDesc)fsOp.getConf()).getDynPartCtx())) {
                this.LOG.debug("Bailing out of sorted dynamic partition optimizer as all dynamic partition columns got constant folded (static partitioning)");
                return null;
            }
            if (!this.removeRSInsertedByEnforceBucketing(fsOp)) {
                this.LOG.debug("Bailing out of sort dynamic partition optimization as some partition columns got constant folded.");
                return null;
            }
            fsParent = fsOp.getParentOperators().get(0);
            fsParent.getChildOperators().clear();
            DynamicPartitionCtx dpCtx = ((FileSinkDesc)fsOp.getConf()).getDynPartCtx();
            int numBuckets = destTable.getNumBuckets();
            dpCtx.setNumBuckets(numBuckets);
            List<Integer> bucketPositions = this.getBucketPositions(destTable.getBucketCols(), destTable.getCols());
            List<Integer> sortPositions = null;
            List<Integer> sortOrder = null;
            if (((FileSinkDesc)fsOp.getConf()).getWriteType() == AcidUtils.Operation.UPDATE || ((FileSinkDesc)fsOp.getConf()).getWriteType() == AcidUtils.Operation.DELETE) {
                sortPositions = Arrays.asList(0);
                sortOrder = Arrays.asList(1);
                bucketColumns = new ArrayList();
            } else {
                if (!destTable.getSortCols().isEmpty()) {
                    sortPositions = this.getSortPositions(destTable.getSortCols(), destTable.getCols());
                    sortOrder = this.getSortOrders(destTable.getSortCols(), destTable.getCols());
                } else {
                    sortPositions = Lists.newArrayList();
                    sortOrder = Lists.newArrayList();
                    this.inferSortPositions(fsParent, sortPositions, sortOrder);
                }
                ArrayList<ColumnInfo> colInfos = fsParent.getSchema().getSignature();
                bucketColumns = this.getPositionsToExprNodes(bucketPositions, colInfos);
            }
            ArrayList<Integer> sortNullOrder = new ArrayList<Integer>();
            for (int order : sortOrder) {
                sortNullOrder.add(order == 1 ? 0 : 1);
            }
            this.LOG.debug("Got sort order");
            for (int i : sortPositions) {
                this.LOG.debug("sort position " + i);
            }
            for (int i : sortOrder) {
                this.LOG.debug("sort order " + i);
            }
            for (int i : sortNullOrder) {
                this.LOG.debug("sort null order " + i);
            }
            List<Integer> partitionPositions = this.getPartitionPositions(dpCtx, fsParent.getSchema());
            ((FileSinkDesc)fsOp.getConf()).setMultiFileSpray(false);
            ((FileSinkDesc)fsOp.getConf()).setNumFiles(1);
            ((FileSinkDesc)fsOp.getConf()).setTotalFiles(1);
            ArrayList<ColumnInfo> parentCols = Lists.newArrayList(fsParent.getSchema().getSignature());
            ArrayList<ExprNodeDesc> allRSCols = Lists.newArrayList();
            for (ColumnInfo ci : parentCols) {
                allRSCols.add(new ExprNodeColumnDesc(ci));
            }
            ReduceSinkOperator rsOp = this.getReduceSinkOp(partitionPositions, sortPositions, sortOrder, sortNullOrder, allRSCols, bucketColumns, numBuckets, fsParent, ((FileSinkDesc)fsOp.getConf()).getWriteType());
            ArrayList<ExprNodeDesc> descs = new ArrayList<ExprNodeDesc>(allRSCols.size());
            ArrayList<String> colNames = new ArrayList<String>();
            for (int i = 0; i < allRSCols.size(); ++i) {
                ExprNodeDesc col = allRSCols.get(i);
                String colName = col.getExprString();
                colNames.add(colName);
                if (partitionPositions.contains(i) || sortPositions.contains(i)) {
                    descs.add(new ExprNodeColumnDesc(col.getTypeInfo(), Utilities.ReduceField.KEY.toString() + "." + colName, null, false));
                    continue;
                }
                descs.add(new ExprNodeColumnDesc(col.getTypeInfo(), Utilities.ReduceField.VALUE.toString() + "." + colName, null, false));
            }
            RowSchema selRS = new RowSchema(fsParent.getSchema());
            if (!bucketColumns.isEmpty() || ((FileSinkDesc)fsOp.getConf()).getWriteType() == AcidUtils.Operation.DELETE || ((FileSinkDesc)fsOp.getConf()).getWriteType() == AcidUtils.Operation.UPDATE) {
                descs.add(new ExprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, Utilities.ReduceField.KEY.toString() + ".'" + SortedDynPartitionOptimizer.BUCKET_NUMBER_COL_NAME + "'", null, false));
                colNames.add("'_bucket_number'");
                ColumnInfo ci = new ColumnInfo(SortedDynPartitionOptimizer.BUCKET_NUMBER_COL_NAME, TypeInfoFactory.stringTypeInfo, selRS.getSignature().get(0).getTabAlias(), true, true);
                selRS.getSignature().add(ci);
                fsParent.getSchema().getSignature().add(ci);
            }
            SelectDesc selConf = new SelectDesc(descs, colNames);
            SelectOperator selOp = (SelectOperator)OperatorFactory.getAndMakeChild(selConf, selRS, (Operator)rsOp, new Operator[0]);
            fsOp.getParentOperators().clear();
            fsOp.getParentOperators().add(selOp);
            selOp.getChildOperators().add(fsOp);
            ((FileSinkDesc)fsOp.getConf()).setDpSortState(FileSinkDesc.DPSortState.PARTITION_SORTED);
            if (bucketColumns.size() > 0 || ((FileSinkDesc)fsOp.getConf()).getWriteType() == AcidUtils.Operation.DELETE || ((FileSinkDesc)fsOp.getConf()).getWriteType() == AcidUtils.Operation.UPDATE) {
                ((FileSinkDesc)fsOp.getConf()).setDpSortState(FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED);
            }
            ((FileSinkDesc)fsOp.getConf()).setPartitionCols(((ReduceSinkDesc)rsOp.getConf()).getPartitionCols());
            this.LOG.info("Inserted " + rsOp.getOperatorId() + " and " + selOp.getOperatorId() + " as parent of " + fsOp.getOperatorId() + " and child of " + fsParent.getOperatorId());
            this.parseCtx.setReduceSinkAddedBySortedDynPartition(true);
            return null;
        }

        private boolean allStaticPartitions(Operator<? extends OperatorDesc> op, DynamicPartitionCtx dynPartCtx) {
            int numDpCols = dynPartCtx.getNumDPCols();
            int numCols = op.getSchema().getColumnNames().size();
            List<String> dpCols = op.getSchema().getColumnNames().subList(numCols - numDpCols, numCols);
            if (op.getColumnExprMap() == null) {
                for (Operator operator : op.getParentOperators()) {
                    if (operator.getColumnExprMap() == null) continue;
                    op = operator;
                    break;
                }
            }
            if (op.getColumnExprMap() != null) {
                for (String string : dpCols) {
                    ExprNodeDesc end = ExprNodeDescUtils.findConstantExprOrigin(string, op);
                    if (end instanceof ExprNodeConstantDesc) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        private boolean removeRSInsertedByEnforceBucketing(FileSinkOperator fsOp) {
            Set<ReduceSinkOperator> reduceSinks = OperatorUtils.findOperatorsUpstream(fsOp, ReduceSinkOperator.class);
            Operator rsToRemove = null;
            List<ReduceSinkOperator> rsOps = this.parseCtx.getReduceSinkOperatorsAddedByEnforceBucketingSorting();
            boolean found = false;
            for (ReduceSinkOperator reduceSink : reduceSinks) {
                for (ReduceSinkOperator rsOp : rsOps) {
                    if (!reduceSink.equals(rsOp)) continue;
                    rsToRemove = reduceSink;
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (found) {
                Operator<OperatorDesc> rsParent = rsToRemove.getParentOperators().get(0);
                Operator<OperatorDesc> rsChild = rsToRemove.getChildOperators().get(0);
                Operator<OperatorDesc> rsGrandChild = rsChild.getChildOperators().get(0);
                if (rsChild instanceof SelectOperator) {
                    if (rsParent.getSchema().getSignature().size() != rsChild.getSchema().getSignature().size()) {
                        return false;
                    }
                    rsParent.getChildOperators().clear();
                    rsParent.getChildOperators().add(rsGrandChild);
                    rsGrandChild.getParentOperators().clear();
                    rsGrandChild.getParentOperators().add(rsParent);
                    this.LOG.info("Removed " + rsToRemove.getOperatorId() + " and " + rsChild.getOperatorId() + " as it was introduced by enforce bucketing/sorting.");
                }
            }
            return true;
        }

        private List<Integer> getPartitionPositions(DynamicPartitionCtx dpCtx, RowSchema schema) {
            int numPartCols = dpCtx.getNumDPCols();
            int numCols = schema.getSignature().size();
            ArrayList<Integer> partPos = Lists.newArrayList();
            for (int i = numCols - numPartCols; i < numCols; ++i) {
                partPos.add(i);
            }
            return partPos;
        }

        private List<Integer> getBucketPositions(List<String> tabBucketCols, List<FieldSchema> tabCols) {
            ArrayList<Integer> posns = new ArrayList<Integer>();
            block0: for (String bucketCol : tabBucketCols) {
                int pos = 0;
                for (FieldSchema tabCol : tabCols) {
                    if (bucketCol.equals(tabCol.getName())) {
                        posns.add(pos);
                        continue block0;
                    }
                    ++pos;
                }
            }
            return posns;
        }

        private void inferSortPositions(Operator<? extends OperatorDesc> fsParent, List<Integer> sortPositions, List<Integer> sortOrder) throws SemanticException {
            SelectOperator pSel;
            if (!(fsParent instanceof SelectOperator)) {
                return;
            }
            Operator parent = pSel = (SelectOperator)fsParent;
            while (!(parent instanceof ReduceSinkOperator)) {
                if (parent.getNumParent() != 1 || !(parent instanceof SelectOperator)) {
                    return;
                }
                parent = parent.getParentOperators().get(0);
            }
            ArrayList<ExprNodeDesc> selColsInPRS = ExprNodeDescUtils.backtrack(((SelectDesc)pSel.getConf()).getColList(), pSel, parent);
            ReduceSinkOperator pRS = (ReduceSinkOperator)parent;
            for (int i = 0; i < ((ReduceSinkDesc)pRS.getConf()).getKeyCols().size(); ++i) {
                ExprNodeDesc col = ((ReduceSinkDesc)pRS.getConf()).getKeyCols().get(i);
                int pos = selColsInPRS.indexOf(col);
                if (pos == -1) {
                    sortPositions.clear();
                    sortOrder.clear();
                    return;
                }
                sortPositions.add(pos);
                sortOrder.add(((ReduceSinkDesc)pRS.getConf()).getOrder().charAt(i) == '+' ? 1 : 0);
            }
        }

        public ReduceSinkOperator getReduceSinkOp(List<Integer> partitionPositions, List<Integer> sortPositions, List<Integer> sortOrder, List<Integer> sortNullOrder, ArrayList<ExprNodeDesc> allCols, ArrayList<ExprNodeDesc> bucketColumns, int numBuckets, Operator<? extends OperatorDesc> parent, AcidUtils.Operation writeType) throws SemanticException {
            LinkedHashSet<Integer> keyColsPosInVal = Sets.newLinkedHashSet();
            ArrayList<ExprNodeDesc> keyCols = Lists.newArrayList();
            ArrayList<Integer> newSortOrder = Lists.newArrayList();
            ArrayList<Integer> newSortNullOrder = Lists.newArrayList();
            int numPartAndBuck = partitionPositions.size();
            keyColsPosInVal.addAll(partitionPositions);
            if (!bucketColumns.isEmpty() || writeType == AcidUtils.Operation.DELETE || writeType == AcidUtils.Operation.UPDATE) {
                keyColsPosInVal.add(-1);
                ++numPartAndBuck;
            }
            keyColsPosInVal.addAll(sortPositions);
            Integer order = 1;
            if (sortOrder != null && !sortOrder.isEmpty() && sortOrder.get(0) == 0) {
                order = 0;
            }
            for (int i = 0; i < numPartAndBuck; ++i) {
                newSortOrder.add(order);
            }
            newSortOrder.addAll(sortOrder);
            String orderStr = "";
            for (Integer i : newSortOrder) {
                if (i == 1) {
                    orderStr = orderStr + "+";
                    continue;
                }
                orderStr = orderStr + "-";
            }
            Integer nullOrder = order == 1 ? 0 : 1;
            if (sortNullOrder != null && !sortNullOrder.isEmpty()) {
                nullOrder = sortNullOrder.get(0) == 0 ? Integer.valueOf(0) : Integer.valueOf(1);
            }
            for (int i = 0; i < numPartAndBuck; ++i) {
                newSortNullOrder.add(nullOrder);
            }
            newSortNullOrder.addAll(sortNullOrder);
            String nullOrderStr = "";
            for (Integer i : newSortNullOrder) {
                if (i == 0) {
                    nullOrderStr = nullOrderStr + "a";
                    continue;
                }
                nullOrderStr = nullOrderStr + "z";
            }
            HashMap<String, ExprNodeDesc> colExprMap = Maps.newHashMap();
            ArrayList<ExprNodeDesc> partCols = Lists.newArrayList();
            for (Integer idx : keyColsPosInVal) {
                if (idx < 0) {
                    ExprNodeConstantDesc bucketNumCol = new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, SortedDynPartitionOptimizer.BUCKET_NUMBER_COL_NAME);
                    keyCols.add(bucketNumCol);
                    colExprMap.put((Object)((Object)Utilities.ReduceField.KEY) + ".'" + SortedDynPartitionOptimizer.BUCKET_NUMBER_COL_NAME + "'", bucketNumCol);
                    continue;
                }
                keyCols.add(allCols.get(idx).clone());
            }
            ArrayList<ExprNodeDesc> valCols = Lists.newArrayList();
            for (int i = 0; i < allCols.size(); ++i) {
                if (keyColsPosInVal.contains(i)) continue;
                valCols.add(allCols.get(i).clone());
            }
            for (Integer idx : partitionPositions) {
                partCols.add(allCols.get(idx).clone());
            }
            ReduceSinkOperator parentRSOp = OperatorUtils.findSingleOperatorUpstream(parent, ReduceSinkOperator.class);
            if (parentRSOp != null && this.parseCtx.getQueryProperties().hasOuterOrderBy()) {
                String parentRSOpOrder = ((ReduceSinkDesc)parentRSOp.getConf()).getOrder();
                String parentRSOpNullOrder = ((ReduceSinkDesc)parentRSOp.getConf()).getNullOrder();
                if (parentRSOpOrder != null && !parentRSOpOrder.isEmpty() && sortPositions.isEmpty()) {
                    keyCols.addAll(((ReduceSinkDesc)parentRSOp.getConf()).getKeyCols());
                    orderStr = orderStr + parentRSOpOrder;
                    nullOrderStr = nullOrderStr + parentRSOpNullOrder;
                }
            }
            HashMap<String, String> nameMapping = new HashMap<String, String>();
            ArrayList<String> keyColNames = Lists.newArrayList();
            for (ExprNodeDesc exprNodeDesc : keyCols) {
                String keyColName = exprNodeDesc.getExprString();
                keyColNames.add(keyColName);
                colExprMap.put((Object)((Object)Utilities.ReduceField.KEY) + "." + keyColName, exprNodeDesc);
                nameMapping.put(keyColName, (Object)((Object)Utilities.ReduceField.KEY) + "." + keyColName);
            }
            ArrayList<String> valColNames = Lists.newArrayList();
            for (ExprNodeDesc valCol : valCols) {
                String colName = valCol.getExprString();
                valColNames.add(colName);
                colExprMap.put((Object)((Object)Utilities.ReduceField.VALUE) + "." + colName, valCol);
                nameMapping.put(colName, (Object)((Object)Utilities.ReduceField.VALUE) + "." + colName);
            }
            List<FieldSchema> list = PlanUtils.getFieldSchemasFromColumnList(keyCols, keyColNames, 0, "");
            TableDesc keyTable = PlanUtils.getReduceKeyTableDesc(list, orderStr, nullOrderStr);
            List<FieldSchema> valFields = PlanUtils.getFieldSchemasFromColumnList(valCols, valColNames, 0, "");
            TableDesc valueTable = PlanUtils.getReduceValueTableDesc(valFields);
            ArrayList<List<Integer>> distinctColumnIndices = Lists.newArrayList();
            ReduceSinkDesc rsConf = new ReduceSinkDesc(keyCols, keyCols.size(), valCols, keyColNames, distinctColumnIndices, valColNames, -1, partCols, -1, keyTable, valueTable, writeType);
            rsConf.setBucketCols(bucketColumns);
            rsConf.setNumBuckets(numBuckets);
            ArrayList<ColumnInfo> signature = new ArrayList<ColumnInfo>();
            for (int index = 0; index < parent.getSchema().getSignature().size(); ++index) {
                ColumnInfo colInfo = new ColumnInfo(parent.getSchema().getSignature().get(index));
                colInfo.setInternalName((String)nameMapping.get(colInfo.getInternalName()));
                signature.add(colInfo);
            }
            ReduceSinkOperator op = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(rsConf, new RowSchema(signature), parent, new Operator[0]);
            op.setColumnExprMap(colExprMap);
            return op;
        }

        private List<Integer> getSortPositions(List<Order> tabSortCols, List<FieldSchema> tabCols) {
            ArrayList<Integer> sortPositions = Lists.newArrayList();
            block0: for (Order sortCol : tabSortCols) {
                int pos = 0;
                for (FieldSchema tabCol : tabCols) {
                    if (sortCol.getCol().equals(tabCol.getName())) {
                        sortPositions.add(pos);
                        continue block0;
                    }
                    ++pos;
                }
            }
            return sortPositions;
        }

        private List<Integer> getSortOrders(List<Order> tabSortCols, List<FieldSchema> tabCols) {
            ArrayList<Integer> sortOrders = Lists.newArrayList();
            block0: for (Order sortCol : tabSortCols) {
                for (FieldSchema tabCol : tabCols) {
                    if (!sortCol.getCol().equals(tabCol.getName())) continue;
                    sortOrders.add(sortCol.getOrder());
                    continue block0;
                }
            }
            return sortOrders;
        }

        private ArrayList<ExprNodeDesc> getPositionsToExprNodes(List<Integer> pos, List<ColumnInfo> colInfos) {
            ArrayList<ExprNodeDesc> cols = Lists.newArrayList();
            for (Integer idx : pos) {
                ColumnInfo ci = colInfos.get(idx);
                ExprNodeColumnDesc encd = new ExprNodeColumnDesc(ci);
                cols.add(encd);
            }
            return cols;
        }
    }
}

