/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManagerCtx;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManagerImpl;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DummyTxnManager
extends HiveTxnManagerImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)DummyTxnManager.class.getName());
    private HiveLockManager lockMgr;

    DummyTxnManager() {
    }

    @Override
    public long openTxn(Context ctx, String user) throws LockException {
        return 0L;
    }

    @Override
    public boolean isTxnOpen() {
        return false;
    }

    @Override
    public long getCurrentTxnId() {
        return 0L;
    }

    @Override
    public int getWriteIdAndIncrement() {
        return 0;
    }

    @Override
    public HiveLockManager getLockManager() throws LockException {
        if (this.lockMgr == null) {
            boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
            if (supportConcurrency) {
                String lockMgrName = this.conf.getVar(HiveConf.ConfVars.HIVE_LOCK_MANAGER);
                if (lockMgrName == null || lockMgrName.isEmpty()) {
                    throw new LockException(ErrorMsg.LOCKMGR_NOT_SPECIFIED.getMsg());
                }
                try {
                    LOG.info("Creating lock manager of type " + lockMgrName);
                    this.lockMgr = (HiveLockManager)ReflectionUtils.newInstance((Class)this.conf.getClassByName(lockMgrName), (Configuration)this.conf);
                    this.lockMgr.setContext(new HiveLockManagerCtx(this.conf));
                }
                catch (Exception e) {
                    if (this.lockMgr != null) {
                        try {
                            this.lockMgr.close();
                        }
                        catch (LockException lockException) {
                            // empty catch block
                        }
                        this.lockMgr = null;
                    }
                    throw new LockException(ErrorMsg.LOCKMGR_NOT_INITIALIZED.getMsg() + e.getMessage());
                }
            }
            LOG.info("Concurrency mode is disabled, not creating a lock manager");
            return null;
        }
        this.lockMgr.refresh();
        return this.lockMgr;
    }

    @Override
    public void acquireLocks(QueryPlan plan, Context ctx, String username) throws LockException {
        this.getLockManager();
        if (this.lockMgr == null) {
            return;
        }
        ArrayList<HiveLockObj> lockObjects = new ArrayList<HiveLockObj>();
        for (ReadEntity input : plan.getInputs()) {
            if (!input.needsLock()) continue;
            LOG.debug("Adding " + input.getName() + " to list of lock inputs");
            if (input.getType() == Entity.Type.DATABASE) {
                lockObjects.addAll(this.getLockObjects(plan, input.getDatabase(), null, null, HiveLockMode.SHARED));
                continue;
            }
            if (input.getType() == Entity.Type.TABLE) {
                lockObjects.addAll(this.getLockObjects(plan, null, input.getTable(), null, HiveLockMode.SHARED));
                continue;
            }
            lockObjects.addAll(this.getLockObjects(plan, null, null, input.getPartition(), HiveLockMode.SHARED));
        }
        for (WriteEntity output : plan.getOutputs()) {
            HiveLockMode lockMode = this.getWriteEntityLockMode(output);
            if (lockMode == null) continue;
            LOG.debug("Adding " + output.getName() + " to list of lock outputs");
            List<HiveLockObj> lockObj = null;
            if (output.getType() == Entity.Type.DATABASE) {
                lockObjects.addAll(this.getLockObjects(plan, output.getDatabase(), null, null, lockMode));
            } else if (output.getTyp() == Entity.Type.TABLE) {
                lockObj = this.getLockObjects(plan, null, output.getTable(), null, lockMode);
            } else if (output.getTyp() == Entity.Type.PARTITION) {
                lockObj = this.getLockObjects(plan, null, null, output.getPartition(), lockMode);
            } else if (output.getTyp() == Entity.Type.DUMMYPARTITION) {
                lockObj = this.getLockObjects(plan, null, null, output.getPartition(), HiveLockMode.SHARED);
            }
            if (lockObj == null) continue;
            lockObjects.addAll(lockObj);
            ctx.getOutputLockObjects().put(output, lockObj);
        }
        if (lockObjects.isEmpty() && !ctx.isNeedLockMgr()) {
            return;
        }
        DummyTxnManager.dedupLockObjects(lockObjects);
        List<HiveLock> hiveLocks = this.lockMgr.lock(lockObjects, false);
        if (hiveLocks == null) {
            throw new LockException(ErrorMsg.LOCK_CANNOT_BE_ACQUIRED.getMsg());
        }
        ctx.setHiveLocks(hiveLocks);
    }

    @Override
    public void releaseLocks(List<HiveLock> hiveLocks) throws LockException {
        if (this.lockMgr != null) {
            this.lockMgr.releaseLocks(hiveLocks);
        }
    }

    @Override
    public void commitTxn() throws LockException {
    }

    @Override
    public void rollbackTxn() throws LockException {
    }

    @Override
    public void heartbeat() throws LockException {
    }

    @Override
    public ValidTxnList getValidTxns() throws LockException {
        return new ValidReadTxnList();
    }

    @Override
    public String getTxnManagerName() {
        return DummyTxnManager.class.getName();
    }

    @Override
    public boolean supportsExplicitLock() {
        return true;
    }

    @Override
    public boolean useNewShowLocksFormat() {
        return false;
    }

    @Override
    public boolean supportsAcid() {
        return false;
    }

    @Override
    protected void destruct() {
        if (this.lockMgr != null) {
            try {
                this.lockMgr.close();
            }
            catch (LockException e) {
                LOG.warn("Got exception when closing lock manager " + e.getMessage());
            }
        }
    }

    static void dedupLockObjects(List<HiveLockObj> lockObjects) {
        HashMap<String, HiveLockObj> lockMap = new HashMap<String, HiveLockObj>();
        for (HiveLockObj lockObj : lockObjects) {
            String lockName = lockObj.getName();
            HiveLockObj foundLock = (HiveLockObj)lockMap.get(lockName);
            if (foundLock != null && lockObj.getMode() != HiveLockMode.EXCLUSIVE) continue;
            lockMap.put(lockName, lockObj);
        }
        lockObjects.clear();
        for (HiveLockObj lockObj : lockMap.values()) {
            lockObjects.add(lockObj);
        }
    }

    private HiveLockMode getWriteEntityLockMode(WriteEntity we) {
        HiveLockMode lockMode = we.isComplete() ? HiveLockMode.EXCLUSIVE : HiveLockMode.SHARED;
        WriteEntity.WriteType writeType = we.getWriteType();
        if (writeType == null) {
            return lockMode;
        }
        switch (writeType) {
            case DDL_EXCLUSIVE: {
                return HiveLockMode.EXCLUSIVE;
            }
            case DDL_SHARED: {
                return HiveLockMode.SHARED;
            }
            case DDL_NO_LOCK: {
                return null;
            }
        }
        return lockMode;
    }

    private List<HiveLockObj> getLockObjects(QueryPlan plan, Database db, Table t, Partition p, HiveLockMode mode) throws LockException {
        LinkedList<HiveLockObj> locks = new LinkedList<HiveLockObj>();
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(plan.getQueryId(), String.valueOf(System.currentTimeMillis()), "IMPLICIT", plan.getQueryStr());
        if (db != null) {
            locks.add(new HiveLockObj(new HiveLockObject(db.getName(), lockData), mode));
            return locks;
        }
        if (t != null) {
            locks.add(new HiveLockObj(new HiveLockObject(t, lockData), mode));
            mode = HiveLockMode.SHARED;
            locks.add(new HiveLockObj(new HiveLockObject(t.getDbName(), lockData), mode));
            return locks;
        }
        if (p != null) {
            if (!(p instanceof DummyPartition)) {
                locks.add(new HiveLockObj(new HiveLockObject(p, lockData), mode));
            }
            mode = HiveLockMode.SHARED;
            String name = p.getName();
            if (p instanceof DummyPartition) {
                name = p.getName().split("@")[2];
            }
            String partialName = "";
            String[] partns = name.split("/");
            int len = p instanceof DummyPartition ? partns.length : partns.length - 1;
            LinkedHashMap<String, String> partialSpec = new LinkedHashMap<String, String>();
            for (int idx = 0; idx < len; ++idx) {
                String partn = partns[idx];
                partialName = partialName + partn;
                String[] nameValue = partn.split("=");
                assert (nameValue.length == 2);
                partialSpec.put(nameValue[0], nameValue[1]);
                try {
                    locks.add(new HiveLockObj(new HiveLockObject(new DummyPartition(p.getTable(), p.getTable().getDbName() + "/" + MetaStoreUtils.encodeTableName(p.getTable().getTableName()) + "/" + partialName, partialSpec), lockData), mode));
                    partialName = partialName + "/";
                    continue;
                }
                catch (HiveException e) {
                    throw new LockException(e.getMessage());
                }
            }
            locks.add(new HiveLockObj(new HiveLockObject(p.getTable(), lockData), mode));
            locks.add(new HiveLockObj(new HiveLockObject(p.getTable().getDbName(), lockData), mode));
        }
        return locks;
    }
}

