/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.parquet.VectorizedParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetRecordReaderWrapper;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.shaded.parquet.hadoop.ParquetInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapredParquetInputFormat
extends FileInputFormat<NullWritable, ArrayWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(MapredParquetInputFormat.class);
    private final ParquetInputFormat<ArrayWritable> realInput;
    private final transient VectorizedParquetInputFormat vectorizedSelf;

    public MapredParquetInputFormat() {
        this(new ParquetInputFormat<ArrayWritable>(DataWritableReadSupport.class));
    }

    protected MapredParquetInputFormat(ParquetInputFormat<ArrayWritable> inputFormat) {
        this.realInput = inputFormat;
        this.vectorizedSelf = new VectorizedParquetInputFormat(inputFormat);
    }

    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        try {
            if (Utilities.getUseVectorizedInputFileFormat((Configuration)job)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using vectorized record reader");
                }
                return this.vectorizedSelf.getRecordReader(split, job, reporter);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using row-mode record reader");
            }
            return new ParquetRecordReaderWrapper(this.realInput, split, job, reporter);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Cannot create a RecordReaderWrapper", e);
        }
    }
}

