/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class VectorHashKeyWrapper
extends KeyWrapper {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final byte[][] EMPTY_BYTES_ARRAY = new byte[0][];
    private static final HiveDecimalWritable[] EMPTY_DECIMAL_ARRAY = new HiveDecimalWritable[0];
    private static final Timestamp[] EMPTY_TIMESTAMP_ARRAY = new Timestamp[0];
    private static final HiveIntervalDayTime[] EMPTY_INTERVAL_DAY_TIME_ARRAY = new HiveIntervalDayTime[0];
    private long[] longValues;
    private double[] doubleValues;
    private byte[][] byteValues;
    private int[] byteStarts;
    private int[] byteLengths;
    private HiveDecimalWritable[] decimalValues;
    private Timestamp[] timestampValues;
    private HiveIntervalDayTime[] intervalDayTimeValues;
    private boolean[] isNull;
    private int hashcode;

    public VectorHashKeyWrapper(int longValuesCount, int doubleValuesCount, int byteValuesCount, int decimalValuesCount, int timestampValuesCount, int intervalDayTimeValuesCount) {
        int i;
        this.longValues = longValuesCount > 0 ? new long[longValuesCount] : EMPTY_LONG_ARRAY;
        this.doubleValues = doubleValuesCount > 0 ? new double[doubleValuesCount] : EMPTY_DOUBLE_ARRAY;
        this.decimalValues = decimalValuesCount > 0 ? new HiveDecimalWritable[decimalValuesCount] : EMPTY_DECIMAL_ARRAY;
        this.timestampValues = timestampValuesCount > 0 ? new Timestamp[timestampValuesCount] : EMPTY_TIMESTAMP_ARRAY;
        this.intervalDayTimeValues = intervalDayTimeValuesCount > 0 ? new HiveIntervalDayTime[intervalDayTimeValuesCount] : EMPTY_INTERVAL_DAY_TIME_ARRAY;
        for (i = 0; i < decimalValuesCount; ++i) {
            this.decimalValues[i] = new HiveDecimalWritable(HiveDecimal.ZERO);
        }
        if (byteValuesCount > 0) {
            this.byteValues = new byte[byteValuesCount][];
            this.byteStarts = new int[byteValuesCount];
            this.byteLengths = new int[byteValuesCount];
        } else {
            this.byteValues = EMPTY_BYTES_ARRAY;
            this.byteStarts = EMPTY_INT_ARRAY;
            this.byteLengths = EMPTY_INT_ARRAY;
        }
        for (i = 0; i < timestampValuesCount; ++i) {
            this.timestampValues[i] = new Timestamp(0L);
        }
        for (i = 0; i < intervalDayTimeValuesCount; ++i) {
            this.intervalDayTimeValues[i] = new HiveIntervalDayTime();
        }
        this.isNull = new boolean[longValuesCount + doubleValuesCount + byteValuesCount + decimalValuesCount + timestampValuesCount + intervalDayTimeValuesCount];
        this.hashcode = 0;
    }

    private VectorHashKeyWrapper() {
    }

    @Override
    public void getNewKey(Object row, ObjectInspector rowInspector) throws HiveException {
        throw new HiveException("Should not be called");
    }

    @Override
    public void setHashKey() {
        int i;
        this.hashcode = Arrays.hashCode(this.longValues) ^ Arrays.hashCode(this.doubleValues) ^ Arrays.hashCode(this.isNull);
        for (i = 0; i < this.decimalValues.length; ++i) {
            this.hashcode ^= this.decimalValues[i].newFasterHashCode();
        }
        for (i = 0; i < this.timestampValues.length; ++i) {
            this.hashcode ^= this.timestampValues[i].hashCode();
        }
        for (i = 0; i < this.intervalDayTimeValues.length; ++i) {
            this.hashcode ^= this.intervalDayTimeValues[i].hashCode();
        }
        for (i = 0; i < this.byteValues.length; ++i) {
            if (this.isNull[this.longValues.length + this.doubleValues.length + i]) continue;
            byte[] bytes = this.byteValues[i];
            int start = this.byteStarts[i];
            int length = this.byteLengths[i];
            if (length == bytes.length && start == 0) {
                this.hashcode ^= Arrays.hashCode(bytes);
                continue;
            }
            for (int j = start; j < start + length; ++j) {
                this.hashcode ^= 461 * bytes[j];
            }
        }
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object that) {
        if (that instanceof VectorHashKeyWrapper) {
            VectorHashKeyWrapper keyThat = (VectorHashKeyWrapper)that;
            return this.hashcode == keyThat.hashcode && Arrays.equals(this.longValues, keyThat.longValues) && Arrays.equals(this.doubleValues, keyThat.doubleValues) && Arrays.equals(this.decimalValues, keyThat.decimalValues) && Arrays.equals(this.timestampValues, keyThat.timestampValues) && Arrays.equals(this.intervalDayTimeValues, keyThat.intervalDayTimeValues) && Arrays.equals(this.isNull, keyThat.isNull) && this.byteValues.length == keyThat.byteValues.length && (0 == this.byteValues.length || this.bytesEquals(keyThat));
        }
        return false;
    }

    private boolean bytesEquals(VectorHashKeyWrapper keyThat) {
        for (int i = 0; i < this.byteValues.length; ++i) {
            if (this.isNull[this.longValues.length + this.doubleValues.length + i] || StringExpr.equal(this.byteValues[i], this.byteStarts[i], this.byteLengths[i], keyThat.byteValues[i], keyThat.byteStarts[i], keyThat.byteLengths[i])) continue;
            return false;
        }
        return true;
    }

    protected Object clone() {
        VectorHashKeyWrapper clone = new VectorHashKeyWrapper();
        this.duplicateTo(clone);
        return clone;
    }

    public void duplicateTo(VectorHashKeyWrapper clone) {
        int i;
        clone.longValues = this.longValues.length > 0 ? (long[])this.longValues.clone() : EMPTY_LONG_ARRAY;
        clone.doubleValues = this.doubleValues.length > 0 ? (double[])this.doubleValues.clone() : EMPTY_DOUBLE_ARRAY;
        clone.isNull = (boolean[])this.isNull.clone();
        if (this.decimalValues.length > 0) {
            clone.decimalValues = new HiveDecimalWritable[this.decimalValues.length];
            for (i = 0; i < this.decimalValues.length; ++i) {
                clone.decimalValues[i] = new HiveDecimalWritable(this.decimalValues[i]);
            }
        } else {
            clone.decimalValues = EMPTY_DECIMAL_ARRAY;
        }
        if (this.byteLengths.length > 0) {
            clone.byteValues = new byte[this.byteValues.length][];
            clone.byteStarts = new int[this.byteValues.length];
            clone.byteLengths = (int[])this.byteLengths.clone();
            for (i = 0; i < this.byteValues.length; ++i) {
                if (this.isNull[this.longValues.length + this.doubleValues.length + i]) continue;
                clone.byteValues[i] = Arrays.copyOfRange(this.byteValues[i], this.byteStarts[i], this.byteStarts[i] + this.byteLengths[i]);
            }
        } else {
            clone.byteValues = EMPTY_BYTES_ARRAY;
            clone.byteStarts = EMPTY_INT_ARRAY;
            clone.byteLengths = EMPTY_INT_ARRAY;
        }
        if (this.timestampValues.length > 0) {
            clone.timestampValues = new Timestamp[this.timestampValues.length];
            for (i = 0; i < this.timestampValues.length; ++i) {
                clone.timestampValues[i] = (Timestamp)this.timestampValues[i].clone();
            }
        } else {
            clone.timestampValues = EMPTY_TIMESTAMP_ARRAY;
        }
        if (this.intervalDayTimeValues.length > 0) {
            clone.intervalDayTimeValues = new HiveIntervalDayTime[this.intervalDayTimeValues.length];
            for (i = 0; i < this.intervalDayTimeValues.length; ++i) {
                clone.intervalDayTimeValues[i] = (HiveIntervalDayTime)this.intervalDayTimeValues[i].clone();
            }
        } else {
            clone.intervalDayTimeValues = EMPTY_INTERVAL_DAY_TIME_ARRAY;
        }
        clone.hashcode = this.hashcode;
        assert (clone.equals(this));
    }

    @Override
    public KeyWrapper copyKey() {
        return (KeyWrapper)this.clone();
    }

    @Override
    public void copyKey(KeyWrapper oldWrapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] getKeyArray() {
        throw new UnsupportedOperationException();
    }

    public void assignDouble(int index, double d) {
        this.doubleValues[index] = d;
        this.isNull[this.longValues.length + index] = false;
    }

    public void assignNullDouble(int index) {
        this.doubleValues[index] = 0.0;
        this.isNull[this.longValues.length + index] = true;
    }

    public void assignLong(int index, long v) {
        this.longValues[index] = v;
        this.isNull[index] = false;
    }

    public void assignNullLong(int index) {
        this.longValues[index] = 0L;
        this.isNull[index] = true;
    }

    public void assignString(int index, byte[] bytes, int start, int length) {
        this.byteValues[index] = bytes;
        this.byteStarts[index] = start;
        this.byteLengths[index] = length;
        this.isNull[this.longValues.length + this.doubleValues.length + index] = false;
    }

    public void assignNullString(int index) {
        this.isNull[this.longValues.length + this.doubleValues.length + index] = true;
    }

    public void assignDecimal(int index, HiveDecimalWritable value) {
        this.decimalValues[index].set(value);
        this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + index] = false;
    }

    public void assignNullDecimal(int index) {
        this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + index] = true;
    }

    public void assignTimestamp(int index, Timestamp value) {
        this.timestampValues[index] = value;
        this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + this.decimalValues.length + index] = false;
    }

    public void assignTimestamp(int index, TimestampColumnVector colVector, int elementNum) {
        colVector.timestampUpdate(this.timestampValues[index], elementNum);
        this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + this.decimalValues.length + index] = false;
    }

    public void assignNullTimestamp(int index) {
        this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + this.decimalValues.length + index] = true;
    }

    public void assignIntervalDayTime(int index, HiveIntervalDayTime value) {
        this.intervalDayTimeValues[index].set(value);
        this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + this.decimalValues.length + this.timestampValues.length + index] = false;
    }

    public void assignIntervalDayTime(int index, IntervalDayTimeColumnVector colVector, int elementNum) {
        this.intervalDayTimeValues[index].set(colVector.asScratchIntervalDayTime(elementNum));
        this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + this.decimalValues.length + this.timestampValues.length + index] = false;
    }

    public void assignNullIntervalDayTime(int index) {
        this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + this.decimalValues.length + this.timestampValues.length + index] = true;
    }

    public String toString() {
        return String.format("%d[%s] %d[%s] %d[%s] %d[%s] %d[%s] %d[%s]", this.longValues.length, Arrays.toString(this.longValues), this.doubleValues.length, Arrays.toString(this.doubleValues), this.byteValues.length, Arrays.toString((Object[])this.byteValues), this.decimalValues.length, Arrays.toString(this.decimalValues), this.timestampValues.length, Arrays.toString(this.timestampValues), this.intervalDayTimeValues.length, Arrays.toString(this.intervalDayTimeValues));
    }

    public boolean getIsLongNull(int i) {
        return this.isNull[i];
    }

    public boolean getIsDoubleNull(int i) {
        return this.isNull[this.longValues.length + i];
    }

    public boolean getIsBytesNull(int i) {
        return this.isNull[this.longValues.length + this.doubleValues.length + i];
    }

    public long getLongValue(int i) {
        return this.longValues[i];
    }

    public double getDoubleValue(int i) {
        return this.doubleValues[i];
    }

    public byte[] getBytes(int i) {
        return this.byteValues[i];
    }

    public int getByteStart(int i) {
        return this.byteStarts[i];
    }

    public int getByteLength(int i) {
        return this.byteLengths[i];
    }

    public int getVariableSize() {
        int variableSize = 0;
        for (int i = 0; i < this.byteLengths.length; ++i) {
            JavaDataModel model = JavaDataModel.get();
            variableSize += model.lengthForByteArrayOfSize(this.byteLengths[i]);
        }
        return variableSize;
    }

    public boolean getIsDecimalNull(int i) {
        return this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + i];
    }

    public HiveDecimalWritable getDecimal(int i) {
        return this.decimalValues[i];
    }

    public boolean getIsTimestampNull(int i) {
        return this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + this.decimalValues.length + i];
    }

    public Timestamp getTimestamp(int i) {
        return this.timestampValues[i];
    }

    public boolean getIsIntervalDayTimeNull(int i) {
        return this.isNull[this.longValues.length + this.doubleValues.length + this.byteValues.length + this.decimalValues.length + this.timestampValues.length + i];
    }

    public HiveIntervalDayTime getIntervalDayTime(int i) {
        return this.intervalDayTimeValues[i];
    }
}

