/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.monitoring;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AbstractMapOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.PrintSummary;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;

class DAGSummary
implements PrintSummary {
    private static final int FILE_HEADER_SEPARATOR_WIDTH = 128;
    private static final String FILE_HEADER_SEPARATOR = new String(new char[128]).replace("\u0000", "-");
    private static final String FORMATTING_PATTERN = "%10s %12s %16s %13s %14s %13s %12s %14s %15s";
    private static final String FILE_HEADER = String.format("%10s %12s %16s %13s %14s %13s %12s %14s %15s", "VERTICES", "TOTAL_TASKS", "FAILED_ATTEMPTS", "KILLED_TASKS", "DURATION(ms)", "CPU_TIME(ms)", "GC_TIME(ms)", "INPUT_RECORDS", "OUTPUT_RECORDS");
    private final DecimalFormat secondsFormatter = new DecimalFormat("#0.00");
    private final NumberFormat commaFormatter = NumberFormat.getNumberInstance(Locale.US);
    private final String hiveCountersGroup;
    private final TezCounters hiveCounters;
    private Map<String, Progress> progressMap;
    private DAGClient dagClient;
    private DAG dag;
    private PerfLogger perfLogger;

    DAGSummary(Map<String, Progress> progressMap, HiveConf hiveConf, DAGClient dagClient, DAG dag, PerfLogger perfLogger) {
        this.progressMap = progressMap;
        this.dagClient = dagClient;
        this.dag = dag;
        this.perfLogger = perfLogger;
        this.hiveCountersGroup = HiveConf.getVar(hiveConf, HiveConf.ConfVars.HIVECOUNTERGROUP);
        this.hiveCounters = this.hiveCounters(dagClient);
    }

    private long hiveInputRecordsFromOtherVertices(String vertexName) {
        List inputVerticesList = this.dag.getVertex(vertexName).getInputVertices();
        long result = 0L;
        for (Vertex inputVertex : inputVerticesList) {
            String intermediateRecordsCounterName = this.formattedName(ReduceSinkOperator.Counter.RECORDS_OUT_INTERMEDIATE.toString(), inputVertex.getName());
            String recordsOutCounterName = this.formattedName(FileSinkOperator.Counter.RECORDS_OUT.toString(), inputVertex.getName());
            result += this.hiveCounterValue(intermediateRecordsCounterName) + this.hiveCounterValue(recordsOutCounterName);
        }
        return result;
    }

    private String formattedName(String counterName, String vertexName) {
        return String.format("%s_", counterName) + vertexName.replace(" ", "_");
    }

    private long getCounterValueByGroupName(TezCounters counters, String pattern, String counterName) {
        TezCounter tezCounter = ((CounterGroup)counters.getGroup(pattern)).findCounter(counterName);
        return tezCounter == null ? 0L : tezCounter.getValue();
    }

    private long hiveCounterValue(String counterName) {
        return this.getCounterValueByGroupName(this.hiveCounters, this.hiveCountersGroup, counterName);
    }

    private TezCounters hiveCounters(DAGClient dagClient) {
        try {
            return dagClient.getDAGStatus(EnumSet.of(StatusGetOpts.GET_COUNTERS)).getDAGCounters();
        }
        catch (IOException | TezException throwable) {
            return null;
        }
    }

    @Override
    public void print(SessionState.LogHelper console) {
        console.printInfo("Task Execution Summary");
        if (this.hiveCounters == null) {
            return;
        }
        this.printHeader(console);
        TreeSet<String> keys = new TreeSet<String>(this.progressMap.keySet());
        HashSet<StatusGetOpts> statusOptions = new HashSet<StatusGetOpts>(1);
        statusOptions.add(StatusGetOpts.GET_COUNTERS);
        for (String vertexName : keys) {
            VertexStatus vertexStatus;
            Progress progress = this.progressMap.get(vertexName);
            if (progress == null || (vertexStatus = this.vertexStatus(statusOptions, vertexName)) == null) continue;
            console.printInfo(this.vertexSummary(vertexName, progress, vertexStatus));
        }
        console.printInfo(FILE_HEADER_SEPARATOR);
    }

    private String vertexSummary(String vertexName, Progress progress, VertexStatus vertexStatus) {
        TezCounters vertexCounters = vertexStatus.getVertexCounters();
        double cpuTimeMillis = this.getCounterValueByGroupName(vertexCounters, TaskCounter.class.getName(), TaskCounter.CPU_MILLISECONDS.name());
        double gcTimeMillis = this.getCounterValueByGroupName(vertexCounters, TaskCounter.class.getName(), TaskCounter.GC_TIME_MILLIS.name());
        long hiveInputRecords = this.hiveCounterValue(this.formattedName(AbstractMapOperator.Counter.RECORDS_IN.toString(), vertexName)) + this.hiveInputRecordsFromOtherVertices(vertexName);
        long hiveOutputRecords = this.hiveCounterValue(this.formattedName(FileSinkOperator.Counter.RECORDS_OUT.toString(), vertexName)) + this.hiveCounterValue(this.formattedName(ReduceSinkOperator.Counter.RECORDS_OUT_INTERMEDIATE.toString(), vertexName));
        double duration = this.perfLogger.getDuration("TezRunVertex." + vertexName).longValue();
        return String.format(FORMATTING_PATTERN, vertexName, progress.getTotalTaskCount(), progress.getFailedTaskAttemptCount(), progress.getKilledTaskAttemptCount(), this.secondsFormatter.format(duration), this.commaFormatter.format(cpuTimeMillis), this.commaFormatter.format(gcTimeMillis), this.commaFormatter.format(hiveInputRecords), this.commaFormatter.format(hiveOutputRecords));
    }

    private VertexStatus vertexStatus(Set<StatusGetOpts> statusOptions, String vertexName) {
        try {
            return this.dagClient.getVertexStatus(vertexName, statusOptions);
        }
        catch (IOException | TezException throwable) {
            return null;
        }
    }

    private void printHeader(SessionState.LogHelper console) {
        console.printInfo(FILE_HEADER_SEPARATOR);
        console.printInfo(FILE_HEADER);
        console.printInfo(FILE_HEADER_SEPARATOR);
    }
}

