/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.factories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.descriptors.HiveCatalogValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.CatalogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalogFactory
implements CatalogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalogFactory.class);

    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("type", "hive");
        context.put("property-version", "1");
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("default-database");
        properties.add("hive-conf-dir");
        properties.add("hive-version");
        properties.add("hadoop-conf-dir");
        return properties;
    }

    public Catalog createCatalog(String name, Map<String, String> properties) {
        DescriptorProperties descriptorProperties = HiveCatalogFactory.getValidatedProperties(properties);
        String defaultDatabase = descriptorProperties.getOptionalString("default-database").orElse("default");
        Optional hiveConfDir = descriptorProperties.getOptionalString("hive-conf-dir");
        Optional hadoopConfDir = descriptorProperties.getOptionalString("hadoop-conf-dir");
        String version = descriptorProperties.getOptionalString("hive-version").orElse(HiveShimLoader.getHiveVersion());
        return new HiveCatalog(name, defaultDatabase, hiveConfDir.orElse(null), (String)hadoopConfDir.orElse(null), version);
    }

    private static DescriptorProperties getValidatedProperties(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        new HiveCatalogValidator().validate(descriptorProperties);
        return descriptorProperties;
    }
}

