/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.List;
import java.util.Map;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.util.Preconditions;

public class HiveTableFactory
implements TableSourceFactory,
TableSinkFactory {
    public Map<String, String> requiredContext() {
        throw new UnsupportedOperationException();
    }

    public List<String> supportedProperties() {
        throw new UnsupportedOperationException();
    }

    public TableSource createTableSource(TableSourceFactory.Context context) {
        CatalogTable table = (CatalogTable)Preconditions.checkNotNull((Object)context.getTable());
        Preconditions.checkArgument((boolean)(table instanceof CatalogTableImpl));
        boolean isGeneric = Boolean.parseBoolean((String)table.getProperties().get("is_generic"));
        if (!isGeneric && !context.isTemporary()) {
            throw new UnsupportedOperationException("Hive table should be resolved by HiveDynamicTableFactory.");
        }
        return TableFactoryUtil.findAndCreateTableSource((TableSourceFactory.Context)context);
    }

    public TableSink createTableSink(TableSinkFactory.Context context) {
        CatalogTable table = (CatalogTable)Preconditions.checkNotNull((Object)context.getTable());
        Preconditions.checkArgument((boolean)(table instanceof CatalogTableImpl));
        boolean isGeneric = Boolean.parseBoolean((String)table.getProperties().get("is_generic"));
        if (!isGeneric && !context.isTemporary()) {
            throw new UnsupportedOperationException("Hive table should be resolved by HiveDynamicTableFactory.");
        }
        return TableFactoryUtil.findAndCreateTableSink((TableSinkFactory.Context)context);
    }
}

