/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.HashMap;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connectors.hive.HiveLookupTableSource;
import org.apache.flink.connectors.hive.HiveTableSink;
import org.apache.flink.connectors.hive.HiveTableSource;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.filesystem.FileSystemOptions;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapred.JobConf;

public class HiveDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private final HiveConf hiveConf;

    public HiveDynamicTableFactory(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
    }

    public String factoryIdentifier() {
        throw new UnsupportedOperationException("Hive factory is only work for catalog.");
    }

    public Set<ConfigOption<?>> requiredOptions() {
        throw new UnsupportedOperationException("Hive factory is only work for catalog.");
    }

    public Set<ConfigOption<?>> optionalOptions() {
        throw new UnsupportedOperationException("Hive factory is only work for catalog.");
    }

    private static CatalogTable removeIsGenericFlag(DynamicTableFactory.Context context) {
        HashMap newOptions = new HashMap(context.getCatalogTable().getOptions());
        boolean isGeneric = Boolean.parseBoolean((String)newOptions.remove("is_generic"));
        if (!isGeneric && !context.isTemporary()) {
            throw new ValidationException("Hive dynamic table factory now only work for generic table.");
        }
        return context.getCatalogTable().copy(newOptions);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        boolean isGeneric = Boolean.parseBoolean((String)context.getCatalogTable().getOptions().get("is_generic"));
        if (!isGeneric && !context.isTemporary()) {
            return new HiveTableSink(context.getConfiguration(), new JobConf((Configuration)this.hiveConf), context.getObjectIdentifier(), context.getCatalogTable());
        }
        return FactoryUtil.createTableSink(null, (ObjectIdentifier)context.getObjectIdentifier(), (CatalogTable)HiveDynamicTableFactory.removeIsGenericFlag(context), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        boolean isGeneric = Boolean.parseBoolean((String)context.getCatalogTable().getOptions().get("is_generic"));
        if (!isGeneric && !context.isTemporary()) {
            CatalogTable catalogTable = (CatalogTable)Preconditions.checkNotNull((Object)context.getCatalogTable());
            boolean isStreamingSource = Boolean.parseBoolean(catalogTable.getOptions().getOrDefault(FileSystemOptions.STREAMING_SOURCE_ENABLE.key(), ((Boolean)FileSystemOptions.STREAMING_SOURCE_ENABLE.defaultValue()).toString()));
            boolean includeAllPartition = ((String)FileSystemOptions.STREAMING_SOURCE_PARTITION_INCLUDE.defaultValue()).equals(catalogTable.getOptions().getOrDefault(FileSystemOptions.STREAMING_SOURCE_PARTITION_INCLUDE.key(), FileSystemOptions.STREAMING_SOURCE_PARTITION_INCLUDE.defaultValue()));
            if (isStreamingSource && includeAllPartition) {
                return new HiveTableSource(new JobConf((Configuration)this.hiveConf), context.getConfiguration(), context.getObjectIdentifier().toObjectPath(), catalogTable);
            }
            return new HiveLookupTableSource(new JobConf((Configuration)this.hiveConf), context.getConfiguration(), context.getObjectIdentifier().toObjectPath(), catalogTable);
        }
        return FactoryUtil.createTableSource(null, (ObjectIdentifier)context.getObjectIdentifier(), (CatalogTable)HiveDynamicTableFactory.removeIsGenericFlag(context), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
    }
}

