/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class FilterDecimalColumnBetween
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private HiveDecimal leftValue;
    private HiveDecimal rightValue;

    public FilterDecimalColumnBetween(int colNum, HiveDecimal leftValue, HiveDecimal rightValue) {
        this.colNum = colNum;
        this.leftValue = leftValue;
        this.rightValue = rightValue;
    }

    public FilterDecimalColumnBetween() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.cols[this.colNum];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        HiveDecimalWritable[] vector = inputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (DecimalUtil.compare(vector[0], this.leftValue) < 0 || DecimalUtil.compare(vector[0], this.rightValue) > 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (DecimalUtil.compare(this.leftValue, vector[i]) > 0 || DecimalUtil.compare(vector[i], this.rightValue) > 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (DecimalUtil.compare(this.leftValue, vector[i]) > 0 || DecimalUtil.compare(vector[i], this.rightValue) > 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (DecimalUtil.compare(vector[0], this.leftValue) < 0 || DecimalUtil.compare(vector[0], this.rightValue) > 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || DecimalUtil.compare(this.leftValue, vector[i]) > 0 || DecimalUtil.compare(vector[i], this.rightValue) > 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || DecimalUtil.compare(this.leftValue, vector[i]) > 0 || DecimalUtil.compare(vector[i], this.rightValue) > 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("decimal"), VectorExpressionDescriptor.ArgumentType.getType("decimal"), VectorExpressionDescriptor.ArgumentType.getType("decimal")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

