/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.table.planner.delegation.hive.HiveParserIntervalUtils;

public class HiveParserIntervalYearMonth
implements Comparable<HiveParserIntervalYearMonth> {
    protected int totalMonths;
    protected static final int MONTHS_PER_YEAR = 12;
    private static final String PARSE_PATTERN = "([+|-])?(\\d+)-(\\d+)";
    private static final ThreadLocal<Matcher> PATTERN_MATCHER = new ThreadLocal<Matcher>(){

        @Override
        protected Matcher initialValue() {
            return Pattern.compile(HiveParserIntervalYearMonth.PARSE_PATTERN).matcher("");
        }
    };

    public HiveParserIntervalYearMonth(int years, int months) {
        this.set(years, months);
    }

    public HiveParserIntervalYearMonth(int totalMonths) {
        this.set(totalMonths);
    }

    public int getYears() {
        return this.totalMonths / 12;
    }

    public int getMonths() {
        return this.totalMonths % 12;
    }

    public int getTotalMonths() {
        return this.totalMonths;
    }

    public void set(int years, int months) {
        this.totalMonths = months;
        this.totalMonths += years * 12;
    }

    public void set(int totalMonths) {
        this.totalMonths = totalMonths;
    }

    public void set(HiveParserIntervalYearMonth other) {
        this.set(other.getTotalMonths());
    }

    @Override
    public int compareTo(HiveParserIntervalYearMonth other) {
        int cmp = this.getTotalMonths() - other.getTotalMonths();
        if (cmp != 0) {
            cmp = cmp > 0 ? 1 : -1;
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HiveParserIntervalYearMonth)) {
            return false;
        }
        return 0 == this.compareTo((HiveParserIntervalYearMonth)obj);
    }

    public int hashCode() {
        return this.totalMonths;
    }

    public String toString() {
        String yearMonthSignStr = this.totalMonths >= 0 ? "" : "-";
        return String.format("%s%d-%d", yearMonthSignStr, Math.abs(this.getYears()), Math.abs(this.getMonths()));
    }

    public static HiveParserIntervalYearMonth valueOf(String strVal) {
        HiveParserIntervalYearMonth result;
        if (strVal == null) {
            throw new IllegalArgumentException("Interval year-month string was null");
        }
        Matcher patternMatcher = PATTERN_MATCHER.get();
        patternMatcher.reset(strVal);
        if (patternMatcher.matches()) {
            try {
                int sign = 1;
                String field = patternMatcher.group(1);
                if (field != null && field.equals("-")) {
                    sign = -1;
                }
                int years = sign * HiveParserIntervalUtils.parseNumericValueWithRange("year", patternMatcher.group(2), 0, Integer.MAX_VALUE);
                byte months = (byte)(sign * HiveParserIntervalUtils.parseNumericValueWithRange("month", patternMatcher.group(3), 0, 11));
                result = new HiveParserIntervalYearMonth(years, months);
            }
            catch (Exception err) {
                throw new IllegalArgumentException("Error parsing interval year-month string: " + strVal, err);
            }
        } else {
            throw new IllegalArgumentException("Interval string does not match year-month format of 'y-m': " + strVal);
        }
        return result;
    }
}

