/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module.hive;

import java.util.Collections;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.ModuleFactory;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.hive.HiveModule;
import org.apache.flink.table.module.hive.HiveModuleOptions;

@Internal
public class HiveModuleFactory
implements ModuleFactory {
    public static final String IDENTIFIER = "hive";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.singleton(HiveModuleOptions.HIVE_VERSION);
    }

    public Module createModule(ModuleFactory.Context context) {
        FactoryUtil.ModuleFactoryHelper factoryHelper = FactoryUtil.createModuleFactoryHelper((ModuleFactory)this, (ModuleFactory.Context)context);
        factoryHelper.validate();
        String hiveVersion = factoryHelper.getOptions().getOptional(HiveModuleOptions.HIVE_VERSION).orElseGet(HiveShimLoader::getHiveVersion);
        return new HiveModule(hiveVersion);
    }
}

