/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.hive.FlinkHiveUDFException;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.util.HiveFunctionUtil;
import org.apache.flink.table.runtime.types.ClassLogicalTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Internal
public abstract class HiveScalarFunction<UDFType>
extends ScalarFunction {
    protected final HiveFunctionWrapper<UDFType> hiveFunctionWrapper;
    protected Object[] constantArguments;
    protected DataType[] argTypes;
    protected transient UDFType function;
    protected transient ObjectInspector returnInspector;
    private transient boolean isArgsSingleArray;

    HiveScalarFunction(HiveFunctionWrapper<UDFType> hiveFunctionWrapper) {
        this.hiveFunctionWrapper = hiveFunctionWrapper;
    }

    public boolean isDeterministic() {
        try {
            UDFType udfType = this.hiveFunctionWrapper.getUDFClass().getAnnotation(UDFType.class);
            return udfType != null && udfType.deterministic() && !udfType.stateful();
        }
        catch (ClassNotFoundException e) {
            throw new FlinkHiveUDFException(e);
        }
    }

    public void open(FunctionContext context) {
        this.openInternal();
        this.isArgsSingleArray = HiveFunctionUtil.isSingleBoxedArray(this.argTypes);
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        TypeInference.Builder builder = TypeInference.newBuilder();
        builder.inputTypeStrategy((InputTypeStrategy)new HiveUDFInputStrategy());
        builder.outputTypeStrategy((TypeStrategy)new HiveUDFOutputStrategy());
        return builder.build();
    }

    protected abstract void openInternal();

    public Object eval(Object ... args) {
        if (this.isArgsSingleArray) {
            args = new Object[]{args};
        }
        return this.evalInternal(args);
    }

    protected abstract Object evalInternal(Object[] var1);

    private void setArguments(CallContext callContext) {
        DataType[] inputTypes = callContext.getArgumentDataTypes().toArray(new DataType[0]);
        Object[] constantArgs = new Object[inputTypes.length];
        for (int i = 0; i < constantArgs.length; ++i) {
            if (!callContext.isArgumentLiteral(i)) continue;
            constantArgs[i] = callContext.getArgumentValue(i, ClassLogicalTypeConverter.getDefaultExternalClassForType((LogicalType)inputTypes[i].getLogicalType())).orElse(null);
        }
        this.constantArguments = constantArgs;
        this.argTypes = inputTypes;
    }

    protected abstract DataType inferReturnType() throws UDFArgumentException;

    private class HiveUDFInputStrategy
    implements InputTypeStrategy {
        private HiveUDFInputStrategy() {
        }

        public ArgumentCount getArgumentCount() {
            return ConstantArgumentCount.any();
        }

        public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
            HiveScalarFunction.this.setArguments(callContext);
            try {
                HiveScalarFunction.this.inferReturnType();
            }
            catch (UDFArgumentException e) {
                if (throwOnFailure) {
                    throw new ValidationException(String.format("Cannot find a suitable Hive function from %s for the input arguments", HiveScalarFunction.this.hiveFunctionWrapper.getClassName()), (Throwable)e);
                }
                return Optional.empty();
            }
            return Optional.of(callContext.getArgumentDataTypes());
        }

        public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
            return Collections.singletonList(Signature.of((Signature.Argument[])new Signature.Argument[]{Signature.Argument.of((String)"*")}));
        }
    }

    private class HiveUDFOutputStrategy
    implements TypeStrategy {
        private HiveUDFOutputStrategy() {
        }

        public Optional<DataType> inferType(CallContext callContext) {
            HiveScalarFunction.this.setArguments(callContext);
            try {
                return Optional.of(HiveScalarFunction.this.inferReturnType());
            }
            catch (UDFArgumentException e) {
                throw new FlinkHiveUDFException(e);
            }
        }
    }
}

