/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.read;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.mapred.FileSplit;

@PublicEvolving
public class HiveSourceSplit
extends FileSourceSplit {
    private static final long serialVersionUID = 1L;
    private final HiveTablePartition hiveTablePartition;

    public HiveSourceSplit(FileSplit fileSplit, HiveTablePartition hiveTablePartition, @Nullable CheckpointedPosition readerPosition) throws IOException {
        this(fileSplit.toString(), new Path(fileSplit.getPath().toString()), fileSplit.getStart(), fileSplit.getLength(), fileSplit.getLocations(), readerPosition, hiveTablePartition);
    }

    public HiveSourceSplit(String id, Path filePath, long offset, long length, String[] hostnames, @Nullable CheckpointedPosition readerPosition, HiveTablePartition hiveTablePartition) {
        super(id, filePath, offset, length, hostnames, readerPosition);
        this.hiveTablePartition = (HiveTablePartition)Preconditions.checkNotNull((Object)hiveTablePartition, (String)"hiveTablePartition can not be null");
    }

    public HiveTablePartition getHiveTablePartition() {
        return this.hiveTablePartition;
    }

    public FileSplit toMapRedSplit() {
        return new FileSplit(new org.apache.hadoop.fs.Path(this.path().toString()), this.offset(), this.length(), this.hostnames());
    }

    public FileSourceSplit updateWithCheckpointedPosition(@Nullable CheckpointedPosition position) {
        return new HiveSourceSplit(this.splitId(), this.path(), this.offset(), this.length(), this.hostnames(), position, this.hiveTablePartition);
    }

    public String toString() {
        return "HiveSourceSplit{" + String.format("Path=%s, ", this.path()) + String.format("Offset=%d, ", this.offset()) + String.format("Length=%d, ", this.length()) + String.format("Position=%s, ", this.getReaderPosition().map(CheckpointedPosition::toString).orElse("null")) + String.format("HiveTablePartition=%s", this.getHiveTablePartition()) + '}';
    }
}

