/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.flink.api.java.hadoop.common.HadoopInputFormatCommonBase;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;

public class JobConfWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient JobConf jobConf;

    public JobConfWrapper(JobConf jobConf) {
        this.jobConf = jobConf;
    }

    public JobConf conf() {
        return this.jobConf;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        DataOutputSerializer ser = new DataOutputSerializer(256);
        this.jobConf.write((DataOutput)ser);
        out.writeInt(ser.length());
        out.write(ser.getSharedBuffer(), 0, ser.length());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        DataInputDeserializer deser = new DataInputDeserializer(data);
        this.jobConf = new JobConf();
        try {
            this.jobConf.readFields((DataInput)deser);
        }
        catch (IOException e) {
            throw new IOException("Could not deserialize JobConf, the serialized and de-serialized don't match.", e);
        }
        Credentials currentUserCreds = HadoopInputFormatCommonBase.getCredentialsFromUGI(UserGroupInformation.getCurrentUser());
        if (currentUserCreds != null) {
            this.jobConf.getCredentials().addAll(currentUserCreds);
        }
    }
}

