/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBasePad;
import org.apache.hadoop.io.Text;

@Description(name="lpad", value="_FUNC_(str, len, pad) - Returns str, left-padded with pad to a length of len", extended="If str is longer than len, the return value is shortened to len characters.\nExample:\n  > SELECT _FUNC_('hi', 5, '??') FROM src LIMIT 1;\n  '???hi'  > SELECT _FUNC_('hi', 1, '??') FROM src LIMIT 1;\n  'h'")
public class GenericUDFLpad
extends GenericUDFBasePad {
    public GenericUDFLpad() {
        super("lpad");
    }

    @Override
    protected void performOp(byte[] data, byte[] txt, byte[] padTxt, int len, Text str, Text pad) {
        int i;
        int pos = Math.max(len - str.getLength(), 0);
        for (i = 0; i < pos; i += pad.getLength()) {
            for (int j = 0; j < pad.getLength() && j < pos - i; ++j) {
                data[i + j] = padTxt[j];
            }
        }
        for (i = 0; pos + i < len && i < str.getLength(); ++i) {
            data[pos + i] = txt[i];
        }
    }
}

