/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public abstract class ExprNodeDesc
implements Serializable,
Node {
    private static final long serialVersionUID = 1L;
    protected TypeInfo typeInfo;

    public ExprNodeDesc() {
    }

    public ExprNodeDesc(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
        if (typeInfo == null) {
            throw new RuntimeException("typeInfo cannot be null!");
        }
    }

    public abstract ExprNodeDesc clone();

    public abstract boolean isSame(Object var1);

    public int hashCode() {
        return this.typeInfo.hashCode();
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    public String getExprString() {
        assert (false);
        return null;
    }

    public ObjectInspector getWritableObjectInspector() {
        return TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(this.typeInfo);
    }

    public String getTypeString() {
        return this.typeInfo.getTypeName();
    }

    public List<String> getCols() {
        return null;
    }

    public List<ExprNodeDesc> getChildren() {
        return null;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public static class ExprNodeDescEqualityWrapper {
        private ExprNodeDesc exprNodeDesc;

        public ExprNodeDescEqualityWrapper(ExprNodeDesc exprNodeDesc) {
            this.exprNodeDesc = exprNodeDesc;
        }

        public ExprNodeDesc getExprNodeDesc() {
            return this.exprNodeDesc;
        }

        public void setExprNodeDesc(ExprNodeDesc exprNodeDesc) {
            this.exprNodeDesc = exprNodeDesc;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ExprNodeDescEqualityWrapper)) {
                return false;
            }
            return this.exprNodeDesc.isSame(((ExprNodeDescEqualityWrapper)other).getExprNodeDesc());
        }

        public int hashCode() {
            return this.exprNodeDesc == null ? 0 : this.exprNodeDesc.hashCode();
        }

        public static Collection<ExprNodeDescEqualityWrapper> transform(Collection<ExprNodeDesc> descs) {
            if (descs == null) {
                return null;
            }
            ArrayList<ExprNodeDescEqualityWrapper> wrapped = new ArrayList<ExprNodeDescEqualityWrapper>(descs.size());
            for (ExprNodeDesc desc : descs) {
                wrapped.add(new ExprNodeDescEqualityWrapper(desc));
            }
            return wrapped;
        }
    }
}

