/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTErrorNode;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.HiveLexer;
import org.apache.hadoop.hive.ql.parse.HiveParser;
import org.apache.hadoop.hive.ql.parse.HiveParser_SelectClauseParser;
import org.apache.hadoop.hive.ql.parse.ParseError;
import org.apache.hadoop.hive.ql.parse.ParseException;

public class ParseDriver {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.parse.ParseDriver");
    public static final TreeAdaptor adaptor = new CommonTreeAdaptor(){

        @Override
        public Object create(Token payload) {
            return new ASTNode(payload);
        }

        @Override
        public Object dupNode(Object t) {
            return this.create(((CommonTree)t).token);
        }

        @Override
        public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e) {
            return new ASTErrorNode(input, start, stop, e);
        }
    };

    public ASTNode parse(String command) throws ParseException {
        return this.parse(command, null);
    }

    public ASTNode parse(String command, Context ctx) throws ParseException {
        return this.parse(command, ctx, true);
    }

    public ASTNode parse(String command, Context ctx, boolean setTokenRewriteStream) throws ParseException {
        LOG.info((Object)("Parsing command: " + command));
        HiveLexerX lexer = new HiveLexerX(new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        if (ctx != null) {
            if (setTokenRewriteStream) {
                ctx.setTokenRewriteStream(tokens);
            }
            lexer.setHiveConf(ctx.getConf());
        }
        HiveParser parser = new HiveParser(tokens);
        if (ctx != null) {
            parser.setHiveConf(ctx.getConf());
        }
        parser.setTreeAdaptor(adaptor);
        HiveParser.statement_return r = null;
        try {
            r = parser.statement();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new ParseException(lexer.getErrors());
            }
            throw new ParseException(parser.errors);
        }
        LOG.info((Object)"Parse Completed");
        ASTNode tree = (ASTNode)r.getTree();
        tree.setUnknownTokenBoundaries();
        return tree;
    }

    public ASTNode parseSelect(String command, Context ctx) throws ParseException {
        LOG.info((Object)("Parsing command: " + command));
        HiveLexerX lexer = new HiveLexerX(new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        if (ctx != null) {
            ctx.setTokenRewriteStream(tokens);
        }
        HiveParser parser = new HiveParser(tokens);
        parser.setTreeAdaptor(adaptor);
        HiveParser_SelectClauseParser.selectClause_return r = null;
        try {
            r = parser.selectClause();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new ParseException(lexer.getErrors());
            }
            throw new ParseException(parser.errors);
        }
        LOG.info((Object)"Parse Completed");
        return (ASTNode)r.getTree();
    }

    public class HiveLexerX
    extends HiveLexer {
        private final ArrayList<ParseError> errors;

        public HiveLexerX() {
            this.errors = new ArrayList();
        }

        public HiveLexerX(CharStream input) {
            super(input);
            this.errors = new ArrayList();
        }

        @Override
        public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
            this.errors.add(new ParseError(this, e, tokenNames));
        }

        @Override
        public String getErrorMessage(RecognitionException e, String[] tokenNames) {
            String msg = null;
            if (e instanceof NoViableAltException) {
                NoViableAltException nvae = (NoViableAltException)e;
                msg = "character " + this.getCharErrorDisplay(e.c) + " not supported here";
            } else {
                msg = super.getErrorMessage(e, tokenNames);
            }
            return msg;
        }

        public ArrayList<ParseError> getErrors() {
            return this.errors;
        }
    }

    public class ANTLRNoCaseStringStream
    extends ANTLRStringStream {
        public ANTLRNoCaseStringStream(String input) {
            super(input);
        }

        @Override
        public int LA(int i) {
            int returnChar = super.LA(i);
            if (returnChar == -1) {
                return returnChar;
            }
            if (returnChar == 0) {
                return returnChar;
            }
            return Character.toUpperCase((char)returnChar);
        }
    }
}

