/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.CachingPrintStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.common.util.StreamPrinter;

public class MapRedTask
extends ExecDriver
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String HADOOP_MEM_KEY = "HADOOP_HEAPSIZE";
    static final String HADOOP_OPTS_KEY = "HADOOP_OPTS";
    static final String HADOOP_CLIENT_OPTS = "HADOOP_CLIENT_OPTS";
    static final String HIVE_DEBUG_RECURSIVE = "HIVE_DEBUG_RECURSIVE";
    static final String HIVE_MAIN_CLIENT_DEBUG_OPTS = "HIVE_MAIN_CLIENT_DEBUG_OPTS";
    static final String HIVE_CHILD_CLIENT_DEBUG_OPTS = "HIVE_CHILD_CLIENT_DEBUG_OPTS";
    static final String[] HIVE_SYS_PROP = new String[]{"build.dir", "build.dir.hive", "hive.query.id"};
    private transient ContentSummary inputSummary = null;
    private transient boolean runningViaChild = false;
    private transient long totalInputFileSize;
    private transient long totalInputNumFiles;
    private Process executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        Context ctx = driverContext.getCtx();
        boolean ctxCreated = false;
        try {
            if (ctx == null) {
                ctx = new Context(this.conf);
                ctxCreated = true;
            }
            this.setNumberOfReducers();
            if (!ctx.isLocalOnlyExecutionMode() && this.conf.getBoolVar(HiveConf.ConfVars.LOCALMODEAUTO)) {
                String reason;
                int numReducers;
                if (this.inputSummary == null) {
                    this.inputSummary = Utilities.getInputSummary(driverContext.getCtx(), ((MapredWork)this.work).getMapWork(), null);
                }
                double samplePercentage = Utilities.getHighestSamplePercentage(((MapredWork)this.work).getMapWork());
                this.totalInputFileSize = Utilities.getTotalInputFileSize(this.inputSummary, ((MapredWork)this.work).getMapWork(), samplePercentage);
                this.totalInputNumFiles = Utilities.getTotalInputNumFiles(this.inputSummary, ((MapredWork)this.work).getMapWork(), samplePercentage);
                int n = numReducers = ((MapredWork)this.work).getReduceWork() == null ? 0 : ((MapredWork)this.work).getReduceWork().getNumReduceTasks();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Task: " + this.getId() + ", Summary: " + this.totalInputFileSize + "," + this.totalInputNumFiles + "," + numReducers));
                }
                if ((reason = MapRedTask.isEligibleForLocalMode(this.conf, numReducers, this.totalInputFileSize, this.totalInputNumFiles)) == null) {
                    this.cloneConf();
                    ShimLoader.getHadoopShims().setJobLauncherRpcAddress(this.conf, "local");
                    this.console.printInfo("Selecting local mode for task: " + this.getId());
                    this.setLocalMode(true);
                } else {
                    this.console.printInfo("Cannot run job locally: " + reason);
                    this.setLocalMode(false);
                }
            }
            this.runningViaChild = this.conf.getBoolVar(HiveConf.ConfVars.SUBMITVIACHILD);
            if (!this.runningViaChild) {
                int n = super.execute(driverContext);
                return n;
            }
            this.cloneConf();
            super.setInputAttributes(this.conf);
            String hadoopExec = this.conf.getVar(HiveConf.ConfVars.HADOOPBIN);
            String hiveJar = this.conf.getJar();
            String addedJars = Utilities.getResourceFiles(this.conf, SessionState.ResourceType.JAR);
            this.conf.setVar(HiveConf.ConfVars.HIVEADDEDJARS, addedJars);
            String auxJars = this.conf.getAuxJars();
            String libJarsOption = StringUtils.isEmpty(addedJars) ? (StringUtils.isEmpty(auxJars) ? " " : " -libjars " + auxJars + " ") : (StringUtils.isEmpty(auxJars) ? " -libjars " + addedJars + " " : " -libjars " + addedJars + "," + auxJars + " ");
            String hiveConfArgs = MapRedTask.generateCmdLine(this.conf, ctx);
            Path planPath = new Path(ctx.getLocalTmpPath(), "plan.xml");
            MapredWork plan = (MapredWork)this.getWork();
            LOG.info((Object)("Generating plan file " + planPath.toString()));
            FSDataOutputStream out = null;
            try {
                out = FileSystem.getLocal((Configuration)this.conf).create(planPath);
                Utilities.serializePlan(plan, (OutputStream)out, this.conf);
                out.close();
                out = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            String isSilent = "true".equalsIgnoreCase(System.getProperty("test.silent")) ? "-nolog" : "";
            String jarCmd = hiveJar + " " + ExecDriver.class.getName() + libJarsOption;
            String cmdLine = hadoopExec + " jar " + jarCmd + " -plan " + planPath.toString() + " " + isSilent + " " + hiveConfArgs;
            String workDir = new File(".").getCanonicalPath();
            String files = Utilities.getResourceFiles(this.conf, SessionState.ResourceType.FILE);
            if (!files.isEmpty()) {
                cmdLine = cmdLine + " -files " + files;
                workDir = ctx.getLocalTmpPath().toUri().getPath();
                if (!new File(workDir).mkdir()) {
                    throw new IOException("Cannot create tmp working dir: " + workDir);
                }
                for (String string : StringUtils.split(files, ',')) {
                    String link;
                    Path p = new Path(string);
                    String target = p.toUri().getPath();
                    if (FileUtil.symLink((String)target, (String)(link = workDir + "/" + p.getName())) == 0) continue;
                    throw new IOException("Cannot link to added file: " + target + " from: " + link);
                }
            }
            LOG.info((Object)("Executing: " + cmdLine));
            StringBuilder sb = new StringBuilder();
            Properties p = System.getProperties();
            for (String element : HIVE_SYS_PROP) {
                if (!p.containsKey(element)) continue;
                sb.append(" -D" + (String)element + "=" + p.getProperty(element));
            }
            String hadoopOpts = sb.toString();
            HashMap<String, String> variables = new HashMap<String, String>(System.getenv());
            if (ShimLoader.getHadoopShims().isLocalMode(this.conf)) {
                int hadoopMem = this.conf.getIntVar(HiveConf.ConfVars.HIVEHADOOPMAXMEM);
                if (hadoopMem == 0) {
                    variables.remove(HADOOP_MEM_KEY);
                } else {
                    variables.put(HADOOP_MEM_KEY, String.valueOf(hadoopMem));
                }
            }
            if (variables.containsKey(HADOOP_OPTS_KEY)) {
                variables.put(HADOOP_OPTS_KEY, (String)variables.get(HADOOP_OPTS_KEY) + hadoopOpts);
            } else {
                variables.put(HADOOP_OPTS_KEY, hadoopOpts);
            }
            if (variables.containsKey(HIVE_DEBUG_RECURSIVE)) {
                MapRedTask.configureDebugVariablesForChildJVM(variables);
            }
            String[] stringArray = new String[variables.size()];
            int pos = 0;
            for (Map.Entry entry : variables.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                stringArray[pos++] = name + "=" + value;
            }
            this.executor = Runtime.getRuntime().exec(cmdLine, stringArray, new File(workDir));
            CachingPrintStream errPrintStream = new CachingPrintStream(SessionState.getConsole().getChildErrStream());
            StreamPrinter streamPrinter = new StreamPrinter(this.executor.getInputStream(), null, SessionState.getConsole().getChildOutStream());
            StreamPrinter errPrinter = new StreamPrinter(this.executor.getErrorStream(), null, errPrintStream);
            streamPrinter.start();
            errPrinter.start();
            int exitVal = this.jobExecHelper.progressLocal(this.executor, this.getId());
            streamPrinter.join();
            errPrinter.join();
            if (exitVal != 0) {
                LOG.error((Object)("Execution failed with exit status: " + exitVal));
                if (SessionState.get() != null) {
                    SessionState.get().addLocalMapRedErrors(this.getId(), errPrintStream.getOutput());
                }
            } else {
                LOG.info((Object)"Execution completed successfully");
            }
            int n = exitVal;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)("Exception: " + e.getMessage()));
            int n = 1;
            return n;
        }
        finally {
            try {
                if (ctxCreated) {
                    ctx.clear();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception: " + e.getMessage()));
            }
        }
    }

    static void configureDebugVariablesForChildJVM(Map<String, String> environmentVariables) {
        assert (environmentVariables.containsKey(HADOOP_CLIENT_OPTS) && environmentVariables.get(HADOOP_CLIENT_OPTS) != null) : "HADOOP_CLIENT_OPTS environment variable must be set when JVM in debug mode";
        String hadoopClientOpts = environmentVariables.get(HADOOP_CLIENT_OPTS);
        assert (environmentVariables.containsKey(HIVE_MAIN_CLIENT_DEBUG_OPTS) && environmentVariables.get(HIVE_MAIN_CLIENT_DEBUG_OPTS) != null) : "HIVE_MAIN_CLIENT_DEBUG_OPTS environment variable must be set when JVM in debug mode";
        assert (hadoopClientOpts.contains(environmentVariables.get(HIVE_MAIN_CLIENT_DEBUG_OPTS))) : "HADOOP_CLIENT_OPTS environment variable must contain debugging parameters, when JVM in debugging mode";
        assert ("y".equals(environmentVariables.get(HIVE_DEBUG_RECURSIVE)) || "n".equals(environmentVariables.get(HIVE_DEBUG_RECURSIVE))) : "HIVE_DEBUG_RECURSIVE environment variable must be set to \"y\" or \"n\" when debugging";
        if (environmentVariables.get(HIVE_DEBUG_RECURSIVE).equals("y")) {
            assert (environmentVariables.containsKey(HIVE_CHILD_CLIENT_DEBUG_OPTS) && environmentVariables.get(HIVE_CHILD_CLIENT_DEBUG_OPTS) != null) : "HIVE_CHILD_CLIENT_DEBUG_OPTS environment variable must be set when JVM in debug mode";
            String newHadoopClientOpts = hadoopClientOpts.replace(environmentVariables.get(HIVE_MAIN_CLIENT_DEBUG_OPTS), environmentVariables.get(HIVE_CHILD_CLIENT_DEBUG_OPTS));
            environmentVariables.put(HADOOP_CLIENT_OPTS, newHadoopClientOpts);
        } else {
            String newHadoopClientOpts = hadoopClientOpts.replace(environmentVariables.get(HIVE_MAIN_CLIENT_DEBUG_OPTS), "").trim();
            if (newHadoopClientOpts.isEmpty()) {
                environmentVariables.remove(HADOOP_CLIENT_OPTS);
            } else {
                environmentVariables.put(HADOOP_CLIENT_OPTS, newHadoopClientOpts);
            }
        }
        environmentVariables.remove(HIVE_DEBUG_RECURSIVE);
    }

    @Override
    public boolean mapStarted() {
        boolean b = super.mapStarted();
        return this.runningViaChild ? this.isdone : b;
    }

    @Override
    public boolean reduceStarted() {
        boolean b = super.reduceStarted();
        return this.runningViaChild ? this.isdone : b;
    }

    @Override
    public boolean mapDone() {
        boolean b = super.mapDone();
        return this.runningViaChild ? this.isdone : b;
    }

    @Override
    public boolean reduceDone() {
        boolean b = super.reduceDone();
        return this.runningViaChild ? this.isdone : b;
    }

    private void setNumberOfReducers() throws IOException {
        ReduceWork rWork = ((MapredWork)this.work).getReduceWork();
        Integer numReducersFromWork = rWork == null ? 0 : rWork.getNumReduceTasks();
        if (rWork == null) {
            this.console.printInfo("Number of reduce tasks is set to 0 since there's no reduce operator");
        } else {
            if (numReducersFromWork >= 0) {
                this.console.printInfo("Number of reduce tasks determined at compile time: " + rWork.getNumReduceTasks());
            } else if (this.job.getNumReduceTasks() > 0) {
                int reducers = this.job.getNumReduceTasks();
                rWork.setNumReduceTasks(reducers);
                this.console.printInfo("Number of reduce tasks not specified. Defaulting to jobconf value of: " + reducers);
            } else {
                if (this.inputSummary == null) {
                    this.inputSummary = Utilities.getInputSummary(this.driverContext.getCtx(), ((MapredWork)this.work).getMapWork(), null);
                }
                int reducers = Utilities.estimateNumberOfReducers(this.conf, this.inputSummary, ((MapredWork)this.work).getMapWork(), ((MapredWork)this.work).isFinalMapRed());
                rWork.setNumReduceTasks(reducers);
                this.console.printInfo("Number of reduce tasks not specified. Estimated from input data size: " + reducers);
            }
            this.console.printInfo("In order to change the average load for a reducer (in bytes):");
            this.console.printInfo("  set " + HiveConf.ConfVars.BYTESPERREDUCER.varname + "=<number>");
            this.console.printInfo("In order to limit the maximum number of reducers:");
            this.console.printInfo("  set " + HiveConf.ConfVars.MAXREDUCERS.varname + "=<number>");
            this.console.printInfo("In order to set a constant number of reducers:");
            this.console.printInfo("  set " + (Object)((Object)HiveConf.ConfVars.HADOOPNUMREDUCERS) + "=<number>");
        }
    }

    public static String isEligibleForLocalMode(HiveConf conf, int numReducers, long inputLength, long inputFileCount) {
        long maxBytes = conf.getLongVar(HiveConf.ConfVars.LOCALMODEMAXBYTES);
        long maxInputFiles = conf.getIntVar(HiveConf.ConfVars.LOCALMODEMAXINPUTFILES);
        if (inputLength > maxBytes) {
            return "Input Size (= " + inputLength + ") is larger than " + HiveConf.ConfVars.LOCALMODEMAXBYTES.varname + " (= " + maxBytes + ")";
        }
        if (inputFileCount > maxInputFiles) {
            return "Number of Input Files (= " + inputFileCount + ") is larger than " + HiveConf.ConfVars.LOCALMODEMAXINPUTFILES.varname + "(= " + maxInputFiles + ")";
        }
        if (numReducers > 1) {
            return "Number of reducers (= " + numReducers + ") is more than 1";
        }
        return null;
    }

    @Override
    public Operator<? extends OperatorDesc> getReducer(MapWork mapWork) {
        if (((MapredWork)this.getWork()).getMapWork() == mapWork) {
            return ((MapredWork)this.getWork()).getReduceWork() == null ? null : ((MapredWork)this.getWork()).getReduceWork().getReducer();
        }
        return null;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.executor != null) {
            this.executor.destroy();
            this.executor = null;
        }
    }
}

