/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.parse;

import org.antlr.runtime.tree.Tree;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNodeOrigin;
import org.apache.hadoop.hive.ql.ErrorMsg;

public class HiveParserErrorMsg {
    private static final String LINE_SEP = System.getProperty("line.separator");

    private HiveParserErrorMsg() {
    }

    public static String getMsg(ErrorMsg errorMsg, HiveParserASTNode tree, String reason) {
        return HiveParserErrorMsg.getMsg(errorMsg, tree) + ": " + reason;
    }

    public static String getMsg(ErrorMsg errorMsg, Tree tree, String reason) {
        return HiveParserErrorMsg.getMsg(errorMsg, (HiveParserASTNode)tree, reason);
    }

    public static String getMsg(ErrorMsg errorMsg, Tree tree) {
        return HiveParserErrorMsg.getMsg(errorMsg, (HiveParserASTNode)tree);
    }

    public static String getMsg(ErrorMsg errorMsg, HiveParserASTNode astNode) {
        StringBuilder sb = new StringBuilder();
        HiveParserErrorMsg.renderPosition(sb, astNode);
        sb.append(" ");
        sb.append(errorMsg.getMsg());
        sb.append(" '");
        sb.append(HiveParserErrorMsg.getText(astNode));
        sb.append("'");
        HiveParserErrorMsg.renderOrigin(sb, astNode.getOrigin());
        return sb.toString();
    }

    private static void renderPosition(StringBuilder sb, HiveParserASTNode tree) {
        sb.append("Line ");
        sb.append(HiveParserErrorMsg.getLine(tree));
        sb.append(":");
        sb.append(HiveParserErrorMsg.getCharPositionInLine(tree));
    }

    private static String getText(HiveParserASTNode tree) {
        if (tree.getChildCount() == 0) {
            return tree.getText();
        }
        return HiveParserErrorMsg.getText((HiveParserASTNode)tree.getChild(tree.getChildCount() - 1));
    }

    private static void renderOrigin(StringBuilder sb, HiveParserASTNodeOrigin origin) {
        while (origin != null) {
            sb.append(" in definition of ");
            sb.append(origin.getObjectType());
            sb.append(" ");
            sb.append(origin.getObjectName());
            sb.append(" [");
            sb.append(LINE_SEP);
            sb.append(origin.getObjectDefinition());
            sb.append(LINE_SEP);
            sb.append("] used as ");
            sb.append(origin.getUsageAlias());
            sb.append(" at ");
            HiveParserASTNode usageNode = origin.getUsageNode();
            HiveParserErrorMsg.renderPosition(sb, usageNode);
            origin = usageNode.getOrigin();
        }
    }

    private static int getLine(HiveParserASTNode tree) {
        if (tree.getChildCount() == 0) {
            return tree.getToken().getLine();
        }
        return HiveParserErrorMsg.getLine((HiveParserASTNode)tree.getChild(0));
    }

    private static int getCharPositionInLine(HiveParserASTNode tree) {
        if (tree.getChildCount() == 0) {
            return tree.getToken().getCharPositionInLine();
        }
        return HiveParserErrorMsg.getCharPositionInLine((HiveParserASTNode)tree.getChild(0));
    }
}

