/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.tree.CommonTree;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserAuthorizationParseUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQueryState;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserStorageFormat;
import org.apache.flink.table.planner.delegation.hive.desc.CreateTableASDesc;
import org.apache.flink.table.planner.delegation.hive.desc.DropPartitionDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserAlterDatabaseDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserAlterTableDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserCreateTableDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserCreateViewDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserDropDatabaseDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserDropFunctionDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserDropTableDesc;
import org.apache.flink.table.planner.delegation.hive.desc.HiveParserShowTablesDesc;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropFunctionDesc;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserDDLSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserDDLSemanticAnalyzer.class);
    private static final Map<Integer, String> TokenToTypeName = new HashMap<Integer, String>();
    private final Set<String> reservedPartitionValues;
    private final HiveConf conf;
    private final HiveParserQueryState queryState;
    private final HiveCatalog hiveCatalog;
    private final String currentDB;

    public static String getTypeName(HiveParserASTNode node) throws SemanticException {
        String typeName;
        int token = node.getType();
        if (token == 727) {
            throw new ValidationException(ErrorMsg.UNSUPPORTED_TYPE.getMsg());
        }
        switch (token) {
            case 703: {
                CharTypeInfo charTypeInfo = HiveASTParseUtils.getCharTypeInfo(node);
                typeName = charTypeInfo.getQualifiedName();
                break;
            }
            case 1014: {
                VarcharTypeInfo varcharTypeInfo = HiveASTParseUtils.getVarcharTypeInfo(node);
                typeName = varcharTypeInfo.getQualifiedName();
                break;
            }
            case 730: {
                DecimalTypeInfo decTypeInfo = HiveASTParseUtils.getDecimalTypeTypeInfo(node);
                typeName = decTypeInfo.getQualifiedName();
                break;
            }
            default: {
                typeName = TokenToTypeName.get(token);
            }
        }
        return typeName;
    }

    public HiveParserDDLSemanticAnalyzer(HiveParserQueryState queryState, HiveCatalog hiveCatalog, String currentDB) throws SemanticException {
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.hiveCatalog = hiveCatalog;
        this.currentDB = currentDB;
        this.reservedPartitionValues = new HashSet<String>();
        this.reservedPartitionValues.add(HiveConf.getVar(this.conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME));
        this.reservedPartitionValues.add(HiveConf.getVar(this.conf, HiveConf.ConfVars.DEFAULT_ZOOKEEPER_PARTITION_NAME));
        this.reservedPartitionValues.add(HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL));
        this.reservedPartitionValues.add(HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED));
        this.reservedPartitionValues.add(HiveConf.getVar(this.conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED));
    }

    private Table getTable(String tableName) throws SemanticException {
        return this.getTable(this.toObjectPath(tableName));
    }

    private Table getTable(ObjectPath tablePath) {
        try {
            return new Table(this.hiveCatalog.getHiveTable(tablePath));
        }
        catch (TableNotExistException e) {
            throw new ValidationException("Table not found", (Throwable)e);
        }
    }

    private ObjectPath toObjectPath(String name) throws SemanticException {
        String[] parts = Utilities.getDbTableName(this.currentDB, name);
        return new ObjectPath(parts[0], parts[1]);
    }

    private HashSet<ReadEntity> getInputs() {
        return new HashSet<ReadEntity>();
    }

    private HashSet<WriteEntity> getOutputs() {
        return new HashSet<WriteEntity>();
    }

    public Serializable analyzeInternal(HiveParserASTNode input) throws SemanticException {
        HiveParserASTNode ast = input;
        Serializable res = null;
        switch (ast.getType()) {
            case 658: {
                ast = (HiveParserASTNode)input.getChild(1);
                String[] qualified = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)input.getChild(0));
                String tableName = HiveParserBaseSemanticAnalyzer.getDotName(qualified);
                HashMap<String, String> partSpec = null;
                HiveParserASTNode partSpecNode = (HiveParserASTNode)input.getChild(2);
                if (partSpecNode != null) {
                    partSpec = HiveParserDDLSemanticAnalyzer.getPartSpec(partSpecNode);
                }
                if (ast.getType() == 676) {
                    res = this.analyzeAlterTableRename(qualified, ast, false);
                    break;
                }
                if (ast.getType() == 684) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getType() == 662) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getType() == 685) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getType() == 659) {
                    res = this.analyzeAlterTableModifyCols(qualified, ast, partSpec, false);
                    break;
                }
                if (ast.getType() == 679) {
                    res = this.analyzeAlterTableModifyCols(qualified, ast, partSpec, true);
                    break;
                }
                if (ast.getType() == 677) {
                    res = this.analyzeAlterTableRenameCol(qualified, ast, partSpec);
                    break;
                }
                if (ast.getType() == 661) {
                    res = this.analyzeAlterTableAddParts(qualified, ast, false);
                    break;
                }
                if (ast.getType() == 668) {
                    res = this.analyzeAlterTableDropParts(qualified, ast, false);
                    break;
                }
                if (ast.getType() == 674) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getType() == 675) {
                    res = this.analyzeAlterTableProps(qualified, null, ast, false, false);
                    break;
                }
                if (ast.getType() == 669) {
                    res = this.analyzeAlterTableProps(qualified, null, ast, false, true);
                    break;
                }
                if (ast.getType() == 687) {
                    res = this.analyzeAlterTableProps(qualified, partSpec, ast, false, false);
                    break;
                }
                if (ast.getType() == 682) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getType() == 670) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getToken().getType() == 671) {
                    res = this.analyzeAlterTableFileFormat(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 672) {
                    res = this.analyzeAlterTableLocation(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 673) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getToken().getType() == 681) {
                    res = this.analyzeAlterTableSerde(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 680) {
                    res = this.analyzeAlterTableSerdeProps(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 678) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getToken().getType() == 683) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getToken().getType() == 663) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getToken().getType() == 665) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getToken().getType() == 666) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getToken().getType() == 686) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getToken().getType() == 667) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                if (ast.getToken().getType() == 660) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
                    break;
                }
                throw new ValidationException("Unknown AST node for ALTER TABLE: " + ast);
            }
            case 748: {
                res = this.analyzeDropTable(ast, null);
                break;
            }
            case 736: {
                res = this.analyzeDescribeTable(ast);
                break;
            }
            case 915: {
                res = this.analyzeShowDatabases(ast);
                break;
            }
            case 921: {
                res = this.analyzeShowTables(ast, false);
                break;
            }
            case 917: {
                res = this.analyzeShowFunctions(ast);
                break;
            }
            case 922: {
                res = this.analyzeShowTables(ast, true);
                break;
            }
            case 735: {
                res = this.analyzeDescFunction(ast);
                break;
            }
            case 734: {
                res = this.analyzeDescDatabase(ast);
                break;
            }
            case 749: {
                res = this.analyzeDropTable(ast, TableType.VIRTUAL_VIEW);
                break;
            }
            case 688: {
                if (ast.getChild(1).getType() == 880) {
                    res = this.analyzeCreateView(ast);
                    break;
                }
                String[] qualified = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)ast.getChild(0));
                if ((ast = (HiveParserASTNode)ast.getChild(1)).getType() == 692) {
                    res = this.analyzeAlterTableProps(qualified, null, ast, true, false);
                    break;
                }
                if (ast.getType() == 691) {
                    res = this.analyzeAlterTableProps(qualified, null, ast, true, true);
                    break;
                }
                if (ast.getType() == 689) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("ADD PARTITION for view is not supported");
                    break;
                }
                if (ast.getType() == 690) {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("DROP PARTITION for view is not supported");
                    break;
                }
                if (ast.getType() == 693) {
                    res = this.analyzeAlterTableRename(qualified, ast, true);
                    break;
                }
                throw new ValidationException("Unknown AST node for ALTER VIEW: " + ast);
            }
            case 920: {
                res = this.analyzeShowPartitions(ast);
                break;
            }
            case 710: {
                res = this.analyzeCreateDatabase(ast);
                break;
            }
            case 743: {
                res = this.analyzeDropDatabase(ast);
                break;
            }
            case 951: {
                res = this.analyzeSwitchDatabase(ast);
                break;
            }
            case 655: {
                res = this.analyzeAlterDatabaseProperties(ast);
                break;
            }
            case 654: {
                res = this.analyzeAlterDatabaseOwner(ast);
                break;
            }
            case 653: {
                res = this.analyzeAlterDatabaseLocation(ast);
                break;
            }
            case 716: {
                res = this.analyzeCreateTable(ast);
                break;
            }
            case 717: {
                res = this.analyzeCreateView(ast);
                break;
            }
            case 711: {
                res = this.analyzerCreateFunction(ast);
                break;
            }
            case 744: {
                res = this.analyzeDropFunction(ast);
                break;
            }
            default: {
                HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation(ast);
            }
        }
        return res;
    }

    private Serializable analyzeDropFunction(HiveParserASTNode ast) {
        String functionName = ast.getChild(0).getText();
        boolean ifExists = ast.getFirstChildWithType(779) != null;
        boolean isTemporaryFunction = ast.getFirstChildWithType(986) != null;
        DropFunctionDesc desc = new DropFunctionDesc();
        desc.setFunctionName(functionName);
        desc.setTemp(isTemporaryFunction);
        return new HiveParserDropFunctionDesc(desc, ifExists);
    }

    private Serializable analyzerCreateFunction(HiveParserASTNode ast) {
        String functionName = ast.getChild(0).getText().toLowerCase();
        boolean isTemporaryFunction = ast.getFirstChildWithType(986) != null;
        String className = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        if (isTemporaryFunction && FunctionUtils.isQualifiedFunctionName(functionName)) {
            throw new ValidationException("Temporary function cannot be created with a qualified name.");
        }
        CreateFunctionDesc desc = new CreateFunctionDesc();
        desc.setFunctionName(functionName);
        desc.setTemp(isTemporaryFunction);
        desc.setClassName(className);
        desc.setResources(Collections.emptyList());
        return new FunctionWork(desc);
    }

    private Serializable analyzeCreateView(HiveParserASTNode ast) throws SemanticException {
        boolean isMaterialized;
        String[] qualTabName = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)ast.getChild(0));
        String dbDotTable = HiveParserBaseSemanticAnalyzer.getDotName(qualTabName);
        List<FieldSchema> cols = null;
        boolean ifNotExists = false;
        boolean isAlterViewAs = false;
        String comment = null;
        HiveParserASTNode selectStmt = null;
        HashMap<String, String> tblProps = null;
        boolean bl = isMaterialized = ast.getToken().getType() == 718;
        if (isMaterialized) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("MATERIALIZED VIEW is not supported");
        }
        HiveParserBaseSemanticAnalyzer.HiveParserRowFormatParams rowFormatParams = new HiveParserBaseSemanticAnalyzer.HiveParserRowFormatParams();
        HiveParserStorageFormat storageFormat = new HiveParserStorageFormat(this.conf);
        LOG.info("Creating view " + dbDotTable + " position=" + ast.getCharPositionInLine());
        int numCh = ast.getChildCount();
        block13: for (int num = 1; num < numCh; ++num) {
            HiveParserASTNode child = (HiveParserASTNode)ast.getChild(num);
            if (storageFormat.fillStorageFormat(child)) {
                HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("FILE FORMAT for view is not supported");
            }
            switch (child.getToken().getType()) {
                case 780: {
                    ifNotExists = true;
                    continue block13;
                }
                case 897: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("MATERIALIZED VIEW REWRITE is not supported");
                    continue block13;
                }
                case 856: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("CREATE OR REPLACE VIEW is not supported");
                    continue block13;
                }
                case 880: {
                    selectStmt = child;
                    continue block13;
                }
                case 956: {
                    cols = HiveParserBaseSemanticAnalyzer.getColumns(child);
                    continue block13;
                }
                case 961: {
                    comment = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block13;
                }
                case 965: {
                    tblProps = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)child.getChild(0));
                    continue block13;
                }
                case 968: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("ROW FORMAT for view is not supported");
                    continue block13;
                }
                case 974: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("SERDE for view is not supported");
                    continue block13;
                }
                case 963: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("LOCATION for view is not supported");
                    continue block13;
                }
                case 1015: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("PARTITION COLUMN for view is not supported");
                    continue block13;
                }
                default: {
                    throw new ValidationException("Unknown AST node for CREATE/ALTER VIEW: " + child);
                }
            }
        }
        if (ast.getToken().getType() == 688 && ast.getChild(1).getType() == 880) {
            isAlterViewAs = true;
        }
        this.queryState.setCommandType(HiveOperation.CREATEVIEW);
        return new HiveParserCreateViewDesc(dbDotTable, cols, comment, tblProps, ifNotExists, isAlterViewAs, selectStmt);
    }

    private Serializable analyzeCreateTable(HiveParserASTNode ast) throws SemanticException {
        String[] qualifiedTabName = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)ast.getChild(0));
        String dbDotTab = HiveParserBaseSemanticAnalyzer.getDotName(qualifiedTabName);
        List<Object> cols = new ArrayList();
        ArrayList<FieldSchema> partCols = new ArrayList();
        ArrayList<HiveParserCreateTableDesc.PrimaryKey> primaryKeys = new ArrayList<HiveParserCreateTableDesc.PrimaryKey>();
        ArrayList<HiveParserCreateTableDesc.NotNullConstraint> notNulls = new ArrayList<HiveParserCreateTableDesc.NotNullConstraint>();
        String comment = null;
        String location = null;
        Map<String, String> tblProps = null;
        boolean ifNotExists = false;
        boolean isExt = false;
        boolean isTemporary = false;
        HiveParserASTNode selectStmt = null;
        boolean createTable = false;
        boolean ctlt = true;
        int ctas = 2;
        int commandType = 0;
        HiveParserBaseSemanticAnalyzer.HiveParserRowFormatParams rowFormatParams = new HiveParserBaseSemanticAnalyzer.HiveParserRowFormatParams();
        HiveParserStorageFormat storageFormat = new HiveParserStorageFormat(this.conf);
        LOG.info("Creating table " + dbDotTab + " position=" + ast.getCharPositionInLine());
        int numCh = ast.getChildCount();
        block21: for (int num = 1; num < numCh; ++num) {
            HiveParserASTNode child = (HiveParserASTNode)ast.getChild(num);
            if (storageFormat.fillStorageFormat(child)) continue;
            switch (child.getToken().getType()) {
                case 780: {
                    ifNotExists = true;
                    continue block21;
                }
                case 115: {
                    isExt = true;
                    continue block21;
                }
                case 284: {
                    isTemporary = true;
                    continue block21;
                }
                case 811: {
                    if (child.getChildCount() <= 0) continue block21;
                    String likeTableName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)child.getChild(0));
                    if (likeTableName != null) {
                        if (commandType == 2) {
                            throw new ValidationException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                        }
                        if (cols.size() != 0) {
                            throw new ValidationException(ErrorMsg.CTLT_COLLST_COEXISTENCE.getMsg());
                        }
                    }
                    commandType = 1;
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("CREATE TABLE LIKE is not supported");
                    continue block21;
                }
                case 880: {
                    if (commandType == 1) {
                        throw new ValidationException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                    }
                    if (cols.size() != 0) {
                        throw new ValidationException(ErrorMsg.CTAS_COLLST_COEXISTENCE.getMsg());
                    }
                    if (partCols.size() != 0) {
                        throw new ValidationException(ErrorMsg.CTAS_PARCOL_COEXISTENCE.getMsg());
                    }
                    if (isExt) {
                        throw new ValidationException(ErrorMsg.CTAS_EXTTBL_COEXISTENCE.getMsg());
                    }
                    commandType = 2;
                    selectStmt = child;
                    continue block21;
                }
                case 955: {
                    cols = HiveParserBaseSemanticAnalyzer.getColumns(child, true, primaryKeys, notNulls);
                    continue block21;
                }
                case 961: {
                    comment = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block21;
                }
                case 964: {
                    partCols = HiveParserBaseSemanticAnalyzer.getColumns((HiveParserASTNode)child.getChild(0), false);
                    continue block21;
                }
                case 968: {
                    rowFormatParams.analyzeRowFormat(child);
                    continue block21;
                }
                case 963: {
                    location = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    location = EximUtil.relativeToAbsolutePath(this.conf, location);
                    continue block21;
                }
                case 965: {
                    tblProps = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)child.getChild(0));
                    continue block21;
                }
                case 974: {
                    child = (HiveParserASTNode)child.getChild(0);
                    storageFormat.setSerde(HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                    if (child.getChildCount() != 2) continue block21;
                    HiveParserBaseSemanticAnalyzer.readProps((HiveParserASTNode)child.getChild(1).getChild(0), storageFormat.getSerdeProps());
                    continue block21;
                }
                case 663: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Bucketed table is not supported");
                    continue block21;
                }
                case 975: {
                    HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Skewed table is not supported");
                    continue block21;
                }
                default: {
                    throw new ValidationException("Unknown AST node for CREATE TABLE: " + child);
                }
            }
        }
        if (storageFormat.getStorageHandler() != null) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Storage handler table is not supported");
        }
        if (commandType == 0 || commandType == 1) {
            this.queryState.setCommandType(HiveOperation.CREATETABLE);
        } else {
            this.queryState.setCommandType(HiveOperation.CREATETABLE_AS_SELECT);
        }
        storageFormat.fillDefaultStorageFormat(isExt, false);
        if (isTemporary) {
            if (partCols.size() > 0) {
                HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Partition columns are not supported on temporary tables");
            }
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Temporary hive table is not supported");
        }
        switch (commandType) {
            case 0: {
                tblProps = this.addDefaultProperties(tblProps);
                return new HiveParserCreateTableDesc(dbDotTab, isExt, ifNotExists, isTemporary, cols, partCols, comment, location, tblProps, rowFormatParams, storageFormat, primaryKeys, notNulls);
            }
            case 1: {
                tblProps = this.addDefaultProperties(tblProps);
                throw new SemanticException("CREATE TABLE LIKE is not supported yet");
            }
            case 2: {
                tblProps = this.addDefaultProperties(tblProps);
                HiveParserCreateTableDesc createTableDesc = new HiveParserCreateTableDesc(dbDotTab, isExt, ifNotExists, isTemporary, cols, partCols, comment, location, tblProps, rowFormatParams, storageFormat, primaryKeys, notNulls);
                return new CreateTableASDesc(createTableDesc, selectStmt);
            }
        }
        throw new ValidationException("Unrecognized command.");
    }

    private Serializable analyzeAlterDatabaseProperties(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> dbProps = null;
        block3: for (int i = 1; i < ast.getChildCount(); ++i) {
            HiveParserASTNode childNode = (HiveParserASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 724: {
                    dbProps = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)childNode.getChild(0));
                    continue block3;
                }
                default: {
                    throw new ValidationException("Unknown AST node for ALTER DATABASE PROPERTIES: " + childNode);
                }
            }
        }
        return HiveParserAlterDatabaseDesc.alterProps(dbName, dbProps);
    }

    private Serializable analyzeAlterDatabaseOwner(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0));
        PrincipalDesc principalDesc = HiveParserAuthorizationParseUtils.getPrincipalDesc((HiveParserASTNode)ast.getChild(1));
        String nullCmdMsg = "can't be null in alter database set owner command";
        if (principalDesc.getName() == null) {
            throw new ValidationException("Owner name " + nullCmdMsg);
        }
        if (principalDesc.getType() == null) {
            throw new ValidationException("Owner type " + nullCmdMsg);
        }
        return HiveParserAlterDatabaseDesc.alterOwner(dbName, principalDesc);
    }

    private Serializable analyzeAlterDatabaseLocation(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0));
        String newLocation = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        return HiveParserAlterDatabaseDesc.alterLocation(dbName, newLocation);
    }

    private Serializable analyzeCreateDatabase(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifNotExists = false;
        String dbComment = null;
        String dbLocation = null;
        HashMap<String, String> dbProps = null;
        block6: for (int i = 1; i < ast.getChildCount(); ++i) {
            HiveParserASTNode childNode = (HiveParserASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 780: {
                    ifNotExists = true;
                    continue block6;
                }
                case 722: {
                    dbComment = HiveParserBaseSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block6;
                }
                case 724: {
                    dbProps = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)childNode.getChild(0));
                    continue block6;
                }
                case 723: {
                    dbLocation = HiveParserBaseSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block6;
                }
                default: {
                    throw new ValidationException("Unknown AST node for CREATE DATABASE: " + childNode);
                }
            }
        }
        CreateDatabaseDesc createDatabaseDesc = new CreateDatabaseDesc(dbName, dbComment, dbLocation, ifNotExists);
        if (dbProps != null) {
            createDatabaseDesc.setDatabaseProperties(dbProps);
        }
        return new DDLWork(this.getInputs(), this.getOutputs(), createDatabaseDesc);
    }

    private Serializable analyzeDropDatabase(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifExists = false;
        boolean ifCascade = false;
        if (null != ast.getFirstChildWithType(779)) {
            ifExists = true;
        }
        if (null != ast.getFirstChildWithType(702)) {
            ifCascade = true;
        }
        return new HiveParserDropDatabaseDesc(dbName, ifExists, ifCascade);
    }

    private Serializable analyzeSwitchDatabase(HiveParserASTNode ast) {
        String dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        SwitchDatabaseDesc switchDatabaseDesc = new SwitchDatabaseDesc(dbName);
        return new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), switchDatabaseDesc);
    }

    private Serializable analyzeDropTable(HiveParserASTNode ast, TableType expectedType) {
        String tableName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0));
        boolean ifExists = ast.getFirstChildWithType(779) != null;
        boolean ifPurge = ast.getFirstChildWithType(224) != null;
        return new HiveParserDropTableDesc(tableName, expectedType == TableType.VIRTUAL_VIEW, ifExists, ifPurge);
    }

    private void validateAlterTableType(Table tbl, AlterTableDesc.AlterTableTypes op, boolean expectView) {
        block7: {
            block6: {
                if (!tbl.isView()) break block6;
                if (!expectView) {
                    throw new ValidationException(ErrorMsg.ALTER_COMMAND_FOR_VIEWS.getMsg());
                }
                switch (op) {
                    case ADDPARTITION: 
                    case DROPPARTITION: 
                    case RENAMEPARTITION: 
                    case ADDPROPS: 
                    case DROPPROPS: 
                    case RENAME: {
                        break block7;
                    }
                    default: {
                        throw new ValidationException(ErrorMsg.ALTER_VIEW_DISALLOWED_OP.getMsg(op.toString()));
                    }
                }
            }
            if (expectView) {
                throw new ValidationException(ErrorMsg.ALTER_COMMAND_FOR_TABLES.getMsg());
            }
        }
        if (tbl.isNonNative()) {
            throw new ValidationException(ErrorMsg.ALTER_TABLE_NON_NATIVE.getMsg(tbl.getTableName()));
        }
    }

    private Serializable analyzeAlterTableProps(String[] qualified, HashMap<String, String> partSpec, HiveParserASTNode ast, boolean expectView, boolean isUnset) throws SemanticException {
        String tableName = HiveParserBaseSemanticAnalyzer.getDotName(qualified);
        HashMap<String, String> mapProp = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)ast.getChild(0).getChild(0));
        for (Map.Entry<String, String> entry : mapProp.entrySet()) {
            if (entry.getKey().equals("numRows") || entry.getKey().equals("rawDataSize")) {
                try {
                    Long.parseLong(entry.getValue());
                    continue;
                }
                catch (Exception e) {
                    throw new ValidationException("AlterTable " + entry.getKey() + " failed with value " + entry.getValue());
                }
            }
            if (!HiveOperation.ALTERTABLE_UPDATETABLESTATS.getOperationName().equals(this.queryState.getCommandType()) && !HiveOperation.ALTERTABLE_UPDATEPARTSTATS.getOperationName().equals(this.queryState.getCommandType())) continue;
            throw new ValidationException("AlterTable UpdateStats " + entry.getKey() + " failed because the only valid keys are " + "numRows" + " and " + "rawDataSize");
        }
        HiveParserAlterTableDesc alterTblDesc = null;
        if (isUnset) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("Unset properties not supported");
        } else {
            alterTblDesc = HiveParserAlterTableDesc.alterTableProps(tableName, partSpec, mapProp, expectView);
        }
        return alterTblDesc;
    }

    private Serializable analyzeAlterTableSerdeProps(HiveParserASTNode ast, String tableName, HashMap<String, String> partSpec) {
        HashMap<String, String> mapProp = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)ast.getChild(0).getChild(0));
        return HiveParserAlterTableDesc.alterSerDe(tableName, partSpec, null, mapProp);
    }

    private Serializable analyzeAlterTableSerde(HiveParserASTNode ast, String tableName, HashMap<String, String> partSpec) {
        String serdeName = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        HashMap<String, String> mapProp = null;
        if (ast.getChildCount() > 1) {
            mapProp = HiveParserDDLSemanticAnalyzer.getProps((HiveParserASTNode)ast.getChild(1).getChild(0));
        }
        return HiveParserAlterTableDesc.alterSerDe(tableName, partSpec, serdeName, mapProp);
    }

    private Serializable analyzeAlterTableFileFormat(HiveParserASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        HiveParserStorageFormat format = new HiveParserStorageFormat(this.conf);
        HiveParserASTNode child = (HiveParserASTNode)ast.getChild(0);
        if (!format.fillStorageFormat(child)) {
            throw new ValidationException("Unknown AST node for ALTER TABLE FILEFORMAT: " + child);
        }
        HiveParserAlterTableDesc alterTblDesc = HiveParserAlterTableDesc.alterFileFormat(tableName, partSpec);
        alterTblDesc.setGenericFileFormatName(format.getGenericName());
        return alterTblDesc;
    }

    private Serializable analyzeAlterTableLocation(HiveParserASTNode ast, String tableName, HashMap<String, String> partSpec) {
        String newLocation = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        return HiveParserAlterTableDesc.alterLocation(tableName, partSpec, newLocation);
    }

    public static HashMap<String, String> getProps(HiveParserASTNode prop) {
        LinkedHashMap<String, String> mapProp = new LinkedHashMap<String, String>();
        HiveParserBaseSemanticAnalyzer.readProps(prop, mapProp);
        return mapProp;
    }

    private void validateTable(String tableName, Map<String, String> partSpec) throws SemanticException {
        Table tab = this.getTable(tableName);
        if (partSpec != null) {
            this.getPartition(tab, partSpec);
        }
    }

    private void getPartition(Table table, Map<String, String> partSpec) {
        try {
            this.hiveCatalog.getPartition(new ObjectPath(table.getDbName(), table.getTableName()), new CatalogPartitionSpec(partSpec));
        }
        catch (PartitionNotExistException e) {
            throw new ValidationException("Partition not found", (Throwable)e);
        }
    }

    private Serializable analyzeDescribeTable(HiveParserASTNode ast) throws SemanticException {
        String tableName;
        HiveParserASTNode tableTypeExpr = (HiveParserASTNode)ast.getChild(0);
        String dbName = null;
        if (tableTypeExpr.getChild(0).getType() == 980) {
            HiveParserASTNode tableNode = (HiveParserASTNode)tableTypeExpr.getChild(0);
            if (tableNode.getChildCount() == 1) {
                tableName = tableNode.getChild(0).getText();
            } else {
                dbName = tableNode.getChild(0).getText();
                tableName = dbName + "." + tableNode.getChild(1).getText();
            }
        } else {
            throw new ValidationException(tableTypeExpr.getChild(0).getText() + " is not an expected token type");
        }
        Map<String, String> partSpec = QualifiedNameUtil.getPartitionSpec(this.hiveCatalog, tableTypeExpr, this.toObjectPath(tableName));
        String colPath = QualifiedNameUtil.getColPath(tableTypeExpr, dbName, tableName, partSpec);
        if (partSpec != null) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("DESCRIBE PARTITION is not supported");
        }
        if (!colPath.equals(tableName)) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("DESCRIBE COLUMNS is not supported");
        }
        DescTableDesc descTblDesc = new DescTableDesc(this.getResFile(), tableName, partSpec, colPath);
        if (ast.getChildCount() == 2) {
            int descOptions = ast.getChild(1).getType();
            descTblDesc.setFormatted(descOptions == 129);
            descTblDesc.setExt(descOptions == 114);
            if (descOptions == 220) {
                HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("DESCRIBE PRETTY is not supported.");
            }
        }
        return new DDLWork(this.getInputs(), this.getOutputs(), descTblDesc);
    }

    private Serializable analyzeDescDatabase(HiveParserASTNode ast) {
        boolean isExtended;
        String dbName;
        if (ast.getChildCount() == 1) {
            dbName = HiveParserBaseSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            dbName = HiveParserBaseSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new ValidationException("Unexpected Tokens at DESCRIBE DATABASE");
        }
        DescDatabaseDesc descDbDesc = new DescDatabaseDesc(this.getResFile(), dbName, isExtended);
        return new DDLWork(this.getInputs(), this.getOutputs(), descDbDesc);
    }

    public static HashMap<String, String> getPartSpec(HiveParserASTNode partspec) {
        if (partspec == null) {
            return null;
        }
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partspec.getChildCount(); ++i) {
            HiveParserASTNode partVal = (HiveParserASTNode)partspec.getChild(i);
            String key = partVal.getChild(0).getText();
            String val = null;
            if (partVal.getChildCount() == 3) {
                val = HiveParserBaseSemanticAnalyzer.stripQuotes(partVal.getChild(2).getText());
            } else if (partVal.getChildCount() == 2) {
                val = HiveParserBaseSemanticAnalyzer.stripQuotes(partVal.getChild(1).getText());
            }
            partSpec.put(key.toLowerCase(), val);
        }
        return partSpec;
    }

    private Serializable analyzeShowPartitions(HiveParserASTNode ast) throws SemanticException {
        String tableName = HiveParserBaseSemanticAnalyzer.getUnescapedName((HiveParserASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        this.validateTable(tableName, null);
        ShowPartitionsDesc showPartsDesc = new ShowPartitionsDesc(tableName, this.getResFile(), partSpec);
        return new DDLWork(this.getInputs(), this.getOutputs(), showPartsDesc);
    }

    private Serializable analyzeShowDatabases(HiveParserASTNode ast) {
        ShowDatabasesDesc showDatabasesDesc;
        if (ast.getChildCount() == 1) {
            String databasePattern = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
            showDatabasesDesc = new ShowDatabasesDesc(this.getResFile(), databasePattern);
        } else {
            showDatabasesDesc = new ShowDatabasesDesc(this.getResFile());
        }
        return new DDLWork(this.getInputs(), this.getOutputs(), showDatabasesDesc);
    }

    private Serializable analyzeShowTables(HiveParserASTNode ast, boolean expectView) {
        String dbName = this.currentDB;
        String pattern = null;
        if (ast.getChildCount() > 3) {
            throw new ValidationException("Internal error : Invalid AST " + ast.toStringTree());
        }
        switch (ast.getChildCount()) {
            case 1: {
                pattern = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
                break;
            }
            case 2: {
                assert (ast.getChild(0).getType() == 764);
                dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                break;
            }
            case 3: {
                assert (ast.getChild(0).getType() == 764);
                dbName = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                pattern = HiveParserBaseSemanticAnalyzer.unescapeSQLString(ast.getChild(2).getText());
                break;
            }
        }
        if (!dbName.equalsIgnoreCase(this.currentDB)) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("SHOW TABLES/VIEWS IN DATABASE is not supported");
        }
        if (pattern != null) {
            HiveParserDDLSemanticAnalyzer.handleUnsupportedOperation("SHOW TABLES/VIEWS LIKE is not supported");
        }
        return new HiveParserShowTablesDesc(null, dbName, expectView);
    }

    private Serializable analyzeShowFunctions(HiveParserASTNode ast) {
        ShowFunctionsDesc showFuncsDesc;
        if (ast.getChildCount() == 1) {
            String funcNames = HiveParserBaseSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            showFuncsDesc = new ShowFunctionsDesc(this.getResFile(), funcNames);
        } else {
            if (ast.getChildCount() == 2) {
                assert (ast.getChild(0).getType() == 167);
                throw new ValidationException("SHOW FUNCTIONS LIKE is not supported yet");
            }
            showFuncsDesc = new ShowFunctionsDesc(this.getResFile());
        }
        return new DDLWork(this.getInputs(), this.getOutputs(), showFuncsDesc);
    }

    private Serializable analyzeDescFunction(HiveParserASTNode ast) {
        boolean isExtended;
        String funcName;
        if (ast.getChildCount() == 1) {
            funcName = HiveParserBaseSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            funcName = HiveParserBaseSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new ValidationException("Unexpected Tokens at DESCRIBE FUNCTION");
        }
        DescFunctionDesc descFuncDesc = new DescFunctionDesc(this.getResFile(), funcName, isExtended);
        return new DDLWork(this.getInputs(), this.getOutputs(), descFuncDesc);
    }

    private Serializable analyzeAlterTableRename(String[] source, HiveParserASTNode ast, boolean expectView) throws SemanticException {
        String[] target = HiveParserBaseSemanticAnalyzer.getQualifiedTableName((HiveParserASTNode)ast.getChild(0));
        String sourceName = HiveParserBaseSemanticAnalyzer.getDotName(source);
        String targetName = HiveParserBaseSemanticAnalyzer.getDotName(target);
        return HiveParserAlterTableDesc.rename(sourceName, targetName, expectView);
    }

    private Serializable analyzeAlterTableRenameCol(String[] qualified, HiveParserASTNode ast, HashMap<String, String> partSpec) throws SemanticException {
        String newComment = null;
        boolean first = false;
        String flagCol = null;
        boolean isCascade = false;
        String oldColName = ast.getChild(0).getText();
        String newColName = ast.getChild(1).getText();
        String newType = HiveParserBaseSemanticAnalyzer.getTypeStringFromAST((HiveParserASTNode)ast.getChild(2));
        int childCount = ast.getChildCount();
        block7: for (int i = 3; i < childCount; ++i) {
            HiveParserASTNode child = (HiveParserASTNode)ast.getChild(i);
            switch (child.getToken().getType()) {
                case 353: {
                    newComment = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getText());
                    continue block7;
                }
                case 664: {
                    flagCol = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    continue block7;
                }
                case 122: {
                    first = true;
                    continue block7;
                }
                case 702: {
                    isCascade = true;
                    continue block7;
                }
                case 893: {
                    continue block7;
                }
                default: {
                    throw new ValidationException("Unsupported token: " + child.getToken() + " for alter table");
                }
            }
        }
        Table tab = this.getTable(new ObjectPath(qualified[0], qualified[1]));
        SkewedInfo skewInfo = tab.getTTable().getSd().getSkewedInfo();
        if (null != skewInfo && null != skewInfo.getSkewedColNames() && skewInfo.getSkewedColNames().contains(oldColName)) {
            throw new ValidationException(oldColName + ErrorMsg.ALTER_TABLE_NOT_ALLOWED_RENAME_SKEWED_COLUMN.getMsg());
        }
        String tblName = HiveParserBaseSemanticAnalyzer.getDotName(qualified);
        return HiveParserAlterTableDesc.changeColumn(tblName, HiveParserBaseSemanticAnalyzer.unescapeIdentifier(oldColName), HiveParserBaseSemanticAnalyzer.unescapeIdentifier(newColName), newType, newComment, first, flagCol, isCascade);
    }

    private Serializable analyzeAlterTableModifyCols(String[] qualified, HiveParserASTNode ast, HashMap<String, String> partSpec, boolean replace) throws SemanticException {
        String tblName = HiveParserBaseSemanticAnalyzer.getDotName(qualified);
        List<FieldSchema> newCols = HiveParserBaseSemanticAnalyzer.getColumns((HiveParserASTNode)ast.getChild(0));
        boolean isCascade = false;
        if (null != ast.getFirstChildWithType(702)) {
            isCascade = true;
        }
        return HiveParserAlterTableDesc.addReplaceColumns(tblName, newCols, replace, isCascade);
    }

    private Serializable analyzeAlterTableDropParts(String[] qualified, HiveParserASTNode ast, boolean expectView) {
        boolean ifExists = ast.getFirstChildWithType(779) != null;
        Table tab = this.getTable(new ObjectPath(qualified[0], qualified[1]));
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        for (int i = 0; i < ast.getChildCount(); ++i) {
            HiveParserASTNode child = (HiveParserASTNode)ast.getChild(i);
            if (child.getType() != 859) continue;
            partSpecs.add(HiveParserDDLSemanticAnalyzer.getPartSpec(child));
        }
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.DROPPARTITION, expectView);
        return new DropPartitionDesc(qualified[0], qualified[1], partSpecs, ifExists);
    }

    private Serializable analyzeAlterTableAddParts(String[] qualified, CommonTree ast, boolean expectView) throws SemanticException {
        boolean ifNotExists = ast.getChild(0).getType() == 780;
        Table tab = this.getTable(new ObjectPath(qualified[0], qualified[1]));
        boolean isView = tab.isView();
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ADDPARTITION, expectView);
        int numCh = ast.getChildCount();
        int start = ifNotExists ? 1 : 0;
        String currentLocation = null;
        HashMap<String, String> currentPart = null;
        AddPartitionDesc addPartitionDesc = new AddPartitionDesc(tab.getDbName(), tab.getTableName(), ifNotExists);
        block4: for (int num = start; num < numCh; ++num) {
            HiveParserASTNode child = (HiveParserASTNode)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 859: {
                    if (currentPart != null) {
                        addPartitionDesc.addPartition(currentPart, currentLocation);
                        currentLocation = null;
                    }
                    currentPart = HiveParserDDLSemanticAnalyzer.getPartSpec(child);
                    this.validatePartitionValues(currentPart);
                    continue block4;
                }
                case 858: {
                    if (isView) {
                        throw new ValidationException("LOCATION clause illegal for view partition");
                    }
                    currentLocation = HiveParserBaseSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block4;
                }
                default: {
                    throw new ValidationException("Unknown child: " + child);
                }
            }
        }
        if (currentPart != null) {
            addPartitionDesc.addPartition(currentPart, currentLocation);
        }
        return new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc);
    }

    private List<Map<String, String>> getPartitionSpecs(CommonTree ast) {
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        for (int childIndex = 0; childIndex < ast.getChildCount(); ++childIndex) {
            HiveParserASTNode partSpecNode = (HiveParserASTNode)ast.getChild(childIndex);
            if (partSpecNode.getType() != 859) continue;
            HashMap<String, String> partSpec = HiveParserDDLSemanticAnalyzer.getPartSpec(partSpecNode);
            partSpecs.add(partSpec);
        }
        return partSpecs;
    }

    private void validatePartitionValues(Map<String, String> partSpec) {
        for (Map.Entry<String, String> e : partSpec.entrySet()) {
            for (String s : this.reservedPartitionValues) {
                String value = e.getValue();
                if (value == null || !value.contains(s)) continue;
                throw new ValidationException(ErrorMsg.RESERVED_PART_VAL.getMsg("(User value: " + e.getValue() + " Reserved substring: " + s + ")"));
            }
        }
    }

    private Map<String, String> addDefaultProperties(Map<String, String> tblProp) {
        Map<String, String> retValue = tblProp == null ? new HashMap<String, String>() : tblProp;
        String paraString = HiveConf.getVar(this.conf, HiveConf.ConfVars.NEWTABLEDEFAULTPARA);
        if (paraString != null && !paraString.isEmpty()) {
            for (String keyValuePair : paraString.split(",")) {
                String[] keyValue = keyValuePair.split("=", 2);
                if (keyValue.length != 2 || retValue.containsKey(keyValue[0])) continue;
                retValue.put(keyValue[0], keyValue[1]);
            }
        }
        return retValue;
    }

    private Path getResFile() {
        return SessionState.getLocalSessionPath(this.conf);
    }

    private static void handleUnsupportedOperation(HiveParserASTNode astNode) {
        throw new ValidationException(null, (Throwable)new UnsupportedOperationException("Unsupported operation: " + astNode));
    }

    private static void handleUnsupportedOperation(String message) {
        throw new ValidationException(null, (Throwable)new UnsupportedOperationException(message));
    }

    static {
        TokenToTypeName.put(700, "boolean");
        TokenToTypeName.put(989, "tinyint");
        TokenToTypeName.put(937, "smallint");
        TokenToTypeName.put(787, "int");
        TokenToTypeName.put(697, "bigint");
        TokenToTypeName.put(762, "float");
        TokenToTypeName.put(742, "double");
        TokenToTypeName.put(942, "string");
        TokenToTypeName.put(703, "char");
        TokenToTypeName.put(1014, "varchar");
        TokenToTypeName.put(698, "binary");
        TokenToTypeName.put(725, "date");
        TokenToTypeName.put(727, "datetime");
        TokenToTypeName.put(987, "timestamp");
        TokenToTypeName.put(798, "interval_year_month");
        TokenToTypeName.put(791, "interval_day_time");
        TokenToTypeName.put(730, "decimal");
    }

    private static class QualifiedNameUtil {
        private QualifiedNameUtil() {
        }

        public static String getFullyQualifiedName(HiveParserASTNode ast) {
            if (ast.getChildCount() == 0) {
                return ast.getText();
            }
            if (ast.getChildCount() == 2) {
                return QualifiedNameUtil.getFullyQualifiedName((HiveParserASTNode)ast.getChild(0)) + "." + QualifiedNameUtil.getFullyQualifiedName((HiveParserASTNode)ast.getChild(1));
            }
            if (ast.getChildCount() == 3) {
                return QualifiedNameUtil.getFullyQualifiedName((HiveParserASTNode)ast.getChild(0)) + "." + QualifiedNameUtil.getFullyQualifiedName((HiveParserASTNode)ast.getChild(1)) + "." + QualifiedNameUtil.getFullyQualifiedName((HiveParserASTNode)ast.getChild(2));
            }
            return null;
        }

        public static String getColPath(HiveParserASTNode node, String dbName, String tableName, Map<String, String> partSpec) {
            if (node.getChildCount() == 1) {
                return tableName;
            }
            HiveParserASTNode columnNode = null;
            if (node.getChildCount() > 1) {
                columnNode = partSpec == null ? (HiveParserASTNode)node.getChild(1) : (HiveParserASTNode)node.getChild(2);
            }
            if (columnNode != null) {
                if (dbName == null) {
                    return tableName + "." + QualifiedNameUtil.getFullyQualifiedName(columnNode);
                }
                return tableName.substring(dbName.length() + 1, tableName.length()) + "." + QualifiedNameUtil.getFullyQualifiedName(columnNode);
            }
            return tableName;
        }

        public static Map<String, String> getPartitionSpec(HiveCatalog db, HiveParserASTNode ast, ObjectPath tablePath) throws SemanticException {
            HiveParserASTNode partNode = null;
            if (ast.getChildCount() == 1) {
                return null;
            }
            if (ast.getChildCount() > 2 && ast.getChild(1).getType() != 859) {
                throw new ValidationException(ast.getChild(1).getType() + " is not a partition specification");
            }
            if (ast.getChild(1).getType() == 859) {
                partNode = (HiveParserASTNode)ast.getChild(1);
            }
            if (partNode != null) {
                return HiveParserDDLSemanticAnalyzer.getPartSpec(partNode);
            }
            return null;
        }
    }
}

